/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.internal.ui.RubyExplorerTracker;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.wizards.OpenNewRubyProjectWizardAction;

public class RubyProjectSelectionAction
extends Action
implements IMenuCreator {
    private Menu fMenu;
    private RubyExplorerTracker.IRubyProjectListener listener;

    public RubyProjectSelectionAction() {
        this("Select Ruby Project");
    }

    public RubyProjectSelectionAction(String tooltip) {
        this.setEnabled(RubyCore.getRubyProjects().length > 0);
        this.setToolTipText(tooltip);
        this.setImageDescriptor(RubyPlugin.getImageDescriptor("icons/full/etool16/ruby_project.png"));
        this.setMenuCreator(this);
        ResourcesPlugin.getWorkspace().addResourceChangeListener(new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent event) {
                IResource source = event.getResource();
                if (source != null) {
                    return;
                }
                IResourceDelta[] deltas = event.getDelta().getAffectedChildren(7, 4);
                if (deltas != null && deltas.length > 0) {
                    Display.getDefault().asyncExec(new Runnable(){

                        public void run() {
                            if (RubyProjectSelectionAction.this.fMenu != null && !RubyProjectSelectionAction.this.fMenu.isDisposed()) {
                                RubyProjectSelectionAction.this.fMenu.dispose();
                            }
                            RubyProjectSelectionAction.this.fMenu = null;
                            RubyProjectSelectionAction.this.setEnabled(RubyCore.getRubyProjects().length > 0);
                        }
                    });
                }
            }
        }, 1);
    }

    public void dispose() {
    }

    public Menu getMenu(Control parent) {
        IProject[] projects;
        if (this.fMenu != null && !this.fMenu.isDisposed()) {
            this.fMenu.dispose();
        }
        this.fMenu = new Menu(parent);
        int accel = 1;
        IProject[] iProjectArray = projects = RubyCore.getRubyProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            String label = project.getName();
            ImageDescriptor image = null;
            this.addActionToMenu(this.fMenu, new RubyProjectAction(label, image, project), accel);
            ++accel;
            ++n2;
        }
        MenuItem addProjectItem = new MenuItem(this.fMenu, 8);
        addProjectItem.setText("Create new Ruby project");
        final Image projectImage = RubyPlugin.getImageDescriptor("icons/full/etool16/newrprj_wiz.gif").createImage();
        addProjectItem.setImage(projectImage);
        addProjectItem.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (projectImage != null && !projectImage.isDisposed()) {
                    projectImage.dispose();
                }
            }
        });
        addProjectItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                new OpenNewRubyProjectWizardAction().run();
            }
        });
        return this.fMenu;
    }

    private void addActionToMenu(Menu parent, Action action, int accelerator) {
        if (accelerator < 10) {
            StringBuffer label = new StringBuffer();
            label.append('&');
            label.append(accelerator);
            label.append(' ');
            label.append(action.getText());
            action.setText(label.toString());
        }
        ActionContributionItem item = new ActionContributionItem((IAction)action);
        item.fill(parent, -1);
    }

    public Menu getMenu(Menu parent) {
        return null;
    }

    public RubyExplorerTracker.IRubyProjectListener getListener() {
        return this.listener;
    }

    public void setListener(RubyExplorerTracker.IRubyProjectListener listener) {
        this.listener = listener;
    }

    private class RubyProjectAction
    extends Action {
        private IProject project;

        public RubyProjectAction(String label, ImageDescriptor image, IProject project) {
            this.setText(label);
            if (image != null) {
                this.setImageDescriptor(image);
            }
            this.project = project;
        }

        public void run() {
            if (RubyProjectSelectionAction.this.listener != null) {
                RubyProjectSelectionAction.this.listener.projectSelected(this.project);
            }
        }

        public void runWithEvent(Event event) {
            this.run();
        }
    }
}

