/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.UIJob;
import org.rubypeople.rdt.internal.launching.LaunchingPlugin;
import org.rubypeople.rdt.internal.ui.wizards.InstallStandardRubyWizard;
import org.rubypeople.rdt.launching.IVMInstall;
import org.rubypeople.rdt.launching.RubyRuntime;

public class RubyInstalledDetector
extends UIJob {
    private static boolean fgFinished;

    public RubyInstalledDetector() {
        super("Detecting Ruby installation");
    }

    private boolean usingIncludedJRuby() {
        Preferences store = LaunchingPlugin.getDefault().getPluginPreferences();
        if (store == null) {
            return false;
        }
        return store.getBoolean("org.rubypeople.rdt.launching.us.included.jruby");
    }

    private boolean rubyInstalled() {
        return !this.rubyNotInstalled();
    }

    private boolean rubyNotInstalled() {
        IVMInstall[] cRubyInstalls = RubyRuntime.getVMInstallType((String)"org.rubypeople.rdt.launching.StandardVMType").getVMInstalls();
        return cRubyInstalls == null || cRubyInstalls.length == 0;
    }

    public IStatus runInUIThread(IProgressMonitor monitor) {
        if (this.rubyInstalled() || this.usingIncludedJRuby()) {
            RubyInstalledDetector.markFinished();
            return Status.CANCEL_STATUS;
        }
        IWorkbench workbench = PlatformUI.getWorkbench();
        InstallStandardRubyWizard wizard = new InstallStandardRubyWizard();
        wizard.init(workbench, null);
        WizardDialog dialog = new WizardDialog(workbench.getDisplay().getActiveShell(), (IWizard)wizard);
        dialog.open();
        monitor.done();
        return Status.OK_STATUS;
    }

    public static void markFinished() {
        fgFinished = true;
    }

    public static boolean isFinished() {
        return fgFinished;
    }
}

