/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchListener;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.views.console.ProcessConsole;
import org.eclipse.debug.internal.ui.views.console.ProcessConsoleManager;
import org.eclipse.debug.ui.console.IConsoleColorProvider;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.launching.IRubyLaunchConfigurationConstants;
import org.rubypeople.rdt.launching.ITerminal;

public class AptanaProcessConsoleManager
extends ProcessConsoleManager {
    private static final String RESET_AUTO_REMOVE_TERMINATED_LAUNCHES_PREF = "RESET_AUTO_REMOVE_TERMINATED_LAUNCHES_PREF";
    private static final String TERMINALS_EXTENSION_POINT = "org.rubypeople.rdt.launching.terminals";

    public AptanaProcessConsoleManager() {
        if (RubyPlugin.getDefault().getPreferenceStore().getBoolean(RESET_AUTO_REMOVE_TERMINATED_LAUNCHES_PREF)) {
            return;
        }
        if (!DebugUIPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.debug.ui.auto_remove_old_launches")) {
            DebugUIPlugin.getDefault().getPreferenceStore().setValue("org.eclipse.debug.ui.auto_remove_old_launches", true);
            RubyPlugin.getDefault().getPreferenceStore().setValue(RESET_AUTO_REMOVE_TERMINATED_LAUNCHES_PREF, true);
        }
    }

    public void launchChanged(final ILaunch launch) {
        String force;
        String terminalType = launch.getAttribute(IRubyLaunchConfigurationConstants.ATTR_USE_TERMINAL);
        IConsole console = this.findConsole(terminalType);
        if (console != null) {
            if (console instanceof ITerminal) {
                String command;
                IProject project;
                ITerminal terminal = (ITerminal)console;
                String projectName = launch.getAttribute(IRubyLaunchConfigurationConstants.ATTR_PROJECT_NAME);
                if (projectName != null && (project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName)) != null) {
                    terminal.setProject(project);
                }
                if ((command = launch.getAttribute(IRubyLaunchConfigurationConstants.ATTR_TERMINAL_COMMAND)) != null) {
                    terminal.write("org.eclipse.debug.ui.ID_STANDARD_INPUT_STREAM", String.valueOf(command) + "\n");
                }
                if (launch.getProcesses() != null && launch.getProcesses().length > 0) {
                    terminal.attach(launch.getProcesses()[0]);
                }
                return;
            }
            String toDisplay = this.getDisplayString(launch);
            if (toDisplay == null) {
                toDisplay = terminalType;
            }
            Job job = new Job(toDisplay){

                protected IStatus run(IProgressMonitor monitor) {
                    while (!launch.isTerminated()) {
                        if (monitor.isCanceled()) {
                            try {
                                launch.terminate();
                            }
                            catch (DebugException e) {
                                RubyPlugin.log(e);
                            }
                            return Status.CANCEL_STATUS;
                        }
                        Thread.yield();
                    }
                    monitor.done();
                    return Status.OK_STATUS;
                }
            };
            job.setPriority(50);
            job.schedule();
        }
        if ((force = launch.getAttribute(IRubyLaunchConfigurationConstants.ATTR_FORCE_NO_CONSOLE)) != null && Boolean.parseBoolean(force)) {
            this.handleButDontAddConsole(launch);
        } else {
            super.launchChanged(launch);
        }
    }

    private String getDisplayString(ILaunch launch) {
        String args;
        StringBuffer buffer = new StringBuffer();
        String fileName = launch.getAttribute(IRubyLaunchConfigurationConstants.ATTR_FILE_NAME);
        if (fileName != null) {
            buffer.append(fileName);
        }
        if ((args = launch.getAttribute(IRubyLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS)) != null) {
            buffer.append(" " + args);
        }
        if (buffer.toString().length() == 0) {
            return null;
        }
        return buffer.toString();
    }

    private IConsole findConsole(String type) {
        IConsole[] consoles = ConsolePlugin.getDefault().getConsoleManager().getConsoles();
        int i = 0;
        while (i < consoles.length) {
            if (consoles[i].getType().equals(type)) {
                return consoles[i];
            }
            ++i;
        }
        ITerminal terminal = AptanaProcessConsoleManager.getTerminal(type);
        if (terminal != null) {
            ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{terminal});
            terminal.activate();
        }
        return terminal;
    }

    public static ITerminal getTerminal(String id) {
        try {
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IConfigurationElement[] elements = registry.getConfigurationElementsFor(TERMINALS_EXTENSION_POINT);
            int i = 0;
            while (i < elements.length) {
                String terminalId = elements[i].getAttribute("id");
                if (terminalId.equals(id)) {
                    return (ITerminal)elements[i].createExecutableExtension("class");
                }
                ++i;
            }
        }
        catch (InvalidRegistryObjectException e) {
            RubyPlugin.log(e);
        }
        catch (CoreException e) {
            RubyPlugin.log(e);
        }
        return null;
    }

    public void launchAdded(ILaunch launch) {
        DebugPlugin.getDefault().getLaunchManager().removeLaunchListener((ILaunchListener)DebugUIPlugin.getDefault().getProcessConsoleManager());
        super.launchAdded(launch);
    }

    private void handleButDontAddConsole(ILaunch launch) {
        IProcess[] processes = launch.getProcesses();
        int i = 0;
        while (i < processes.length) {
            IProcess process;
            if (this.getConsoleDocument(processes[i]) == null && (process = processes[i]).getStreamsProxy() != null) {
                ILaunchConfiguration launchConfiguration = launch.getLaunchConfiguration();
                IConsoleColorProvider colorProvider = this.getColorProvider(process.getAttribute(IProcess.ATTR_PROCESS_TYPE));
                String encoding = null;
                try {
                    if (launchConfiguration != null) {
                        encoding = launchConfiguration.getAttribute("org.eclipse.debug.ui.ATTR_CONSOLE_ENCODING", null);
                    }
                }
                catch (CoreException coreException) {}
                new ProcessConsole(process, colorProvider, encoding);
            }
            ++i;
        }
    }
}

