/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.corext.util;

import org.rubypeople.rdt.core.search.IRubySearchScope;
import org.rubypeople.rdt.core.search.SearchEngine;
import org.rubypeople.rdt.core.search.SearchPattern;
import org.rubypeople.rdt.internal.corext.util.SearchUtils;
import org.rubypeople.rdt.internal.corext.util.Strings;
import org.rubypeople.rdt.internal.corext.util.TypeInfo;
import org.rubypeople.rdt.internal.ui.util.StringMatcher;
import org.rubypeople.rdt.ui.dialogs.ITypeInfoFilterExtension;

public class TypeInfoFilter {
    private String fText;
    private IRubySearchScope fSearchScope;
    private boolean fIsWorkspaceScope;
    private int fElementKind;
    private ITypeInfoFilterExtension fFilterExtension;
    private TypeInfo.TypeInfoAdapter fAdapter = new TypeInfo.TypeInfoAdapter();
    private PatternMatcher fNamespaceMatcher;
    private PatternMatcher fNameMatcher;

    public TypeInfoFilter(String text, IRubySearchScope scope, int elementKind, ITypeInfoFilterExtension extension) {
        this.fText = text;
        this.fSearchScope = scope;
        this.fIsWorkspaceScope = this.fSearchScope.equals(SearchEngine.createWorkspaceScope());
        this.fElementKind = elementKind;
        this.fFilterExtension = extension;
        int index = text.lastIndexOf("::");
        if (index == -1) {
            this.fNameMatcher = new PatternMatcher(text, true);
        } else {
            this.fNamespaceMatcher = new PatternMatcher(text.substring(0, index), true);
            String name = text.substring(index + 2);
            if (name.length() == 0) {
                name = "*";
            }
            this.fNameMatcher = new PatternMatcher(name, true);
        }
    }

    public String getText() {
        return this.fText;
    }

    public boolean isSubFilter(String text) {
        if (!this.fText.startsWith(text)) {
            return false;
        }
        if (text.endsWith("::") && !text.equals(this.fText)) {
            return false;
        }
        return this.fText.indexOf("::", text.length()) == -1;
    }

    public boolean isCamelCasePattern() {
        return this.fNameMatcher.getMatchKind() == 128;
    }

    public String getPackagePattern() {
        if (this.fNamespaceMatcher == null) {
            return null;
        }
        return this.fNamespaceMatcher.getPattern();
    }

    public String getNamePattern() {
        return this.fNameMatcher.getPattern();
    }

    public int getSearchFlags() {
        if (this.fNamespaceMatcher != null) {
            int matchKind = this.fNamespaceMatcher.getMatchKind();
            int nameKind = this.fNameMatcher.getMatchKind();
            if (matchKind == 128 || nameKind == 128) {
                return 128;
            }
            if (matchKind == 2 || nameKind == 2) {
                return 2;
            }
            if (matchKind == 1 || nameKind == 1) {
                return 1;
            }
        }
        return this.fNameMatcher.getMatchKind();
    }

    public boolean matchesRawNamePattern(TypeInfo type) {
        return Strings.startsWithIgnoreCase(type.getTypeName(), this.fNameMatcher.getPattern());
    }

    public boolean matchesCachedResult(TypeInfo type) {
        if (!this.matchesNamespace(type) || !this.matchesFilterExtension(type)) {
            return false;
        }
        return this.matchesName(type);
    }

    public boolean matchesHistoryElement(TypeInfo type) {
        if (!(this.matchesNamespace(type) && this.matchesModifiers(type) && this.matchesScope(type) && this.matchesFilterExtension(type))) {
            return false;
        }
        return this.matchesName(type);
    }

    public boolean matchesFilterExtension(TypeInfo type) {
        if (this.fFilterExtension == null) {
            return true;
        }
        this.fAdapter.setInfo(type);
        return this.fFilterExtension.select(this.fAdapter);
    }

    private boolean matchesName(TypeInfo type) {
        return this.fNameMatcher.matches(type.getTypeName());
    }

    private boolean matchesNamespace(TypeInfo type) {
        if (this.fNamespaceMatcher == null) {
            return true;
        }
        return this.fNamespaceMatcher.matches(type.getEnclosingName());
    }

    private boolean matchesScope(TypeInfo type) {
        if (this.fIsWorkspaceScope) {
            return true;
        }
        return type.isEnclosed(this.fSearchScope);
    }

    private boolean matchesModifiers(TypeInfo type) {
        if (this.fElementKind == 0) {
            return true;
        }
        boolean isModule = type.isModule();
        switch (this.fElementKind) {
            case 4: {
                return !isModule;
            }
            case 5: {
                return isModule;
            }
        }
        return false;
    }

    private static class PatternMatcher {
        private String fPattern;
        private int fMatchKind;
        private StringMatcher fStringMatcher;
        private static final char END_SYMBOL = '<';
        private static final char ANY_STRING = '*';
        private static final char BLANK = ' ';

        public PatternMatcher(String pattern, boolean ignoreCase) {
            this(pattern, 131);
        }

        public PatternMatcher(String pattern, int allowedModes) {
            this.initializePatternAndMatchKind(pattern);
            this.fMatchKind &= allowedModes;
            if (this.fMatchKind == 2) {
                this.fStringMatcher = new StringMatcher(this.fPattern, true, false);
            }
        }

        public String getPattern() {
            return this.fPattern;
        }

        public int getMatchKind() {
            return this.fMatchKind;
        }

        public boolean matches(String text) {
            switch (this.fMatchKind) {
                case 2: {
                    return this.fStringMatcher.match(text);
                }
                case 0: {
                    return this.fPattern.equalsIgnoreCase(text);
                }
                case 128: {
                    if (!SearchPattern.camelCaseMatch((String)this.fPattern, (String)text)) break;
                    return true;
                }
            }
            return Strings.startsWithIgnoreCase(text, this.fPattern);
        }

        private void initializePatternAndMatchKind(String pattern) {
            int length = pattern.length();
            if (length == 0) {
                this.fMatchKind = 0;
                this.fPattern = pattern;
                return;
            }
            char last = pattern.charAt(length - 1);
            if (pattern.indexOf(42) != -1 || pattern.indexOf(63) != -1) {
                this.fMatchKind = 2;
                switch (last) {
                    case '<': {
                        this.fPattern = pattern.substring(0, length - 1);
                        break;
                    }
                    case ' ': {
                        this.fPattern = pattern.trim();
                        break;
                    }
                    case '*': {
                        this.fPattern = pattern;
                        break;
                    }
                    default: {
                        this.fPattern = String.valueOf(pattern) + '*';
                    }
                }
                return;
            }
            if (last == '<') {
                this.fMatchKind = 0;
                this.fPattern = pattern.substring(0, length - 1);
                return;
            }
            if (last == ' ') {
                this.fMatchKind = 0;
                this.fPattern = pattern.trim();
                return;
            }
            if (SearchUtils.isCamelCasePattern(pattern)) {
                this.fMatchKind = 128;
                this.fPattern = pattern;
                return;
            }
            this.fMatchKind = 1;
            this.fPattern = pattern;
        }
    }
}

