/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.corext.util;

import org.eclipse.core.runtime.IPath;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.core.IType;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.core.search.IRubySearchScope;
import org.rubypeople.rdt.internal.core.util.CharOperation;
import org.rubypeople.rdt.internal.corext.util.RubyModelUtil;
import org.rubypeople.rdt.ui.dialogs.ITypeInfoRequestor;

public abstract class TypeInfo {
    final String fName;
    final String fPackage;
    final char[][] fEnclosingNames;
    private boolean fIsModule;
    public static final int UNRESOLVABLE_TYPE_INFO = 1;
    public static final int JAR_FILE_ENTRY_TYPE_INFO = 2;
    public static final int IFILE_TYPE_INFO = 3;
    static final char SEPARATOR = '/';
    static final char EXTENSION_SEPARATOR = '.';
    static final char PACKAGE_PART_SEPARATOR = '.';
    static final String EMPTY_STRING = "";

    protected TypeInfo(String pkg, String name, char[][] enclosingTypes, boolean isModule) {
        this.fPackage = pkg;
        this.fName = name;
        this.fIsModule = isModule;
        this.fEnclosingNames = enclosingTypes;
    }

    public int hashCode() {
        return (this.fPackage.hashCode() << 16) + this.fName.hashCode();
    }

    public abstract int getElementType();

    public abstract String getPath();

    protected abstract IRubyElement getContainer(IRubySearchScope var1) throws RubyModelException;

    public abstract IPath getPackageFragmentRootPath();

    public abstract String getPackageFragmentRootName();

    public String getTypeName() {
        return this.fName;
    }

    public String getPackageName() {
        return this.fPackage;
    }

    public boolean isModule() {
        return this.fIsModule;
    }

    public boolean isEnclosed(IRubySearchScope scope) {
        return scope.encloses(this.getPath());
    }

    public String getEnclosingName() {
        if (this.fEnclosingNames == null || this.fEnclosingNames.length == 0) {
            return EMPTY_STRING;
        }
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < this.fEnclosingNames.length) {
            if (i != 0) {
                buf.append("::");
            }
            buf.append(this.fEnclosingNames[i]);
            ++i;
        }
        return buf.toString();
    }

    public boolean isInnerType() {
        return this.fEnclosingNames != null && this.fEnclosingNames.length > 0;
    }

    public String getTypeQualifiedName() {
        if (this.fEnclosingNames != null && this.fEnclosingNames.length > 0) {
            StringBuffer buf = new StringBuffer();
            int i = 0;
            while (i < this.fEnclosingNames.length) {
                buf.append(this.fEnclosingNames[i]);
                buf.append("::");
                ++i;
            }
            buf.append(this.fName);
            return buf.toString();
        }
        return this.fName;
    }

    public String getFullyQualifiedName() {
        StringBuffer buf = new StringBuffer();
        if (this.fPackage.length() > 0) {
            buf.append(this.fPackage);
            buf.append('.');
        }
        if (this.fEnclosingNames != null) {
            int i = 0;
            while (i < this.fEnclosingNames.length) {
                buf.append(this.fEnclosingNames[i]);
                buf.append('.');
                ++i;
            }
        }
        buf.append(this.fName);
        return buf.toString();
    }

    public String getTypeContainerName() {
        if (this.fEnclosingNames != null && this.fEnclosingNames.length > 0) {
            StringBuffer buf = new StringBuffer();
            if (this.fPackage.length() > 0) {
                buf.append(this.fPackage);
            }
            int i = 0;
            while (i < this.fEnclosingNames.length) {
                if (buf.length() > 0) {
                    buf.append("::");
                }
                buf.append(this.fEnclosingNames[i]);
                ++i;
            }
            return buf.toString();
        }
        return this.fPackage;
    }

    public IType resolveType(IRubySearchScope scope) throws RubyModelException {
        IRubyElement elem = this.getContainer(scope);
        if (elem instanceof IRubyScript) {
            return RubyModelUtil.findTypeInRubyScript((IRubyScript)elem, this.getTypeQualifiedName());
        }
        return null;
    }

    protected boolean doEquals(TypeInfo other) {
        return this.fName.equals(other.fName) && this.fPackage.equals(other.fPackage) && CharOperation.equals((char[][])this.fEnclosingNames, (char[][])other.fEnclosingNames);
    }

    protected static boolean equals(String s1, String s2) {
        if (s1 == null || s2 == null) {
            return s1 == s2;
        }
        return s1.equals(s2);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("path= ");
        buf.append(this.getPath());
        buf.append("; pkg= ");
        buf.append(this.fPackage);
        buf.append("; enclosing= ");
        buf.append(this.getEnclosingName());
        buf.append("; name= ");
        buf.append(this.fName);
        return buf.toString();
    }

    public abstract long getContainerTimestamp();

    public abstract boolean isContainerDirty();

    public void setIsModule(boolean b) {
        this.fIsModule = b;
    }

    public static class TypeInfoAdapter
    implements ITypeInfoRequestor {
        private TypeInfo fInfo;

        public void setInfo(TypeInfo info) {
            this.fInfo = info;
        }

        public boolean isModule() {
            return this.fInfo.isModule();
        }

        public String getTypeName() {
            return this.fInfo.getTypeName();
        }

        public String getPackageName() {
            return this.fInfo.getPackageName();
        }

        public String getEnclosingName() {
            return this.fInfo.getEnclosingName();
        }
    }
}

