/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.corext.util;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultLineTracker;
import org.eclipse.jface.text.IRegion;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.core.formatter.IndentManipulation;
import org.rubypeople.rdt.internal.corext.util.CodeFormatterUtil;

public class Strings {
    public static int computeIndentUnits(String line, IRubyProject project) {
        return Strings.computeIndentUnits(line, CodeFormatterUtil.getTabWidth(project), CodeFormatterUtil.getIndentWidth(project));
    }

    public static int computeIndentUnits(String line, int tabWidth, int indentWidth) {
        if (indentWidth == 0) {
            return -1;
        }
        int visualLength = Strings.measureIndentLength(line, tabWidth);
        return visualLength / indentWidth;
    }

    public static int measureIndentLength(CharSequence line, int tabSize) {
        int length = 0;
        int max = line.length();
        int i = 0;
        while (i < max) {
            char ch = line.charAt(i);
            if (ch == '\t') {
                int reminder = length % tabSize;
                length += tabSize - reminder;
            } else if (Strings.isIndentChar(ch)) {
                ++length;
            } else {
                return length;
            }
            ++i;
        }
        return length;
    }

    public static boolean isIndentChar(char ch) {
        return Character.isWhitespace(ch) && !Strings.isLineDelimiterChar(ch);
    }

    public static boolean isLineDelimiterChar(char ch) {
        return ch == '\n' || ch == '\r';
    }

    public static boolean containsOnlyWhitespaces(String s) {
        int size = s.length();
        int i = 0;
        while (i < size) {
            if (!Character.isWhitespace(s.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean equals(String s, char[] c) {
        if (s.length() != c.length) {
            return false;
        }
        int i = c.length;
        while (--i >= 0) {
            if (s.charAt(i) == c[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean startsWithIgnoreCase(String text, String prefix) {
        int prefixLength;
        int textLength = text.length();
        if (textLength < (prefixLength = prefix.length())) {
            return false;
        }
        int i = prefixLength - 1;
        while (i >= 0) {
            if (Character.toLowerCase(prefix.charAt(i)) != Character.toLowerCase(text.charAt(i))) {
                return false;
            }
            --i;
        }
        return true;
    }

    public static boolean isLowerCase(char ch) {
        return Character.toLowerCase(ch) == ch;
    }

    public static String removeMnemonicIndicator(String string) {
        int length = string.length();
        StringBuffer result = new StringBuffer(length);
        int lastChar = 32;
        int i = 0;
        while (i < length) {
            char ch = string.charAt(i);
            if (ch != '&' || lastChar == 38) {
                result.append(ch);
            }
            lastChar = ch;
            ++i;
        }
        return result.toString();
    }

    public static String[] convertIntoLines(String input) {
        try {
            DefaultLineTracker tracker = new DefaultLineTracker();
            tracker.set(input);
            int size = tracker.getNumberOfLines();
            String[] result = new String[size];
            int i = 0;
            while (i < size) {
                IRegion region = tracker.getLineInformation(i);
                int offset = region.getOffset();
                result[i] = input.substring(offset, offset + region.getLength());
                ++i;
            }
            return result;
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    public static void trimIndentation(String[] lines, IRubyProject project) {
        Strings.trimIndentation(lines, CodeFormatterUtil.getTabWidth(project), CodeFormatterUtil.getIndentWidth(project), true);
    }

    public static void trimIndentation(String[] lines, int tabWidth, int indentWidth, boolean considerFirstLine) {
        String[] toDo = new String[lines.length];
        int minIndent = Integer.MAX_VALUE;
        int i = considerFirstLine ? 0 : 1;
        while (i < lines.length) {
            String line = lines[i];
            if (!Strings.containsOnlyWhitespaces(line)) {
                toDo[i] = line;
                int indent = Strings.computeIndentUnits(line, tabWidth, indentWidth);
                if (indent < minIndent) {
                    minIndent = indent;
                }
            }
            ++i;
        }
        if (minIndent > 0) {
            i = considerFirstLine ? 0 : 1;
            while (i < toDo.length) {
                String line;
                int indent;
                String s = toDo[i];
                lines[i] = s != null ? Strings.trimIndent(s, minIndent, tabWidth, indentWidth) : ((indent = Strings.computeIndentUnits(line = lines[i], tabWidth, indentWidth)) > minIndent ? Strings.trimIndent(line, minIndent, tabWidth, indentWidth) : Strings.trimLeadingTabsAndSpaces(line));
                ++i;
            }
        }
    }

    public static String trimIndent(String line, int indentsToRemove, int tabWidth, int indentWidth) {
        return IndentManipulation.trimIndent((String)line, (int)indentsToRemove, (int)tabWidth, (int)indentWidth);
    }

    public static String trimLeadingTabsAndSpaces(String line) {
        int size;
        int start = size = line.length();
        int i = 0;
        while (i < size) {
            char c = line.charAt(i);
            if (!IndentManipulation.isIndentChar((char)c)) {
                start = i;
                break;
            }
            ++i;
        }
        if (start == 0) {
            return line;
        }
        if (start == size) {
            return "";
        }
        return line.substring(start);
    }

    public static String concatenate(String[] lines, String delimiter) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < lines.length) {
            if (i > 0) {
                buffer.append(delimiter);
            }
            buffer.append(lines[i]);
            ++i;
        }
        return buffer.toString();
    }
}

