/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.corext.util;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.rubypeople.rdt.core.Flags;
import org.rubypeople.rdt.core.IMember;
import org.rubypeople.rdt.core.IMethod;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.core.ISourceFolder;
import org.rubypeople.rdt.core.ISourceFolderRoot;
import org.rubypeople.rdt.core.IType;
import org.rubypeople.rdt.core.ITypeHierarchy;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.core.util.CharOperation;
import org.rubypeople.rdt.internal.ui.RubyPlugin;

public final class RubyModelUtil {
    public static final String DEFAULT_SCRIPT_SUFFIX = ".rb";
    private static boolean PRIMARY_ONLY = false;

    public static IRubyScript toOriginal(IRubyScript cu) {
        if (PRIMARY_ONLY) {
            RubyModelUtil.testRubyScriptOwner("toOriginal", cu);
        }
        if (cu == null) {
            return cu;
        }
        return cu.getPrimary();
    }

    private static void testRubyScriptOwner(String methodName, IRubyScript cu) {
        if (cu == null) {
            return;
        }
        if (!RubyModelUtil.isPrimary(cu)) {
            RubyPlugin.logErrorMessage(String.valueOf(methodName) + ": operating with non-primary cu");
        }
    }

    public static boolean isPrimary(IRubyScript cu) {
        return cu.getOwner() == null;
    }

    public static void reconcile(IRubyScript unit) throws RubyModelException {
        unit.reconcile(false, null, null);
    }

    public static IRubyElement toOriginal(IRubyElement element) {
        return element.getPrimaryElement();
    }

    public static ISourceFolderRoot getSourceFolderRoot(IRubyElement element) {
        return (ISourceFolderRoot)element.getAncestor(2);
    }

    public static ISourceFolder getSourceFolder(IRubyElement element) {
        ISourceFolder srcFolder = (ISourceFolder)element.getAncestor(3);
        if (srcFolder == null) {
            IRubyProject proj = element.getRubyProject();
            ISourceFolderRoot root = proj.getSourceFolderRoot(proj.getResource());
            return root.getSourceFolder("");
        }
        return srcFolder;
    }

    public static boolean isExcludedPath(IPath resourcePath, IPath[] exclusionPatterns) {
        char[] path = resourcePath.toString().toCharArray();
        int i = 0;
        int length = exclusionPatterns.length;
        while (i < length) {
            char[] pattern = exclusionPatterns[i].toString().toCharArray();
            if (CharOperation.pathMatch((char[])pattern, (char[])path, (boolean)true, (char)'/')) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static String concatenateName(char[] name1, char[] name2) {
        StringBuffer buf = new StringBuffer();
        if (name1 != null && name1.length > 0) {
            buf.append(name1);
        }
        if (name2 != null && name2.length > 0) {
            if (buf.length() > 0) {
                buf.append("/");
            }
            buf.append(name2);
        }
        return buf.toString();
    }

    public static String getFullyQualifiedName(IType type) {
        return type.getFullyQualifiedName();
    }

    public static IType findTypeInRubyScript(IRubyScript script, String typeQualifiedName) throws RubyModelException {
        IType[] types = script.getAllTypes();
        int i = 0;
        while (i < types.length) {
            String currName = RubyModelUtil.getTypeQualifiedName(types[i]);
            if (typeQualifiedName.equals(currName)) {
                return types[i];
            }
            ++i;
        }
        return null;
    }

    public static String getTypeQualifiedName(IType type) {
        return type.getTypeQualifiedName("::");
    }

    public static boolean isExceptionToBeLogged(CoreException exception) {
        if (!(exception instanceof RubyModelException)) {
            return true;
        }
        RubyModelException je = (RubyModelException)((Object)exception);
        if (!je.isDoesNotExist()) {
            return true;
        }
        IRubyElement[] elements = je.getRubyModelStatus().getElements();
        int i = 0;
        while (i < elements.length) {
            IRubyElement element = elements[i];
            if (element.getElementType() != 4) {
                IRubyScript unit = (IRubyScript)element.getAncestor(4);
                if (unit == null) {
                    return true;
                }
                if (!unit.isWorkingCopy()) {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    public static boolean isSuperType(ITypeHierarchy hierarchy, IType possibleSuperType, IType type) {
        IType superClass = hierarchy.getSuperclass(type);
        if (superClass != null && (possibleSuperType.equals(superClass) || RubyModelUtil.isSuperType(hierarchy, possibleSuperType, superClass))) {
            return true;
        }
        if (Flags.isModule((int)hierarchy.getCachedFlags(possibleSuperType))) {
            IType[] superInterfaces = hierarchy.getSuperModules(type);
            int i = 0;
            while (i < superInterfaces.length) {
                IType curr = superInterfaces[i];
                if (possibleSuperType.equals(curr) || RubyModelUtil.isSuperType(hierarchy, possibleSuperType, curr)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public static boolean isVisibleInHierarchy(IMember member, ISourceFolder pack) throws RubyModelException {
        if (member.isType(7)) {
            return true;
        }
        if (!member.isType(6)) {
            return false;
        }
        IMethod method = (IMethod)member;
        IType declaringType = member.getDeclaringType();
        if (method.getVisibility() == 1 || method.getVisibility() == 4 || declaringType != null && declaringType.isModule()) {
            return true;
        }
        if (method.getVisibility() == 2) {
            return false;
        }
        ISourceFolder otherpack = (ISourceFolder)member.getAncestor(3);
        return pack != null && pack.equals(otherpack);
    }

    public static IMethod findMethodInHierarchy(ITypeHierarchy hierarchy, IType type, String name, String[] paramTypes, boolean isConstructor) throws RubyModelException {
        IMethod res;
        IMethod method = RubyModelUtil.findMethod(name, paramTypes, isConstructor, type);
        if (method != null) {
            return method;
        }
        IType superClass = hierarchy.getSuperclass(type);
        if (superClass != null && (res = RubyModelUtil.findMethodInHierarchy(hierarchy, superClass, name, paramTypes, isConstructor)) != null) {
            return res;
        }
        if (!isConstructor) {
            IType[] superInterfaces = hierarchy.getSuperModules(type);
            int i = 0;
            while (i < superInterfaces.length) {
                IMethod res2 = RubyModelUtil.findMethodInHierarchy(hierarchy, superInterfaces[i], name, paramTypes, false);
                if (res2 != null) {
                    return res2;
                }
                ++i;
            }
        }
        return method;
    }

    public static IMethod findMethod(String name, String[] paramTypes, boolean isConstructor, IType type) throws RubyModelException {
        IMethod[] methods = type.getMethods();
        int i = 0;
        while (i < methods.length) {
            if (RubyModelUtil.isSameMethodSignature(name, paramTypes, isConstructor, methods[i])) {
                return methods[i];
            }
            ++i;
        }
        return null;
    }

    public static boolean isSameMethodSignature(String name, String[] paramTypes, boolean isConstructor, IMethod curr) throws RubyModelException {
        return (isConstructor || name.equals(curr.getElementName())) && isConstructor == curr.isConstructor();
    }
}

