/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.corext.util;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.mapping.RemoteResourceMappingContext;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyModel;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.core.ISourceFolder;
import org.rubypeople.rdt.core.ISourceFolderRoot;
import org.rubypeople.rdt.core.IType;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.ui.RubyPlugin;

public abstract class RubyElementResourceMapping
extends ResourceMapping {
    protected RubyElementResourceMapping() {
    }

    public IRubyElement getRubyElement() {
        Object o = this.getModelObject();
        if (o instanceof IRubyElement) {
            return (IRubyElement)o;
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RubyElementResourceMapping)) {
            return false;
        }
        return this.getRubyElement().equals(((RubyElementResourceMapping)((Object)obj)).getRubyElement());
    }

    public int hashCode() {
        IRubyElement javaElement = this.getRubyElement();
        if (javaElement == null) {
            return super.hashCode();
        }
        return javaElement.hashCode();
    }

    public String getModelProviderId() {
        return "org.rubypeople.rdt.ui.modelProvider";
    }

    public boolean contains(ResourceMapping mapping) {
        if (mapping instanceof RubyElementResourceMapping) {
            RubyElementResourceMapping javaMapping = (RubyElementResourceMapping)mapping;
            IRubyElement element = this.getRubyElement();
            IRubyElement other = javaMapping.getRubyElement();
            if (other != null && element != null) {
                return element.getPath().isPrefixOf(other.getPath());
            }
        }
        return false;
    }

    private static IFile[] getPackageContent(ISourceFolder pack) throws CoreException {
        ArrayList<IResource> result = new ArrayList<IResource>();
        IContainer container = (IContainer)pack.getResource();
        if (container != null) {
            IResource[] members = container.members();
            int m = 0;
            while (m < members.length) {
                IFile file;
                IResource member = members[m];
                if (!(!(member instanceof IFile) || "class".equals((file = (IFile)member).getFileExtension()) && file.isDerived())) {
                    result.add(member);
                }
                ++m;
            }
        }
        return result.toArray(new IFile[result.size()]);
    }

    public static ResourceMapping create(IRubyElement element) {
        switch (element.getElementType()) {
            case 5: {
                return RubyElementResourceMapping.create((IType)element);
            }
            case 4: {
                return RubyElementResourceMapping.create((IRubyScript)element);
            }
            case 3: {
                return RubyElementResourceMapping.create((ISourceFolder)element);
            }
            case 2: {
                return RubyElementResourceMapping.create((ISourceFolderRoot)element);
            }
            case 1: {
                return RubyElementResourceMapping.create((IRubyProject)element);
            }
            case 0: {
                return RubyElementResourceMapping.create((IRubyModel)element);
            }
        }
        return null;
    }

    public static ResourceMapping create(IRubyModel model) {
        return new RubyModelResourceMapping(model);
    }

    public static ResourceMapping create(IRubyProject project) {
        return new RubyProjectResourceMapping(project);
    }

    public static ResourceMapping create(ISourceFolderRoot root) {
        if (root.isExternal()) {
            return null;
        }
        return new PackageFragementRootResourceMapping(root);
    }

    public static ResourceMapping create(ISourceFolder pack) {
        ISourceFolderRoot root = (ISourceFolderRoot)pack.getAncestor(2);
        if (!root.isExternal()) {
            return new SourceFolderResourceMapping(pack);
        }
        return null;
    }

    public static ResourceMapping create(IRubyScript unit) {
        if (unit == null) {
            return null;
        }
        return new RubyScriptResourceMapping(unit.getPrimary());
    }

    public static ResourceMapping create(IType type) {
        IRubyElement parent = type.getParent();
        if (parent instanceof IRubyScript) {
            return RubyElementResourceMapping.create((IRubyScript)parent);
        }
        return null;
    }

    private static final class LocalPackageFragementTraversal
    extends ResourceTraversal {
        private final ISourceFolder fPack;

        public LocalPackageFragementTraversal(ISourceFolder pack) throws CoreException {
            super(new IResource[]{pack.getResource()}, 1, 0);
            this.fPack = pack;
        }

        public void accept(IResourceVisitor visitor) throws CoreException {
            IFile[] files = RubyElementResourceMapping.getPackageContent(this.fPack);
            IResource resource = this.fPack.getResource();
            if (resource != null) {
                visitor.visit(resource);
            }
            int i = 0;
            while (i < files.length) {
                visitor.visit((IResource)files[i]);
                ++i;
            }
        }
    }

    private static final class PackageFragementRootResourceMapping
    extends RubyElementResourceMapping {
        private final ISourceFolderRoot fRoot;

        private PackageFragementRootResourceMapping(ISourceFolderRoot root) {
            Assert.isNotNull((Object)root);
            this.fRoot = root;
        }

        public Object getModelObject() {
            return this.fRoot;
        }

        public IProject[] getProjects() {
            return new IProject[]{this.fRoot.getRubyProject().getProject()};
        }

        public ResourceTraversal[] getTraversals(ResourceMappingContext context, IProgressMonitor monitor) throws CoreException {
            return new ResourceTraversal[]{new ResourceTraversal(new IResource[]{this.fRoot.getResource()}, 2, 0)};
        }
    }

    private static final class RubyModelResourceMapping
    extends RubyElementResourceMapping {
        private final IRubyModel fRubyModel;

        private RubyModelResourceMapping(IRubyModel model) {
            Assert.isNotNull((Object)model);
            this.fRubyModel = model;
        }

        public Object getModelObject() {
            return this.fRubyModel;
        }

        public IProject[] getProjects() {
            IRubyProject[] projects = null;
            try {
                projects = this.fRubyModel.getRubyProjects();
            }
            catch (RubyModelException e) {
                RubyPlugin.log(e);
                return new IProject[0];
            }
            IProject[] result = new IProject[projects.length];
            int i = 0;
            while (i < projects.length) {
                result[i] = projects[i].getProject();
                ++i;
            }
            return result;
        }

        public ResourceTraversal[] getTraversals(ResourceMappingContext context, IProgressMonitor monitor) throws CoreException {
            IRubyProject[] projects = this.fRubyModel.getRubyProjects();
            ResourceTraversal[] result = new ResourceTraversal[projects.length];
            int i = 0;
            while (i < projects.length) {
                result[i] = new ResourceTraversal(new IResource[]{projects[i].getProject()}, 2, 0);
                ++i;
            }
            return result;
        }
    }

    private static final class RubyProjectResourceMapping
    extends RubyElementResourceMapping {
        private final IRubyProject fProject;

        private RubyProjectResourceMapping(IRubyProject project) {
            Assert.isNotNull((Object)project);
            this.fProject = project;
        }

        public Object getModelObject() {
            return this.fProject;
        }

        public IProject[] getProjects() {
            return new IProject[]{this.fProject.getProject()};
        }

        public ResourceTraversal[] getTraversals(ResourceMappingContext context, IProgressMonitor monitor) throws CoreException {
            return new ResourceTraversal[]{new ResourceTraversal(new IResource[]{this.fProject.getProject()}, 2, 0)};
        }
    }

    private static final class RubyScriptResourceMapping
    extends RubyElementResourceMapping {
        private final IRubyScript fUnit;

        private RubyScriptResourceMapping(IRubyScript unit) {
            Assert.isNotNull((Object)unit);
            this.fUnit = unit;
        }

        public Object getModelObject() {
            return this.fUnit;
        }

        public IProject[] getProjects() {
            return new IProject[]{this.fUnit.getRubyProject().getProject()};
        }

        public ResourceTraversal[] getTraversals(ResourceMappingContext context, IProgressMonitor monitor) throws CoreException {
            return new ResourceTraversal[]{new ResourceTraversal(new IResource[]{this.fUnit.getResource()}, 1, 0)};
        }
    }

    private static final class SourceFolderResourceMapping
    extends RubyElementResourceMapping {
        private final ISourceFolder fPack;

        private SourceFolderResourceMapping(ISourceFolder pack) {
            Assert.isNotNull((Object)pack);
            this.fPack = pack;
        }

        public Object getModelObject() {
            return this.fPack;
        }

        public IProject[] getProjects() {
            return new IProject[]{this.fPack.getRubyProject().getProject()};
        }

        public ResourceTraversal[] getTraversals(ResourceMappingContext context, IProgressMonitor monitor) throws CoreException {
            if (context instanceof RemoteResourceMappingContext) {
                return new ResourceTraversal[]{new ResourceTraversal(new IResource[]{this.fPack.getResource()}, 1, 0)};
            }
            return new ResourceTraversal[]{new LocalPackageFragementTraversal(this.fPack)};
        }

        public void accept(ResourceMappingContext context, IResourceVisitor visitor, IProgressMonitor monitor) throws CoreException {
            if (context instanceof RemoteResourceMappingContext) {
                super.accept(context, visitor, monitor);
            } else {
                IFile[] files = RubyElementResourceMapping.getPackageContent(this.fPack);
                if (monitor == null) {
                    monitor = new NullProgressMonitor();
                }
                monitor.beginTask("", files.length + 1);
                IResource resource = this.fPack.getResource();
                if (resource != null) {
                    visitor.visit(resource);
                }
                monitor.worked(1);
                int i = 0;
                while (i < files.length) {
                    visitor.visit((IResource)files[i]);
                    monitor.worked(1);
                    ++i;
                }
            }
        }
    }
}

