/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.corext.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.rubypeople.rdt.core.ElementChangedEvent;
import org.rubypeople.rdt.core.IElementChangedListener;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyElementDelta;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.core.IType;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.core.search.IRubySearchScope;
import org.rubypeople.rdt.core.search.SearchEngine;
import org.rubypeople.rdt.internal.corext.CorextMessages;
import org.rubypeople.rdt.internal.corext.util.History;
import org.rubypeople.rdt.internal.corext.util.RubyModelUtil;
import org.rubypeople.rdt.internal.corext.util.TypeFilter;
import org.rubypeople.rdt.internal.corext.util.TypeInfo;
import org.rubypeople.rdt.internal.corext.util.TypeInfoFactory;
import org.rubypeople.rdt.internal.corext.util.TypeInfoFilter;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.w3c.dom.Element;

public class OpenTypeHistory
extends History {
    private volatile boolean fNeedsConsistencyCheck = true;
    private Map fTimestampMapping;
    private final IElementChangedListener fDeltaListener;
    private final UpdateJob fUpdateJob;
    private final TypeInfoFactory fTypeInfoFactory = new TypeInfoFactory();
    private static final String FILENAME = "OpenTypeHistory.xml";
    private static final String NODE_ROOT = "typeInfoHistroy";
    private static final String NODE_TYPE_INFO = "typeInfo";
    private static final String NODE_NAME = "name";
    private static final String NODE_PACKAGE = "package";
    private static final String NODE_ENCLOSING_NAMES = "enclosingTypes";
    private static final String NODE_PATH = "path";
    private static final String NODE_MODIFIERS = "modifiers";
    private static final String NODE_TIMESTAMP = "timestamp";
    private static final char[][] EMPTY_ENCLOSING_NAMES = new char[0][0];
    private static OpenTypeHistory fgInstance;

    public static synchronized OpenTypeHistory getInstance() {
        if (fgInstance == null) {
            fgInstance = new OpenTypeHistory();
        }
        return fgInstance;
    }

    public static synchronized void shutdown() {
        if (fgInstance == null) {
            return;
        }
        fgInstance.doShutdown();
    }

    private OpenTypeHistory() {
        super(FILENAME, NODE_ROOT, NODE_TYPE_INFO);
        this.fTimestampMapping = new HashMap();
        this.load();
        this.fDeltaListener = new TypeHistoryDeltaListener();
        RubyCore.addElementChangedListener((IElementChangedListener)this.fDeltaListener);
        this.fUpdateJob = new UpdateJob();
        this.fUpdateJob.setPriority(20);
    }

    public void markAsInconsistent() {
        this.fNeedsConsistencyCheck = true;
        this.fUpdateJob.cancel();
        this.fUpdateJob.schedule();
    }

    public boolean needConsistencyCheck() {
        return this.fNeedsConsistencyCheck;
    }

    public void checkConsistency(IProgressMonitor monitor) throws OperationCanceledException {
        if (!this.fNeedsConsistencyCheck) {
            return;
        }
        if (this.fUpdateJob.getState() == 4) {
            try {
                Platform.getJobManager().join((Object)UpdateJob.FAMILY, monitor);
            }
            catch (OperationCanceledException operationCanceledException) {
            }
            catch (InterruptedException interruptedException) {}
        }
        if (!this.fNeedsConsistencyCheck) {
            return;
        }
        this.internalCheckConsistency(monitor);
    }

    public synchronized boolean contains(TypeInfo type) {
        return super.contains(type);
    }

    public synchronized void accessed(TypeInfo info) {
        if (!this.fTimestampMapping.containsKey(info)) {
            this.fTimestampMapping.put(info, new Long(info.getContainerTimestamp()));
        }
        super.accessed(info);
    }

    public synchronized TypeInfo remove(TypeInfo info) {
        this.fTimestampMapping.remove(info);
        return (TypeInfo)super.remove(info);
    }

    public synchronized TypeInfo[] getTypeInfos() {
        Collection values = this.getValues();
        int size = values.size();
        TypeInfo[] result = new TypeInfo[size];
        int i = size - 1;
        Iterator iter = values.iterator();
        while (iter.hasNext()) {
            result[i] = (TypeInfo)iter.next();
            --i;
        }
        return result;
    }

    public synchronized TypeInfo[] getFilteredTypeInfos(TypeInfoFilter filter) {
        Collection values = this.getValues();
        ArrayList<TypeInfo> result = new ArrayList<TypeInfo>();
        for (TypeInfo type : values) {
            if (filter != null && !filter.matchesHistoryElement(type) || TypeFilter.isFiltered(type.getFullyQualifiedName())) continue;
            result.add(type);
        }
        Collections.reverse(result);
        return result.toArray(new TypeInfo[result.size()]);
    }

    protected Object getKey(Object object) {
        return object;
    }

    private synchronized void internalCheckConsistency(IProgressMonitor monitor) throws OperationCanceledException {
        this.fNeedsConsistencyCheck = true;
        IRubySearchScope scope = SearchEngine.createWorkspaceScope();
        ArrayList typesToCheck = new ArrayList(this.getKeys());
        monitor.beginTask(CorextMessages.TypeInfoHistory_consistency_check, typesToCheck.size());
        monitor.setTaskName(CorextMessages.TypeInfoHistory_consistency_check);
        for (TypeInfo type : typesToCheck) {
            long currentTimestamp = type.getContainerTimestamp();
            Long lastTested = (Long)this.fTimestampMapping.get(type);
            if (lastTested != null && currentTimestamp != -1L && currentTimestamp == lastTested && !type.isContainerDirty()) continue;
            try {
                IType jType = type.resolveType(scope);
                if (jType == null || !jType.exists()) {
                    this.remove(type);
                } else {
                    type.setIsModule(jType.isModule());
                    this.fTimestampMapping.put(type, new Long(currentTimestamp));
                }
            }
            catch (RubyModelException rubyModelException) {
                this.remove(type);
            }
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            monitor.worked(1);
        }
        monitor.done();
        this.fNeedsConsistencyCheck = false;
    }

    private void doShutdown() {
        RubyCore.removeElementChangedListener((IElementChangedListener)this.fDeltaListener);
        this.save();
    }

    protected Object createFromElement(Element type) {
        String name = type.getAttribute(NODE_NAME);
        String pack = type.getAttribute(NODE_PACKAGE);
        char[][] enclosingNames = this.getEnclosingNames(type);
        String path = type.getAttribute(NODE_PATH);
        boolean isModule = false;
        try {
            isModule = Boolean.parseBoolean(type.getAttribute(NODE_MODIFIERS));
        }
        catch (NumberFormatException numberFormatException) {}
        TypeInfo info = this.fTypeInfoFactory.create(pack.toCharArray(), name.toCharArray(), enclosingNames, isModule, path);
        long timestamp = -1L;
        String timestampValue = type.getAttribute(NODE_TIMESTAMP);
        if (timestampValue != null && timestampValue.length() > 0) {
            try {
                timestamp = Long.parseLong(timestampValue);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (timestamp != -1L) {
            this.fTimestampMapping.put(info, new Long(timestamp));
        }
        return info;
    }

    protected void setAttributes(Object object, Element typeElement) {
        TypeInfo type = (TypeInfo)object;
        typeElement.setAttribute(NODE_NAME, type.getTypeName());
        typeElement.setAttribute(NODE_PACKAGE, type.getPackageName());
        typeElement.setAttribute(NODE_ENCLOSING_NAMES, type.getEnclosingName());
        typeElement.setAttribute(NODE_PATH, type.getPath());
        typeElement.setAttribute(NODE_MODIFIERS, Boolean.toString(type.isModule()));
        Long timestamp = (Long)this.fTimestampMapping.get(type);
        if (timestamp == null) {
            typeElement.setAttribute(NODE_TIMESTAMP, Long.toString(-1L));
        } else {
            typeElement.setAttribute(NODE_TIMESTAMP, timestamp.toString());
        }
    }

    private char[][] getEnclosingNames(Element type) {
        String enclosingNames = type.getAttribute(NODE_ENCLOSING_NAMES);
        if (enclosingNames.length() == 0) {
            return EMPTY_ENCLOSING_NAMES;
        }
        StringTokenizer tokenizer = new StringTokenizer(enclosingNames, ".");
        ArrayList<char[]> names = new ArrayList<char[]>();
        while (tokenizer.hasMoreTokens()) {
            String name = tokenizer.nextToken();
            names.add(name.toCharArray());
        }
        return (char[][])names.toArray((T[])new char[names.size()][]);
    }

    private static class TypeHistoryDeltaListener
    implements IElementChangedListener {
        private TypeHistoryDeltaListener() {
        }

        public void elementChanged(ElementChangedEvent event) {
            if (this.processDelta(event.getDelta())) {
                OpenTypeHistory.getInstance().markAsInconsistent();
            }
        }

        private boolean processDelta(IRubyElementDelta delta) {
            IRubyElement elem = delta.getElement();
            boolean isChanged = delta.getKind() == 4;
            boolean isRemoved = delta.getKind() == 2;
            switch (elem.getElementType()) {
                case 1: {
                    if (isRemoved || isChanged && (delta.getFlags() & 0x400) != 0) {
                        return true;
                    }
                    return this.processChildrenDelta(delta);
                }
                case 2: {
                    if (isRemoved || isChanged && ((delta.getFlags() & 0x8000) != 0 || (delta.getFlags() & 0x80) != 0)) {
                        return true;
                    }
                    return this.processChildrenDelta(delta);
                }
                case 5: {
                    if (isChanged && (delta.getFlags() & 2) != 0) {
                        return true;
                    }
                }
                case 0: 
                case 3: {
                    if (isRemoved) {
                        return true;
                    }
                    return this.processChildrenDelta(delta);
                }
                case 4: {
                    if (!RubyModelUtil.isPrimary((IRubyScript)elem)) {
                        return false;
                    }
                    if (isRemoved || isChanged && this.isUnknownStructuralChange(delta.getFlags())) {
                        return true;
                    }
                    return this.processChildrenDelta(delta);
                }
            }
            return false;
        }

        private boolean isUnknownStructuralChange(int flags) {
            if ((flags & 1) == 0) {
                return false;
            }
            return (flags & 0x4000) == 0;
        }

        private boolean processChildrenDelta(IRubyElementDelta delta) {
            IRubyElementDelta[] children = delta.getAffectedChildren();
            int i = 0;
            while (i < children.length) {
                if (this.processDelta(children[i])) {
                    return true;
                }
                ++i;
            }
            return false;
        }
    }

    private static class UpdateJob
    extends Job {
        public static final String FAMILY = UpdateJob.class.getName();

        public UpdateJob() {
            super(CorextMessages.TypeInfoHistory_consistency_check);
        }

        protected IStatus run(IProgressMonitor monitor) {
            OpenTypeHistory history = OpenTypeHistory.getInstance();
            history.internalCheckConsistency(monitor);
            return new Status(0, RubyPlugin.getPluginId(), 0, "", null);
        }

        public boolean belongsTo(Object family) {
            return FAMILY.equals(family);
        }
    }
}

