/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.corext.util;

import java.net.URI;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.core.search.IRubySearchScope;
import org.rubypeople.rdt.internal.corext.util.TypeInfo;

public class IFileTypeInfo
extends TypeInfo {
    private final String fProject;
    private final String fFolder;
    private final String fFile;
    private final String fExtension;

    public IFileTypeInfo(String pkg, String name, char[][] enclosingTypes, boolean isModule, String project, String sourceFolder, String file, String extension) {
        super(pkg, name, enclosingTypes, isModule);
        this.fProject = project;
        this.fFolder = sourceFolder;
        this.fFile = file;
        this.fExtension = extension;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!IFileTypeInfo.class.equals(obj.getClass())) {
            return false;
        }
        IFileTypeInfo other = (IFileTypeInfo)obj;
        return this.doEquals(other) && this.fProject.equals(other.fProject) && IFileTypeInfo.equals(this.fFolder, other.fFolder) && this.fFile.equals(other.fFile) && this.fExtension.equals(other.fExtension);
    }

    public int getElementType() {
        return 3;
    }

    protected IRubyElement getContainer(IRubySearchScope scope) {
        IRubyElement elem;
        Path path;
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource resource = root.findMember((IPath)(path = new Path(this.getPath())));
        if (resource != null && (elem = RubyCore.create((IResource)resource)) != null && elem.exists()) {
            return elem;
        }
        return null;
    }

    public IPath getPackageFragmentRootPath() {
        StringBuffer buffer = new StringBuffer();
        buffer.append('/');
        buffer.append(this.fProject);
        if (this.fFolder != null && this.fFolder.length() > 0) {
            buffer.append('/');
            buffer.append(this.fFolder);
        }
        return new Path(buffer.toString());
    }

    public String getPackageFragmentRootName() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.fProject);
        if (this.fFolder != null && this.fFolder.length() > 0) {
            buffer.append('/');
            buffer.append(this.fFolder);
        }
        return buffer.toString();
    }

    public String getPath() {
        StringBuffer result = new StringBuffer();
        result.append('/');
        result.append(this.fProject);
        result.append('/');
        if (this.fFolder != null && this.fFolder.length() > 0) {
            result.append(this.fFolder);
            result.append('/');
        }
        if (this.fPackage != null && this.fPackage.length() > 0) {
            result.append(this.fPackage.replace('.', '/'));
            result.append('/');
        }
        result.append(this.fFile);
        result.append('.');
        result.append(this.fExtension);
        return result.toString();
    }

    public String getProject() {
        return this.fProject;
    }

    public String getFolder() {
        return this.fFolder;
    }

    public String getFileName() {
        return this.fFile;
    }

    public String getExtension() {
        return this.fExtension;
    }

    public long getContainerTimestamp() {
        URI location;
        Path path;
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource resource = root.findMember((IPath)(path = new Path(this.getPath())));
        if (resource != null && (location = resource.getLocationURI()) != null) {
            try {
                IRubyElement element;
                IFileInfo info = EFS.getStore((URI)location).fetchInfo();
                if (info.exists() && (element = RubyCore.create((IResource)resource)) != null && element.exists()) {
                    return info.getLastModified();
                }
            }
            catch (CoreException coreException) {}
        }
        return -1L;
    }

    public boolean isContainerDirty() {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        Path path = new Path(this.getPath());
        IResource resource = root.findMember((IPath)path);
        ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
        ITextFileBuffer textFileBuffer = manager.getTextFileBuffer(resource.getFullPath());
        if (textFileBuffer != null) {
            return textFileBuffer.isDirty();
        }
        return false;
    }
}

