/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.corext.template.ruby;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.templates.DocumentTemplateContext;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateVariable;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.RangeMarker;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.internal.corext.template.ruby.RubyContext;
import org.rubypeople.rdt.internal.corext.util.CodeFormatterUtil;
import org.rubypeople.rdt.internal.corext.util.Strings;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.text.RubyHeuristicScanner;

public class RubyFormatter {
    private static final String MARKER = "/*${cursor}*/";
    private final String fLineDelimiter;
    private final int fInitialIndentLevel;
    private boolean fUseCodeFormatter;
    private final IRubyProject fProject;

    public RubyFormatter(String lineDelimiter, int initialIndentLevel, boolean useCodeFormatter, IRubyProject project) {
        this.fLineDelimiter = lineDelimiter;
        this.fUseCodeFormatter = useCodeFormatter;
        this.fInitialIndentLevel = initialIndentLevel;
        this.fProject = project;
    }

    public void format(TemplateBuffer buffer, TemplateContext context) throws BadLocationException {
        try {
            DocumentTemplateContext dtc;
            if (this.fUseCodeFormatter) {
                try {
                    this.format(buffer, (RubyContext)context);
                }
                catch (BadLocationException badLocationException) {
                    this.indent(buffer);
                }
                catch (MalformedTreeException malformedTreeException) {
                    this.indent(buffer);
                }
            } else {
                this.indent(buffer);
            }
            if (context instanceof DocumentTemplateContext && (dtc = (DocumentTemplateContext)context).getStart() == dtc.getCompletionOffset() && dtc.getDocument().get(dtc.getStart(), dtc.getEnd() - dtc.getStart()).trim().length() == 0) {
                return;
            }
            RubyFormatter.trimBegin(buffer);
        }
        catch (MalformedTreeException malformedTreeException) {
            throw new BadLocationException();
        }
    }

    private static int getCaretOffset(TemplateVariable[] variables) {
        int i = 0;
        while (i != variables.length) {
            TemplateVariable variable = variables[i];
            if (variable.getType().equals("cursor")) {
                return variable.getOffsets()[0];
            }
            ++i;
        }
        return -1;
    }

    private boolean isInsideCommentOrString(String string, int offset) {
        Document document = new Document(string);
        RubyPlugin.getDefault().getRubyTextTools().setupRubyDocumentPartitioner((IDocument)document);
        try {
            ITypedRegion partition = document.getPartition(offset);
            String partitionType = partition.getType();
            return partitionType != null && (partitionType.equals("__ruby_multiline_comment") || partitionType.equals("__ruby_singleline_comment"));
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    private void format(TemplateBuffer templateBuffer, RubyContext context) throws BadLocationException {
        String string = templateBuffer.getString();
        TemplateVariable[] variables = templateBuffer.getVariables();
        int caretOffset = RubyFormatter.getCaretOffset(variables);
        if (caretOffset > 0 && Character.isWhitespace(string.charAt(caretOffset - 1)) && caretOffset < string.length() && Character.isWhitespace(string.charAt(caretOffset)) && !this.isInsideCommentOrString(string, caretOffset)) {
            List positions = RubyFormatter.variablesToPositions(variables);
            InsertEdit insert = new InsertEdit(caretOffset, MARKER);
            string = RubyFormatter.edit(string, positions, (TextEdit)insert);
            RubyFormatter.positionsToVariables(positions, variables);
            templateBuffer.setContent(string, variables);
            try {
                this.plainFormat(templateBuffer, context);
                string = templateBuffer.getString();
                variables = templateBuffer.getVariables();
                caretOffset = RubyFormatter.getCaretOffset(variables);
            }
            finally {
                positions = RubyFormatter.variablesToPositions(variables);
                DeleteEdit delete = new DeleteEdit(caretOffset, MARKER.length());
                string = RubyFormatter.edit(string, positions, (TextEdit)delete);
                RubyFormatter.positionsToVariables(positions, variables);
                templateBuffer.setContent(string, variables);
            }
        } else {
            this.plainFormat(templateBuffer, context);
        }
    }

    private void plainFormat(TemplateBuffer templateBuffer, RubyContext context) throws BadLocationException {
        MultiTextEdit root;
        Document doc = new Document(templateBuffer.getString());
        TemplateVariable[] variables = templateBuffer.getVariables();
        List offsets = RubyFormatter.variablesToPositions(variables);
        Map options = context.getRubyScript() != null ? context.getRubyScript().getRubyProject().getOptions(true) : RubyCore.getOptions();
        String contents = doc.get();
        int[] nArray = new int[3];
        nArray[0] = 1;
        nArray[1] = 2;
        int[] kinds = nArray;
        TextEdit edit = null;
        int i = 0;
        while (i < kinds.length && edit == null) {
            edit = CodeFormatterUtil.format2(kinds[i], contents, this.fInitialIndentLevel, this.fLineDelimiter, options);
            ++i;
        }
        if (edit == null) {
            throw new BadLocationException();
        }
        if (edit instanceof MultiTextEdit) {
            root = (MultiTextEdit)edit;
        } else {
            root = new MultiTextEdit(0, doc.getLength());
            root.addChild(edit);
        }
        for (TextEdit position : offsets) {
            try {
                root.addChild(position);
            }
            catch (MalformedTreeException malformedTreeException) {}
        }
        root.apply((IDocument)doc, 2);
        RubyFormatter.positionsToVariables(offsets, variables);
        templateBuffer.setContent(doc.get(), variables);
    }

    private void indent(TemplateBuffer templateBuffer) throws BadLocationException, MalformedTreeException {
        TemplateVariable[] variables = templateBuffer.getVariables();
        List positions = RubyFormatter.variablesToPositions(variables);
        Document document = new Document(templateBuffer.getString());
        MultiTextEdit root = new MultiTextEdit(0, document.getLength());
        root.addChildren(positions.toArray(new TextEdit[positions.size()]));
        int offset = document.getLineOffset(0);
        String indent = CodeFormatterUtil.createIndentString(this.fInitialIndentLevel, this.fProject);
        InsertEdit edit = new InsertEdit(offset, indent);
        root.addChild((TextEdit)edit);
        root.apply((IDocument)document, 2);
        root.removeChild((TextEdit)edit);
        this.formatDelimiter((IDocument)document, root, 0);
        int lineCount = document.getNumberOfLines();
        new RubyHeuristicScanner((IDocument)document);
        int line = 1;
        while (line < lineCount) {
            IRegion region = document.getLineInformation(line);
            offset = region.getOffset();
            if (indent != null) {
                edit = new ReplaceEdit(offset, 0, indent.toString());
                root.addChild((TextEdit)edit);
                root.apply((IDocument)document, 2);
                root.removeChild((TextEdit)edit);
                this.formatDelimiter((IDocument)document, root, line);
            }
            ++line;
        }
        RubyFormatter.positionsToVariables(positions, variables);
        templateBuffer.setContent(document.get(), variables);
    }

    private void formatDelimiter(IDocument document, MultiTextEdit root, int line) throws BadLocationException {
        IRegion region = document.getLineInformation(line);
        String lineDelimiter = document.getLineDelimiter(line);
        if (lineDelimiter != null) {
            ReplaceEdit edit = new ReplaceEdit(region.getOffset() + region.getLength(), lineDelimiter.length(), this.fLineDelimiter);
            root.addChild((TextEdit)edit);
            root.apply(document, 2);
            root.removeChild((TextEdit)edit);
        }
    }

    private static void trimBegin(TemplateBuffer templateBuffer) throws BadLocationException {
        String string = templateBuffer.getString();
        TemplateVariable[] variables = templateBuffer.getVariables();
        List positions = RubyFormatter.variablesToPositions(variables);
        int i = 0;
        while (i != string.length() && Character.isWhitespace(string.charAt(i))) {
            ++i;
        }
        string = RubyFormatter.edit(string, positions, (TextEdit)new DeleteEdit(0, i));
        RubyFormatter.positionsToVariables(positions, variables);
        templateBuffer.setContent(string, variables);
    }

    private static String edit(String string, List positions, TextEdit edit) throws BadLocationException {
        MultiTextEdit root = new MultiTextEdit(0, string.length());
        root.addChildren(positions.toArray(new TextEdit[positions.size()]));
        root.addChild(edit);
        Document document = new Document(string);
        root.apply((IDocument)document);
        return document.get();
    }

    private static List variablesToPositions(TemplateVariable[] variables) {
        ArrayList<RangeMarker> positions = new ArrayList<RangeMarker>(5);
        int i = 0;
        while (i != variables.length) {
            int[] offsets = variables[i].getOffsets();
            String value = variables[i].getDefaultValue();
            int wsStart = 0;
            while (wsStart < value.length() && Character.isWhitespace(value.charAt(wsStart)) && !Strings.isLineDelimiterChar(value.charAt(wsStart))) {
                ++wsStart;
            }
            variables[i].getValues()[0] = value.substring(wsStart);
            int j = 0;
            while (j != offsets.length) {
                int n = j;
                offsets[n] = offsets[n] + wsStart;
                positions.add(new RangeMarker(offsets[j], 0));
                ++j;
            }
            ++i;
        }
        return positions;
    }

    private static void positionsToVariables(List positions, TemplateVariable[] variables) {
        Iterator iterator = positions.iterator();
        int i = 0;
        while (i != variables.length) {
            TemplateVariable variable = variables[i];
            int[] offsets = new int[variable.getOffsets().length];
            int j = 0;
            while (j != offsets.length) {
                offsets[j] = ((TextEdit)iterator.next()).getOffset();
                ++j;
            }
            variable.setOffsets(offsets);
            ++i;
        }
    }
}

