/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.corext.refactoring.changes;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.ContentStamp;
import org.eclipse.ltk.core.refactoring.UndoTextFileChange;
import org.eclipse.text.edits.UndoEdit;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.internal.core.util.Messages;
import org.rubypeople.rdt.internal.corext.refactoring.changes.RefactoringCoreMessages;
import org.rubypeople.rdt.internal.ui.RubyPlugin;

class UndoRubyScriptChange
extends UndoTextFileChange {
    private IRubyScript fCUnit;

    public UndoRubyScriptChange(String name, IRubyScript unit, UndoEdit undo, ContentStamp stampToRestore, int saveMode) throws CoreException {
        super(name, UndoRubyScriptChange.getFile(unit), undo, stampToRestore, saveMode);
        this.fCUnit = unit;
    }

    private static IFile getFile(IRubyScript cunit) throws CoreException {
        IFile file = (IFile)cunit.getResource();
        if (file == null) {
            throw new CoreException((IStatus)new Status(4, RubyPlugin.getPluginId(), 4, Messages.format((String)RefactoringCoreMessages.UndoRubyScriptChange_no_resource, (String)cunit.getElementName()), null));
        }
        return file;
    }

    public Object getModifiedElement() {
        return this.fCUnit;
    }

    protected Change createUndoChange(UndoEdit edit, ContentStamp stampToRestore) throws CoreException {
        return new UndoRubyScriptChange(this.getName(), this.fCUnit, edit, stampToRestore, this.getSaveMode());
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        pm.beginTask("", 2);
        this.fCUnit.becomeWorkingCopy(null, (IProgressMonitor)new SubProgressMonitor(pm, 1));
        try {
            Change change = super.perform((IProgressMonitor)new SubProgressMonitor(pm, 1));
            return change;
        }
        finally {
            this.fCUnit.discardWorkingCopy();
        }
    }
}

