/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.corext.refactoring.changes;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.ContentStamp;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.text.edits.UndoEdit;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.internal.corext.refactoring.changes.UndoRubyScriptChange;
import org.rubypeople.rdt.internal.corext.util.RubyModelUtil;
import org.rubypeople.rdt.internal.ui.RubyPlugin;

public class RubyScriptChange
extends TextFileChange {
    private IRubyScript fCUnit;

    public RubyScriptChange(String name, IRubyScript cunit) {
        super(name, RubyScriptChange.getFile(cunit));
        Assert.isNotNull((Object)cunit);
        this.fCUnit = cunit;
        this.setTextType("ruby");
    }

    private static IFile getFile(IRubyScript cunit) {
        return (IFile)cunit.getResource();
    }

    public Object getModifiedElement() {
        return this.fCUnit;
    }

    public IRubyScript getRubyScript() {
        return this.fCUnit;
    }

    protected IDocument acquireDocument(IProgressMonitor pm) throws CoreException {
        pm.beginTask("", 2);
        this.fCUnit.becomeWorkingCopy(null, (IProgressMonitor)new SubProgressMonitor(pm, 1));
        return super.acquireDocument((IProgressMonitor)new SubProgressMonitor(pm, 1));
    }

    protected void releaseDocument(IDocument document, IProgressMonitor pm) throws CoreException {
        super.releaseDocument(document, pm);
        try {
            this.fCUnit.discardWorkingCopy();
        }
        finally {
            if (!this.isDocumentAcquired()) {
                if (this.fCUnit.isWorkingCopy()) {
                    RubyModelUtil.reconcile(this.fCUnit);
                } else {
                    this.fCUnit.makeConsistent(pm);
                }
            }
        }
    }

    protected Change createUndoChange(UndoEdit edit, ContentStamp stampToRestore) {
        try {
            return new UndoRubyScriptChange(this.getName(), this.fCUnit, edit, stampToRestore, this.getSaveMode());
        }
        catch (CoreException e) {
            RubyPlugin.log(e);
            return null;
        }
    }

    public Object getAdapter(Class adapter) {
        if (IRubyScript.class.equals((Object)adapter)) {
            return this.fCUnit;
        }
        return super.getAdapter(adapter);
    }
}

