/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.corext.codemanipulation;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.rubypeople.rdt.core.IOpenable;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.core.RubyModelException;

public class StubUtility {
    public static String getLineDelimiterUsed(IRubyProject project) {
        return StubUtility.getProjectLineDelimiter(project);
    }

    private static String getProjectLineDelimiter(IRubyProject javaProject) {
        String lineDelimiter;
        IProject project = null;
        if (javaProject != null) {
            project = javaProject.getProject();
        }
        if ((lineDelimiter = StubUtility.getLineDelimiterPreference(project)) != null) {
            return lineDelimiter;
        }
        return System.getProperty("line.separator", "\n");
    }

    public static String getLineDelimiterPreference(IProject project) {
        IScopeContext[] scopeContext;
        if (project != null) {
            scopeContext = new IScopeContext[]{new ProjectScope(project)};
            String lineDelimiter = Platform.getPreferencesService().getString("org.eclipse.core.runtime", "line.separator", null, scopeContext);
            if (lineDelimiter != null) {
                return lineDelimiter;
            }
        }
        scopeContext = new IScopeContext[]{new InstanceScope()};
        String platformDefault = System.getProperty("line.separator", "\n");
        return Platform.getPreferencesService().getString("org.eclipse.core.runtime", "line.separator", platformDefault, scopeContext);
    }

    public static String getLineDelimiterUsed(IRubyElement elem) {
        while (elem != null && !(elem instanceof IOpenable)) {
            elem = elem.getParent();
        }
        if (elem != null) {
            try {
                return ((IOpenable)elem).findRecommendedLineSeparator();
            }
            catch (RubyModelException rubyModelException) {}
        }
        return StubUtility.getProjectLineDelimiter(null);
    }
}

