/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.corext.callhierarchy;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.rubypeople.rdt.core.IBuffer;
import org.rubypeople.rdt.core.IMember;
import org.rubypeople.rdt.core.IOpenable;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.ui.RubyPlugin;

public class CallLocation
implements IAdaptable {
    public static final int UNKNOWN_LINE_NUMBER = -1;
    private IMember fMember;
    private IMember fCalledMember;
    private int fStart;
    private int fEnd;
    private String fCallText;
    private int fLineNumber;

    public CallLocation(IMember member, IMember calledMember, int start, int end, int lineNumber) {
        this.fMember = member;
        this.fCalledMember = calledMember;
        this.fStart = start;
        this.fEnd = end;
        this.fLineNumber = lineNumber;
    }

    public IMember getCalledMember() {
        return this.fCalledMember;
    }

    public int getEnd() {
        return this.fEnd;
    }

    public IMember getMember() {
        return this.fMember;
    }

    public int getStart() {
        return this.fStart;
    }

    public int getLineNumber() {
        this.initCallTextAndLineNumber();
        return this.fLineNumber;
    }

    public String getCallText() {
        this.initCallTextAndLineNumber();
        return this.fCallText;
    }

    private void initCallTextAndLineNumber() {
        if (this.fCallText != null) {
            return;
        }
        IBuffer buffer = this.getBufferForMember();
        if (buffer == null || buffer.getLength() < this.fEnd) {
            this.fCallText = "";
            this.fLineNumber = -1;
            return;
        }
        this.fCallText = buffer.getText(this.fStart, this.fEnd - this.fStart);
        if (this.fLineNumber == -1) {
            Document document = new Document(buffer.getContents());
            try {
                this.fLineNumber = document.getLineOfOffset(this.fStart) + 1;
            }
            catch (BadLocationException e) {
                RubyPlugin.log(e);
            }
        }
    }

    private IBuffer getBufferForMember() {
        IBuffer buffer = null;
        try {
            IOpenable openable = this.fMember.getOpenable();
            if (openable != null && this.fMember.exists()) {
                buffer = openable.getBuffer();
            }
        }
        catch (RubyModelException e) {
            RubyPlugin.log(e);
        }
        return buffer;
    }

    public String toString() {
        return this.getCallText();
    }

    public Object getAdapter(Class adapter) {
        if (IRubyElement.class.isAssignableFrom(adapter)) {
            return this.getMember();
        }
        return null;
    }
}

