/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.corext.buildpath;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.rubypeople.rdt.core.ILoadpathEntry;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.core.ISourceFolderRoot;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.corext.buildpath.ILoadpathInformationProvider;
import org.rubypeople.rdt.internal.corext.buildpath.LoadpathModifier;
import org.rubypeople.rdt.internal.corext.util.Messages;
import org.rubypeople.rdt.internal.ui.packageview.LoadPathContainer;
import org.rubypeople.rdt.internal.ui.wizards.NewWizardMessages;
import org.rubypeople.rdt.internal.ui.wizards.buildpaths.newsourcepage.LoadpathModifierOperation;

public class RemoveFromLoadpathOperation
extends LoadpathModifierOperation {
    public RemoveFromLoadpathOperation(LoadpathModifier.ILoadpathModifierListener listener, ILoadpathInformationProvider informationProvider) {
        super(listener, informationProvider, NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_RemoveFromCP_tooltip, 1);
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException {
        List result = null;
        this.fException = null;
        try {
            result = this.removeFromLoadpath(this.fInformationProvider.getRemoveLinkedFolderQuery(), this.getSelectedElements(), this.fInformationProvider.getRubyProject(), monitor);
        }
        catch (CoreException e) {
            this.fException = e;
            result = null;
        }
        super.handleResult(result, monitor);
    }

    public boolean isValid(List elements, int[] types) throws RubyModelException {
        if (elements.size() == 0) {
            return false;
        }
        IRubyProject project = this.fInformationProvider.getRubyProject();
        for (Object element : elements) {
            ILoadpathEntry entry;
            if (!(element instanceof ISourceFolderRoot || element instanceof IRubyProject || element instanceof LoadPathContainer)) {
                return false;
            }
            if (!(element instanceof IRubyProject ? !RemoveFromLoadpathOperation.isSourceFolder(project) : element instanceof ISourceFolderRoot && (entry = ((ISourceFolderRoot)element).getRawLoadpathEntry()) != null && entry.getEntryKind() == 5)) continue;
            return false;
        }
        return true;
    }

    public String getDescription(int type) {
        IRubyElement elem = (IRubyElement)this.getSelectedElements().get(0);
        String name = RemoveFromLoadpathOperation.escapeSpecialChars(elem.getElementName());
        if (type == 1) {
            return Messages.format(NewWizardMessages.PackageExplorerActionGroup_FormText_ProjectFromBuildpath, name);
        }
        if (type == 2 || type == 14) {
            return Messages.format(NewWizardMessages.PackageExplorerActionGroup_FormText_fromBuildpath, name);
        }
        return NewWizardMessages.PackageExplorerActionGroup_FormText_Default_FromBuildpath;
    }
}

