/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.corext.buildpath;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.rubypeople.rdt.core.ISourceFolderRoot;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.corext.buildpath.ILoadpathInformationProvider;
import org.rubypeople.rdt.internal.corext.buildpath.LoadpathModifier;
import org.rubypeople.rdt.internal.ui.wizards.NewWizardMessages;
import org.rubypeople.rdt.internal.ui.wizards.buildpaths.newsourcepage.GenerateBuildPathActionGroup;
import org.rubypeople.rdt.internal.ui.wizards.buildpaths.newsourcepage.LoadpathModifierOperation;

public class LinkedSourceFolderOperation
extends LoadpathModifierOperation {
    private LoadpathModifier.ILoadpathModifierListener fListener;
    private ILoadpathInformationProvider fCPInformationProvider;

    public LinkedSourceFolderOperation(LoadpathModifier.ILoadpathModifierListener listener, ILoadpathInformationProvider informationProvider) {
        super(listener, informationProvider, NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_Link_tooltip, 5);
        this.fListener = listener;
        this.fCPInformationProvider = informationProvider;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        GenerateBuildPathActionGroup.CreateLinkedSourceFolderAction action = new GenerateBuildPathActionGroup.CreateLinkedSourceFolderAction();
        action.selectionChanged((IStructuredSelection)new StructuredSelection((Object)this.fCPInformationProvider.getRubyProject()));
        action.run();
        ISourceFolderRoot createdElement = (ISourceFolderRoot)action.getCreatedElement();
        if (createdElement == null) {
            return;
        }
        try {
            IResource correspondingResource = createdElement.getCorrespondingResource();
            ArrayList<IResource> result = new ArrayList<IResource>();
            result.add(correspondingResource);
            if (this.fListener != null) {
                List entries = action.getCPListElements();
                this.fListener.classpathEntryChanged(entries);
            }
            this.fCPInformationProvider.handleResult(result, null, 5);
        }
        catch (RubyModelException e) {
            if (monitor == null) {
                this.fCPInformationProvider.handleResult(Collections.EMPTY_LIST, (CoreException)((Object)e), 5);
            }
            throw new InvocationTargetException(e);
        }
    }

    public boolean isValid(List elements, int[] types) throws RubyModelException {
        return types.length == 1 && types[0] == 1;
    }

    public String getDescription(int type) {
        return NewWizardMessages.PackageExplorerActionGroup_FormText_createLinkedFolder;
    }
}

