/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.debug.ui.rubyvms;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.rubypeople.rdt.internal.debug.ui.rubyvms.IAddVMDialogRequestor;
import org.rubypeople.rdt.internal.debug.ui.rubyvms.RubyVMMessages;
import org.rubypeople.rdt.internal.debug.ui.rubyvms.VMLibraryBlock;
import org.rubypeople.rdt.internal.ui.dialogs.StatusDialog;
import org.rubypeople.rdt.internal.ui.dialogs.StatusInfo;
import org.rubypeople.rdt.internal.ui.wizards.dialogfields.ComboDialogField;
import org.rubypeople.rdt.internal.ui.wizards.dialogfields.DialogField;
import org.rubypeople.rdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.rubypeople.rdt.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.rubypeople.rdt.internal.ui.wizards.dialogfields.StringButtonDialogField;
import org.rubypeople.rdt.internal.ui.wizards.dialogfields.StringDialogField;
import org.rubypeople.rdt.launching.IVMInstall;
import org.rubypeople.rdt.launching.IVMInstallType;
import org.rubypeople.rdt.launching.VMStandin;

public class AddVMDialog
extends StatusDialog {
    protected IStatus[] allStatus = new IStatus[2];
    protected IVMInstall fEditedVM;
    private StringButtonDialogField fRubyVMRoot;
    private StringDialogField fVMName;
    private StringDialogField fVMArgs;
    private IVMInstallType fSelectedVMType;
    private IVMInstallType[] fVMTypes;
    private ComboDialogField fVMTypeCombo;
    private VMLibraryBlock fLibraryBlock;
    private IStatus[] fStati;
    private int fPrevIndex = -1;
    private IAddVMDialogRequestor fRequestor;

    public AddVMDialog(IAddVMDialogRequestor requestor, Shell shell, IVMInstallType[] vmInstallTypes, IVMInstall editedVM) {
        super(shell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.fRequestor = requestor;
        this.fStati = new IStatus[5];
        int i = 0;
        while (i < this.fStati.length) {
            this.fStati[i] = new StatusInfo();
            ++i;
        }
        this.fVMTypes = vmInstallTypes;
        this.fSelectedVMType = editedVM != null ? editedVM.getVMInstallType() : vmInstallTypes[0];
        this.fEditedVM = editedVM;
    }

    protected void setSystemLibraryStatus(IStatus status) {
        this.fStati[3] = status;
    }

    protected IStatus validateInterpreterLocationText() {
        String locationName = this.fRubyVMRoot.getText();
        StatusInfo s = null;
        File file = null;
        if (locationName.length() == 0) {
            s = new StatusInfo(1, RubyVMMessages.addVMDialog_enterLocation);
        } else {
            file = new File(locationName);
            if (!file.exists()) {
                s = new StatusInfo(4, RubyVMMessages.addVMDialog_locationNotExists);
            } else {
                final IStatus[] temp = new IStatus[1];
                final File tempFile = file;
                Runnable r = new Runnable(){

                    public void run() {
                        temp[0] = AddVMDialog.this.getVMType().validateInstallLocation(tempFile);
                    }
                };
                BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)r);
                s = temp[0];
            }
        }
        if (s.isOK()) {
            if (file.getName().equals("bin")) {
                file = file.getParentFile();
            }
            this.fLibraryBlock.setHomeDirectory(file);
            String name = this.fVMName.getText();
            if (name == null || name.trim().length() == 0) {
                try {
                    String genName = null;
                    Path path = new Path(file.getCanonicalPath());
                    int segs = path.segmentCount();
                    if (segs == 1) {
                        genName = path.segment(0);
                    } else if (segs >= 2) {
                        genName = path.lastSegment();
                    }
                    if (genName != null) {
                        this.fVMName.setText(genName);
                    }
                }
                catch (IOException iOException) {}
            }
        } else {
            this.fLibraryBlock.setHomeDirectory(null);
        }
        this.fLibraryBlock.restoreDefaultLibraries();
        return s;
    }

    private IVMInstallType getVMType() {
        return this.fSelectedVMType;
    }

    protected void setButtonLayoutData(Button button) {
        super.setButtonLayoutData(button);
    }

    protected void browseForInstallLocation() {
        DirectoryDialog dialog = new DirectoryDialog(this.getShell());
        dialog.setFilterPath(this.fRubyVMRoot.getText());
        dialog.setMessage(RubyVMMessages.addVMDialog_pickJRERootDialog_message);
        String newPath = dialog.open();
        if (newPath != null) {
            this.fRubyVMRoot.setText(newPath);
        }
    }

    protected void okPressed() {
        this.doOkPressed();
        super.okPressed();
    }

    private void doOkPressed() {
        if (this.fEditedVM == null) {
            VMStandin vm = new VMStandin(this.fSelectedVMType, this.createUniqueId(this.fSelectedVMType));
            this.setFieldValuesToVM((IVMInstall)vm);
            this.fRequestor.vmAdded((IVMInstall)vm);
        } else {
            this.setFieldValuesToVM(this.fEditedVM);
        }
    }

    public void create() {
        super.create();
        this.fVMName.setFocus();
        this.selectVMType();
    }

    private String createUniqueId(IVMInstallType vmType) {
        String id = null;
        while (vmType.findVMInstall(id = String.valueOf(System.currentTimeMillis())) != null) {
        }
        return id;
    }

    private void selectVMType() {
        int i = 0;
        while (i < this.fVMTypes.length) {
            if (this.fSelectedVMType == this.fVMTypes[i]) {
                this.fVMTypeCombo.selectItem(i);
                return;
            }
            ++i;
        }
    }

    private void updateVMType() {
        int selIndex = this.fVMTypeCombo.getSelectionIndex();
        if (selIndex == this.fPrevIndex) {
            return;
        }
        this.fPrevIndex = selIndex;
        if (selIndex >= 0 && selIndex < this.fVMTypes.length) {
            this.fSelectedVMType = this.fVMTypes[selIndex];
        }
        this.setRubyVMLocationStatus(this.validateInterpreterLocationText());
        this.fLibraryBlock.initializeFrom(this.fEditedVM, this.fSelectedVMType);
        this.updateStatusLine();
    }

    private void setRubyVMLocationStatus(IStatus status) {
        this.fStati[1] = status;
    }

    protected void updateStatusLine() {
        IStatus max = null;
        int i = 0;
        while (i < this.fStati.length) {
            IStatus curr = this.fStati[i];
            if (curr.matches(4)) {
                this.updateStatus(curr);
                return;
            }
            if (max == null || curr.getSeverity() > max.getSeverity()) {
                max = curr;
            }
            ++i;
        }
        this.updateStatus(max);
    }

    protected Control createDialogArea(Composite ancestor) {
        this.createDialogFields();
        Composite parent = (Composite)super.createDialogArea(ancestor);
        ((GridLayout)parent.getLayout()).numColumns = 3;
        this.fVMTypeCombo.doFillIntoGrid(parent, 3);
        ((GridData)this.fVMTypeCombo.getComboControl(null).getLayoutData()).widthHint = this.convertWidthInCharsToPixels(50);
        Label l = new Label(parent, 0);
        l.setText(RubyVMMessages.enterRubyInstallLocation);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 3;
        l.setLayoutData((Object)gd);
        this.fRubyVMRoot.doFillIntoGrid(parent, 3);
        this.fVMName.doFillIntoGrid(parent, 3);
        this.fVMArgs.doFillIntoGrid(parent, 3);
        ((GridData)this.fVMArgs.getTextControl(null).getLayoutData()).widthHint = this.convertWidthInCharsToPixels(50);
        l = new Label(parent, 0);
        l.setText(RubyVMMessages.AddVMDialog_JRE_system_libraries__1);
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        l.setLayoutData((Object)gd);
        this.fLibraryBlock = new VMLibraryBlock(this);
        Control block = this.fLibraryBlock.createControl(parent);
        gd = new GridData(1808);
        gd.horizontalSpan = 3;
        block.setLayoutData((Object)gd);
        Text t = this.fRubyVMRoot.getTextControl(parent);
        gd = (GridData)t.getLayoutData();
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = this.convertWidthInCharsToPixels(50);
        this.initializeFields();
        this.createFieldListeners();
        AddVMDialog.applyDialogFont((Control)parent);
        return parent;
    }

    private void initializeFields() {
        this.fVMTypeCombo.setItems(this.getVMTypeNames());
        if (this.fEditedVM == null) {
            this.fVMName.setText("");
            this.fRubyVMRoot.setText("");
            this.fLibraryBlock.initializeFrom(null, this.fSelectedVMType);
            this.fVMArgs.setText("");
        } else {
            this.fVMTypeCombo.setEnabled(false);
            this.fVMName.setText(this.fEditedVM.getName());
            this.fRubyVMRoot.setText(this.fEditedVM.getInstallLocation().getAbsolutePath());
            this.fLibraryBlock.initializeFrom(this.fEditedVM, this.fSelectedVMType);
            String vmArgs = this.fEditedVM.getVMArgs();
            if (vmArgs != null) {
                this.fVMArgs.setText(vmArgs);
            }
        }
        this.setVMNameStatus(this.validateVMName());
        this.updateStatusLine();
    }

    private void setVMNameStatus(IStatus status) {
        this.fStati[0] = status;
    }

    protected void createFieldListeners() {
        this.fVMTypeCombo.setDialogFieldListener(new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField field) {
                AddVMDialog.this.updateVMType();
            }
        });
        this.fVMName.setDialogFieldListener(new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField field) {
                AddVMDialog.this.setVMNameStatus(AddVMDialog.this.validateVMName());
                AddVMDialog.this.updateStatusLine();
            }
        });
        this.fRubyVMRoot.setDialogFieldListener(new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField field) {
                AddVMDialog.this.setRubyVMLocationStatus(AddVMDialog.this.validateInterpreterLocationText());
                AddVMDialog.this.updateStatusLine();
            }
        });
    }

    private IStatus validateVMName() {
        StatusInfo status = new StatusInfo();
        String name = this.fVMName.getText();
        if (name == null || name.trim().length() == 0) {
            status.setInfo(RubyVMMessages.addVMDialog_enterName);
        } else if (this.fRequestor.isDuplicateName(name) && (this.fEditedVM == null || !name.equals(this.fEditedVM.getName()))) {
            status.setError(RubyVMMessages.addVMDialog_duplicateName);
        } else {
            IStatus s = ResourcesPlugin.getWorkspace().validateName(name, 1);
            if (!s.isOK()) {
                status.setError(MessageFormat.format(RubyVMMessages.AddVMDialog_JRE_name_must_be_a_valid_file_name___0__1, s.getMessage()));
            }
        }
        return status;
    }

    protected void createDialogFields() {
        this.fVMTypeCombo = new ComboDialogField(8);
        this.fVMTypeCombo.setLabelText(RubyVMMessages.addVMDialog_jreType);
        this.fVMTypeCombo.setItems(this.getVMTypeNames());
        this.fVMName = new StringDialogField();
        this.fVMName.setLabelText(RubyVMMessages.addVMDialog_jreName);
        this.fRubyVMRoot = new StringButtonDialogField(new IStringButtonAdapter(){

            public void changeControlPressed(DialogField field) {
                AddVMDialog.this.browseForInstallLocation();
            }
        });
        this.fRubyVMRoot.setLabelText(RubyVMMessages.addVMDialog_jreHome);
        this.fRubyVMRoot.setButtonLabel(RubyVMMessages.addVMDialog_browse1);
        this.fVMArgs = new StringDialogField();
        this.fVMArgs.setLabelText(RubyVMMessages.AddVMDialog_23);
    }

    private String[] getVMTypeNames() {
        String[] names = new String[this.fVMTypes.length];
        int i = 0;
        while (i < this.fVMTypes.length) {
            names[i] = this.fVMTypes[i].getName();
            ++i;
        }
        return names;
    }

    protected void setFieldValuesToVM(IVMInstall vm) {
        File dir = new File(this.fRubyVMRoot.getText());
        if (dir.getName().equals("bin")) {
            dir = dir.getParentFile();
        }
        try {
            vm.setInstallLocation(dir.getCanonicalFile());
        }
        catch (IOException iOException) {
            vm.setInstallLocation(dir.getAbsoluteFile());
        }
        vm.setName(this.fVMName.getText());
        String argString = this.fVMArgs.getText().trim();
        if (argString != null && argString.length() > 0) {
            vm.setVMArgs(argString);
        } else {
            vm.setVMArgs(null);
        }
        this.fLibraryBlock.performApply(vm);
    }
}

