/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.debug.ui.preferences;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.rubypeople.rdt.internal.debug.ui.RdtDebugUiMessages;
import org.rubypeople.rdt.internal.debug.ui.preferences.RubyInterpreterLabelProvider;
import org.rubypeople.rdt.internal.debug.ui.rubyvms.AddVMDialog;
import org.rubypeople.rdt.internal.debug.ui.rubyvms.IAddVMDialogRequestor;
import org.rubypeople.rdt.internal.debug.ui.rubyvms.RubyVMMessages;
import org.rubypeople.rdt.internal.debug.ui.rubyvms.RubyVMsUpdater;
import org.rubypeople.rdt.internal.ui.util.CollectionContentProvider;
import org.rubypeople.rdt.launching.IVMInstall;
import org.rubypeople.rdt.launching.IVMInstallType;
import org.rubypeople.rdt.launching.RubyRuntime;
import org.rubypeople.rdt.launching.VMStandin;

public class RubyInterpreterPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
IAddVMDialogRequestor {
    private List<IVMInstall> fVMs = new ArrayList<IVMInstall>();
    protected CheckboxTableViewer fVMList;
    protected Button addButton;
    protected Button editButton;
    protected Button removeButton;

    public RubyInterpreterPreferencePage() {
        this.setTitle(RubyVMMessages.JREsPreferencePage_1);
        this.setDescription(RubyVMMessages.JREsPreferencePage_2);
    }

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        this.noDefaultAndApplyButton();
        Composite composite = this.createPageRoot(parent);
        Label tableLabel = new Label(composite, 0);
        tableLabel.setText(RubyVMMessages.InstalledJREsBlock_15);
        GridData data = new GridData();
        data.horizontalSpan = 2;
        tableLabel.setLayoutData((Object)data);
        Font font = parent.getFont();
        composite.setFont(font);
        tableLabel.setFont(font);
        Table table = this.createInstalledInterpretersTable(composite);
        this.createInstalledInterpretersTableViewer(table);
        this.createButtonGroup(composite);
        this.fillWithWorkspaceRubyVMs();
        IVMInstall selectedInterpreter = RubyRuntime.getDefaultVMInstall();
        if (selectedInterpreter != null) {
            this.fVMList.setChecked((Object)selectedInterpreter, true);
        }
        this.enableButtons();
        return composite;
    }

    private void fillWithWorkspaceRubyVMs() {
        ArrayList<VMStandin> standins = new ArrayList<VMStandin>();
        IVMInstallType[] types = RubyRuntime.getVMInstallTypes();
        int i = 0;
        while (i < types.length) {
            IVMInstallType type = types[i];
            IVMInstall[] installs = type.getVMInstalls();
            int j = 0;
            while (j < installs.length) {
                IVMInstall install = installs[j];
                standins.add(new VMStandin(install));
                ++j;
            }
            ++i;
        }
        this.setJREs(standins.toArray(new IVMInstall[standins.size()]));
    }

    protected void setJREs(IVMInstall[] vms) {
        this.fVMs.clear();
        int i = 0;
        while (i < vms.length) {
            this.fVMs.add(vms[i]);
            ++i;
        }
        this.fVMList.setInput(this.fVMs);
        this.fVMList.refresh();
    }

    protected void createButtonGroup(Composite composite) {
        Composite buttons = new Composite(composite, 0);
        buttons.setLayoutData((Object)new GridData(2));
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttons.setLayout((Layout)layout);
        this.addButton = new Button(buttons, 8);
        this.addButton.setLayoutData((Object)new GridData(768));
        this.addButton.setText(RdtDebugUiMessages.RubyInterpreterPreferencePage_addButton_label);
        this.addButton.addListener(13, new Listener(){

            public void handleEvent(Event evt) {
                RubyInterpreterPreferencePage.this.addInterpreter();
            }
        });
        this.editButton = new Button(buttons, 8);
        this.editButton.setLayoutData((Object)new GridData(768));
        this.editButton.setText(RdtDebugUiMessages.RubyInterpreterPreferencePage_editButton_label);
        this.editButton.addListener(13, new Listener(){

            public void handleEvent(Event evt) {
                RubyInterpreterPreferencePage.this.editInterpreter();
            }
        });
        this.removeButton = new Button(buttons, 8);
        this.removeButton.setLayoutData((Object)new GridData(768));
        this.removeButton.setText(RdtDebugUiMessages.RubyInterpreterPreferencePage_removeButton_label);
        this.removeButton.addListener(13, new Listener(){

            public void handleEvent(Event evt) {
                RubyInterpreterPreferencePage.this.removeInterpreter();
            }
        });
    }

    protected void createInstalledInterpretersTableViewer(Table table) {
        this.fVMList = new CheckboxTableViewer(table);
        this.fVMList.setLabelProvider((IBaseLabelProvider)new RubyInterpreterLabelProvider());
        this.fVMList.setContentProvider((IContentProvider)new CollectionContentProvider());
        this.fVMList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent evt) {
                RubyInterpreterPreferencePage.this.enableButtons();
            }
        });
        this.fVMList.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                RubyInterpreterPreferencePage.this.updateSelectedInterpreter(event.getElement());
            }
        });
        this.fVMList.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent e) {
                RubyInterpreterPreferencePage.this.editInterpreter();
            }
        });
    }

    protected Table createInstalledInterpretersTable(Composite composite) {
        Table table = new Table(composite, 67616);
        GridData data = new GridData(1808);
        table.setLayoutData((Object)data);
        table.setHeaderVisible(true);
        table.setLinesVisible(false);
        TableColumn column = new TableColumn(table, 0);
        column.setText(RdtDebugUiMessages.RubyInterpreterPreferencePage_rubyInterpreterTable_interpreterName);
        column.setWidth(125);
        column = new TableColumn(table, 0);
        column.setText(RdtDebugUiMessages.RubyInterpreterPreferencePage_rubyInterpreterTable_interpreterPath);
        column.setWidth(250);
        column = new TableColumn(table, 0);
        column.setText(RdtDebugUiMessages.RubyInterpreterPreferencePage_rubyInterpreterTable_interpreterType);
        column.setWidth(125);
        return table;
    }

    protected Composite createPageRoot(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        return composite;
    }

    protected void addInterpreter() {
        AddVMDialog dialog = new AddVMDialog(this, this.getShell(), RubyRuntime.getVMInstallTypes(), null);
        dialog.setTitle(RubyVMMessages.InstalledJREsBlock_7);
        if (dialog.open() != 0) {
            return;
        }
    }

    protected void removeInterpreter() {
        this.fVMs.remove(this.getSelectedInterpreter());
        this.fVMList.refresh();
    }

    protected void enableButtons() {
        if (this.getSelectedInterpreter() != null) {
            this.editButton.setEnabled(true);
            this.removeButton.setEnabled(true);
        } else {
            this.editButton.setEnabled(false);
            this.removeButton.setEnabled(false);
        }
    }

    protected void updateSelectedInterpreter(Object interpreter) {
        Object[] checkedElements = this.fVMList.getCheckedElements();
        int i = 0;
        while (i < checkedElements.length) {
            this.fVMList.setChecked(checkedElements[i], false);
            ++i;
        }
        this.fVMList.setChecked(interpreter, true);
    }

    protected void editInterpreter() {
        IStructuredSelection selection = (IStructuredSelection)this.fVMList.getSelection();
        IVMInstall vm = (IVMInstall)selection.getFirstElement();
        if (vm == null) {
            return;
        }
        AddVMDialog dialog = new AddVMDialog(this, this.getShell(), RubyRuntime.getVMInstallTypes(), vm);
        dialog.setTitle(RubyVMMessages.InstalledJREsBlock_8);
        if (dialog.open() != 0) {
            return;
        }
        this.fVMList.refresh((Object)vm);
    }

    protected IVMInstall getSelectedInterpreter() {
        IStructuredSelection selection = (IStructuredSelection)this.fVMList.getSelection();
        return (IVMInstall)selection.getFirstElement();
    }

    public boolean performOk() {
        final boolean[] canceled = new boolean[1];
        BusyIndicator.showWhile(null, (Runnable)new Runnable(){

            public void run() {
                IVMInstall defaultVM = RubyInterpreterPreferencePage.this.getCheckedRubyVM();
                RubyVMsUpdater updater = new RubyVMsUpdater();
                IVMInstall[] vms = RubyInterpreterPreferencePage.this.getRubyVMs();
                if (!updater.updateRubyVMSettings(vms, defaultVM)) {
                    canceled[0] = true;
                }
            }
        });
        if (canceled[0]) {
            return false;
        }
        return super.performOk();
    }

    public IVMInstall getCheckedRubyVM() {
        Object[] objects = this.fVMList.getCheckedElements();
        if (objects.length == 0) {
            return null;
        }
        return (IVMInstall)objects[0];
    }

    public IVMInstall[] getRubyVMs() {
        return this.fVMs.toArray(new IVMInstall[this.fVMs.size()]);
    }

    public boolean isDuplicateName(String name) {
        int i = 0;
        while (i < this.fVMs.size()) {
            IVMInstall vm = this.fVMs.get(i);
            if (vm.getName().equals(name)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void vmAdded(IVMInstall vm) {
        this.fVMs.add(vm);
        this.fVMList.refresh();
    }
}

