/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.debug.ui.launcher;

import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.rubypeople.rdt.core.IRubyModel;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.debug.ui.launchConfigurations.RubyLaunchTab;
import org.rubypeople.rdt.internal.debug.ui.RdtDebugUiPlugin;
import org.rubypeople.rdt.internal.debug.ui.launcher.LauncherMessages;
import org.rubypeople.rdt.internal.launching.RubyMigrationDelegate;
import org.rubypeople.rdt.launching.IRubyLaunchConfigurationConstants;
import org.rubypeople.rdt.ui.RubyElementLabelProvider;

public abstract class AbstractRubyMainTab
extends RubyLaunchTab {
    protected static final String EMPTY_STRING = "";
    protected Text fProjText;
    private Button fProjButton;
    private WidgetListener fListener = new WidgetListener();

    private IRubyProject chooseRubyProject() {
        RubyElementLabelProvider labelProvider = new RubyElementLabelProvider(RubyElementLabelProvider.SHOW_DEFAULT);
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)labelProvider);
        dialog.setTitle(LauncherMessages.AbstractRubyMainTab_4);
        dialog.setMessage(LauncherMessages.AbstractRubyMainTab_3);
        try {
            dialog.setElements((Object[])RubyCore.create((IWorkspaceRoot)this.getWorkspaceRoot()).getRubyProjects());
        }
        catch (RubyModelException jme) {
            RdtDebugUiPlugin.log(jme);
        }
        IRubyProject javaProject = this.getRubyProject();
        if (javaProject != null) {
            dialog.setInitialSelections(new Object[]{javaProject});
        }
        if (dialog.open() == 0) {
            return (IRubyProject)dialog.getFirstResult();
        }
        return null;
    }

    protected void createProjectEditor(Composite parent) {
        Font font = parent.getFont();
        Group group = new Group(parent, 0);
        group.setText(LauncherMessages.AbstractRubyMainTab_0);
        GridData gd = new GridData(768);
        group.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        group.setLayout((Layout)layout);
        group.setFont(font);
        this.fProjText = new Text((Composite)group, 2052);
        gd = new GridData(768);
        this.fProjText.setLayoutData((Object)gd);
        this.fProjText.setFont(font);
        this.fProjText.addModifyListener((ModifyListener)this.fListener);
        this.fProjButton = this.createPushButton((Composite)group, LauncherMessages.AbstractRubyMainTab_1, null);
        this.fProjButton.addSelectionListener((SelectionListener)this.fListener);
    }

    protected WidgetListener getDefaultListener() {
        return this.fListener;
    }

    private IRubyModel getRubyModel() {
        return RubyCore.create((IWorkspaceRoot)this.getWorkspaceRoot());
    }

    protected IRubyProject getRubyProject() {
        String projectName = this.fProjText.getText().trim();
        if (projectName.length() < 1) {
            return null;
        }
        return this.getRubyModel().getRubyProject(projectName);
    }

    protected IWorkspaceRoot getWorkspaceRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    protected void handleProjectButtonSelected() {
        IRubyProject project = this.chooseRubyProject();
        if (project == null) {
            return;
        }
        String projectName = project.getElementName();
        this.fProjText.setText(projectName);
    }

    public void initializeFrom(ILaunchConfiguration config) {
        this.updateProjectFromConfig(config);
        super.initializeFrom(config);
    }

    private void updateProjectFromConfig(ILaunchConfiguration config) {
        String projectName = EMPTY_STRING;
        try {
            projectName = config.getAttribute(IRubyLaunchConfigurationConstants.ATTR_PROJECT_NAME, EMPTY_STRING);
        }
        catch (CoreException ce) {
            this.setErrorMessage(ce.getStatus().getMessage());
        }
        this.fProjText.setText(projectName);
    }

    protected void mapResources(ILaunchConfigurationWorkingCopy config) {
        try {
            IRubyProject rubyProject = this.getRubyProject();
            if (rubyProject != null && rubyProject.exists() && rubyProject.isOpen()) {
                RubyMigrationDelegate.updateResourceMapping((ILaunchConfigurationWorkingCopy)config);
            }
        }
        catch (CoreException ce) {
            this.setErrorMessage(ce.getStatus().getMessage());
        }
    }

    private class WidgetListener
    implements ModifyListener,
    SelectionListener {
        private WidgetListener() {
        }

        public void modifyText(ModifyEvent e) {
            AbstractRubyMainTab.this.updateLaunchConfigurationDialog();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            Object source = e.getSource();
            if (source == AbstractRubyMainTab.this.fProjButton) {
                AbstractRubyMainTab.this.handleProjectButtonSelected();
            } else {
                AbstractRubyMainTab.this.updateLaunchConfigurationDialog();
            }
        }
    }
}

