/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.debug.ui.evaluation;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.jface.text.Assert;
import org.rubypeople.rdt.internal.debug.ui.RdtDebugUiMessages;
import org.rubypeople.rdt.internal.debug.ui.evaluation.EvaluationExpression;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class EvaluationExpressionReaderWriter {
    private static final String TEMPLATE_ROOT = "expressions";
    private static final String TEMPLATE_ELEMENT = "expression";
    private static final String NAME_ATTRIBUTE = "name";
    private static final String DESCRIPTION_ATTRIBUTE = "description";
    private static final String ENABLED_ATTRIBUTE = "enabled";

    public EvaluationExpression[] read(Reader reader) throws IOException {
        return this.read(reader, null);
    }

    public EvaluationExpression[] read(Reader reader, ResourceBundle bundle) throws IOException {
        return this.read(new InputSource(reader), bundle);
    }

    public EvaluationExpression[] read(InputStream stream, ResourceBundle bundle) throws IOException {
        return this.read(new InputSource(stream), bundle);
    }

    private EvaluationExpression[] read(InputSource source, ResourceBundle bundle) throws IOException {
        try {
            ArrayList<EvaluationExpression> expressions = new ArrayList<EvaluationExpression>();
            new HashSet();
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder parser = factory.newDocumentBuilder();
            Document document = parser.parse(source);
            NodeList elements = document.getElementsByTagName(TEMPLATE_ELEMENT);
            int count = elements.getLength();
            int i = 0;
            while (i != count) {
                Node node = elements.item(i);
                NamedNodeMap attributes = node.getAttributes();
                if (attributes != null) {
                    String name = this.getStringValue(attributes, NAME_ATTRIBUTE);
                    name = this.translateString(name, bundle);
                    String description = this.getStringValue(attributes, DESCRIPTION_ATTRIBUTE, "");
                    description = this.translateString(description, bundle);
                    String enabled = this.getStringValue(attributes, ENABLED_ATTRIBUTE, "false");
                    StringBuffer buffer = new StringBuffer();
                    NodeList children = node.getChildNodes();
                    int j = 0;
                    while (j != children.getLength()) {
                        String value = children.item(j).getNodeValue();
                        if (value != null) {
                            buffer.append(value);
                        }
                        ++j;
                    }
                    expressions.add(new EvaluationExpression(name, description, buffer.toString(), new Boolean(enabled)));
                }
                ++i;
            }
            return expressions.toArray(new EvaluationExpression[expressions.size()]);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            Assert.isTrue((boolean)false);
        }
        catch (SAXException e) {
            Throwable t = e.getCause();
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            throw new IOException(t.getMessage());
        }
        return null;
    }

    public void save(EvaluationExpression[] templates, OutputStream stream) throws IOException {
        this.save(templates, new StreamResult(stream));
    }

    public void save(EvaluationExpression[] templates, Writer writer) throws IOException {
        this.save(templates, new StreamResult(writer));
    }

    private void save(EvaluationExpression[] templates, StreamResult result) throws IOException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.newDocument();
            Element root = document.createElement(TEMPLATE_ROOT);
            document.appendChild(root);
            int i = 0;
            while (i < templates.length) {
                EvaluationExpression evaluationExpression = templates[i];
                Element node = document.createElement(TEMPLATE_ELEMENT);
                root.appendChild(node);
                NamedNodeMap attributes = node.getAttributes();
                Attr name = document.createAttribute(NAME_ATTRIBUTE);
                name.setValue(evaluationExpression.getName());
                attributes.setNamedItem(name);
                Attr description = document.createAttribute(DESCRIPTION_ATTRIBUTE);
                description.setValue(evaluationExpression.getDescription());
                attributes.setNamedItem(description);
                Attr enabled = document.createAttribute(ENABLED_ATTRIBUTE);
                enabled.setValue(String.valueOf(evaluationExpression.isEnabled()));
                attributes.setNamedItem(enabled);
                Text pattern = document.createTextNode(evaluationExpression.getExpression());
                node.appendChild(pattern);
                ++i;
            }
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("encoding", "UTF-8");
            DOMSource source = new DOMSource(document);
            transformer.transform(source, result);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            Assert.isTrue((boolean)false);
        }
        catch (TransformerException e) {
            if (e.getException() instanceof IOException) {
                throw (IOException)e.getException();
            }
            Assert.isTrue((boolean)false);
        }
    }

    private String getStringValue(NamedNodeMap attributes, String name) throws SAXException {
        return this.getStringValue(attributes, name, null);
    }

    private String getStringValue(NamedNodeMap attributes, String name, String defaultValue) {
        Node node = attributes.getNamedItem(name);
        return node == null ? defaultValue : node.getNodeValue();
    }

    private String translateString(String str, ResourceBundle bundle) {
        if (bundle == null) {
            return str;
        }
        int idx = str.indexOf(37);
        if (idx == -1) {
            return str;
        }
        StringBuffer buf = new StringBuffer();
        int k = 0;
        while (idx != -1) {
            buf.append(str.substring(k, idx));
            k = idx + 1;
            while (k < str.length() && !Character.isWhitespace(str.charAt(k))) {
                ++k;
            }
            String key = str.substring(idx + 1, k);
            buf.append(this.getBundleString(key, bundle));
            idx = str.indexOf(37, k);
        }
        buf.append(str.substring(k));
        return buf.toString();
    }

    private String getBundleString(String key, ResourceBundle bundle) {
        if (bundle != null) {
            try {
                return bundle.getString(key);
            }
            catch (MissingResourceException missingResourceException) {
                return String.valueOf('!') + key + '!';
            }
        }
        return RdtDebugUiMessages.getString(key);
    }
}

