/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.debug.ui.console;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.ui.console.IConsole;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.IHyperlink;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.rubypeople.rdt.internal.debug.ui.RdtDebugUiPlugin;
import org.rubypeople.rdt.internal.debug.ui.RubySourceLocator;
import org.rubypeople.rdt.internal.ui.util.StackTraceLine;

public class RubyStackTraceHyperlink
implements IHyperlink {
    private IConsole fConsole;
    private StackTraceLine fTraceLine;

    public RubyStackTraceHyperlink(IConsole console, StackTraceLine line) {
        this.fConsole = console;
        this.fTraceLine = line;
    }

    public void linkEntered() {
    }

    public void linkExited() {
    }

    private void setEditorToLine(IEditorPart pEditorPart, IEditorInput pInput) throws CoreException {
        IDocumentProvider provider;
        block5: {
            if (!(pEditorPart instanceof ITextEditor)) {
                return;
            }
            int lineNumber = this.getLineNumber();
            if (lineNumber > 0) {
                --lineNumber;
            }
            if (lineNumber == 0) {
                return;
            }
            ITextEditor textEditor = (ITextEditor)pEditorPart;
            provider = textEditor.getDocumentProvider();
            provider.connect((Object)pInput);
            IDocument document = provider.getDocument((Object)pInput);
            try {
                IRegion line = document.getLineInformation(lineNumber);
                textEditor.selectAndReveal(line.getOffset(), line.getLength());
            }
            catch (BadLocationException badLocationException) {
                if (!RdtDebugUiPlugin.getDefault().isDebugging()) break block5;
                System.out.println("Could not set editor to line: " + lineNumber);
            }
        }
        provider.disconnect((Object)pInput);
    }

    public void linkActivated() {
        RubySourceLocator rubySourceLocator = null;
        ILaunch launch = this.getConsole().getProcess().getLaunch();
        if (launch == null) {
            return;
        }
        ISourceLocator sourceLocator = launch.getSourceLocator();
        if (!(sourceLocator instanceof RubySourceLocator)) {
            return;
        }
        rubySourceLocator = (RubySourceLocator)sourceLocator;
        String filename = this.getFilename();
        try {
            Object sourceElement = rubySourceLocator.getSourceElement(filename);
            IEditorInput input = rubySourceLocator.getEditorInput(sourceElement);
            if (input == null) {
                if (RdtDebugUiPlugin.getDefault().isDebugging()) {
                    System.out.println("Could not create editor input for stack trace: " + filename);
                }
                return;
            }
            IEditorPart editorPart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor(input, rubySourceLocator.getEditorId(input, sourceElement));
            this.setEditorToLine(editorPart, input);
        }
        catch (CoreException e) {
            RdtDebugUiPlugin.log((IStatus)new Status(4, "org.rubypeople.rdt.debug.ui", 0, "Could not open editor or set line in editor." + filename, (Throwable)e));
        }
    }

    public int getLineNumber() {
        return this.fTraceLine.getLineNumber();
    }

    public String getFilename() {
        return this.fTraceLine.getFilename();
    }

    protected IConsole getConsole() {
        return this.fConsole;
    }

    protected String getLinkText() throws BadLocationException {
        IRegion region = this.getConsole().getRegion((IHyperlink)this);
        return this.getConsole().getDocument().get(region.getOffset(), region.getLength());
    }
}

