/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.debug.ui.console;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.ui.console.IConsole;
import org.eclipse.debug.ui.console.IConsoleLineTracker;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ui.console.IHyperlink;
import org.rubypeople.rdt.internal.debug.ui.console.RubyStackTraceHyperlink;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.util.StackTraceLine;
import org.rubypeople.rdt.launching.IRubyLaunchConfigurationConstants;

public class RubyConsoleTracker
implements IConsoleLineTracker {
    private final FileExistanceChecker existanceChecker;
    protected IConsole fConsole;
    private ILaunch fLastLaunch;
    private IProject fProject;

    public RubyConsoleTracker() {
        this(new StandardFileExistanceChecker());
    }

    public RubyConsoleTracker(FileExistanceChecker existance) {
        this.existanceChecker = existance;
    }

    public void init(IConsole pConsole) {
        this.fConsole = pConsole;
    }

    public void lineAppended(IRegion line) {
        try {
            int prefix = 0;
            String text = this.getText(line);
            while (StackTraceLine.isTraceLine((String)text)) {
                StackTraceLine stackTraceLine = new StackTraceLine(text, this.getProject());
                if (!this.existanceChecker.fileExists(stackTraceLine.getFilename())) {
                    return;
                }
                RubyStackTraceHyperlink link = new RubyStackTraceHyperlink(this.fConsole, stackTraceLine);
                this.fConsole.addLink((IHyperlink)link, line.getOffset() + prefix + stackTraceLine.offset(), stackTraceLine.length());
                prefix = stackTraceLine.offset() + stackTraceLine.length();
                int substring = stackTraceLine.offset() + stackTraceLine.length();
                if (text.length() < substring - 1) {
                    text = "";
                    continue;
                }
                if (!(text = text.substring(substring)).startsWith(":in `require':")) continue;
                text = text.substring(14);
                prefix += 14;
            }
        }
        catch (BadLocationException badLocationException) {}
    }

    protected IProject getProject() {
        if (this.fLastLaunch == null || this.fConsole.getProcess() != null && !this.fLastLaunch.equals(this.fConsole.getProcess().getLaunch())) {
            if (this.fConsole.getProcess() == null) {
                return null;
            }
            this.fLastLaunch = this.fConsole.getProcess().getLaunch();
            String projectName = null;
            try {
                if (this.fConsole.getProcess() != null && this.fConsole.getProcess().getLaunch() != null && this.fConsole.getProcess().getLaunch().getLaunchConfiguration() != null) {
                    projectName = this.fConsole.getProcess().getLaunch().getLaunchConfiguration().getAttribute(IRubyLaunchConfigurationConstants.ATTR_PROJECT_NAME, null);
                }
            }
            catch (Exception e) {
                RubyPlugin.log((Throwable)e);
            }
            if (projectName == null) {
                return null;
            }
            this.fProject = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        }
        return this.fProject;
    }

    protected String getText(IRegion line) throws BadLocationException {
        return this.fConsole.getDocument().get(line.getOffset(), line.getLength());
    }

    public void dispose() {
        this.fConsole = null;
    }

    public static interface FileExistanceChecker {
        public boolean fileExists(String var1);
    }

    public static class StandardFileExistanceChecker
    implements FileExistanceChecker {
        public boolean fileExists(String filename) {
            File file = new File(filename);
            if (file.exists()) {
                return true;
            }
            Path path = new Path(filename);
            if (!path.isValidPath(filename)) {
                return false;
            }
            try {
                IFile iFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
                if (iFile != null) {
                    return iFile.exists();
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return false;
            }
            return false;
        }
    }
}

