/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.debug.ui.breakpoints;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.rubypeople.rdt.core.IType;
import org.rubypeople.rdt.core.ITypeHierarchy;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.debug.ui.RdtDebugUiPlugin;
import org.rubypeople.rdt.internal.ui.dialogs.StatusInfo;
import org.rubypeople.rdt.ui.dialogs.TypeSelectionExtension;

public class AddExceptionDialogExtension
extends TypeSelectionExtension {
    public ISelectionStatusValidator getSelectionValidator() {
        ISelectionStatusValidator validator = new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                IType type = null;
                int i = 0;
                while (i < selection.length) {
                    type = (IType)selection[i];
                    if (!AddExceptionDialogExtension.this.isException(type)) {
                        return new StatusInfo(4, "Selected type is not an exception");
                    }
                    ++i;
                }
                return new StatusInfo(0, "");
            }
        };
        return validator;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean isException(IType type) {
        if (type == null) return false;
        try {
            ITypeHierarchy hierarchy = type.newSupertypeHierarchy((IProgressMonitor)new NullProgressMonitor());
            IType curr = type;
            while (true) {
                if (curr == null) {
                    return false;
                }
                if ("Exception".equals(curr.getFullyQualifiedName())) {
                    return true;
                }
                curr = hierarchy.getSuperclass(curr);
            }
        }
        catch (RubyModelException e) {
            RdtDebugUiPlugin.log(e);
        }
        return false;
    }
}

