/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.debug.ui.breakpoints;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.rubypeople.rdt.core.IType;
import org.rubypeople.rdt.core.search.IRubySearchScope;
import org.rubypeople.rdt.core.search.SearchEngine;
import org.rubypeople.rdt.debug.core.model.IRubyExceptionBreakpoint;
import org.rubypeople.rdt.internal.debug.core.RubyExceptionBreakpoint;
import org.rubypeople.rdt.internal.debug.ui.RdtDebugUiPlugin;
import org.rubypeople.rdt.internal.debug.ui.breakpoints.AddExceptionDialogExtension;
import org.rubypeople.rdt.internal.debug.ui.breakpoints.BreakpointMessages;
import org.rubypeople.rdt.ui.RubyUI;
import org.rubypeople.rdt.ui.dialogs.TypeSelectionExtension;

public class AddExceptionAction
implements IViewActionDelegate,
IWorkbenchWindowActionDelegate {
    public static final String DIALOG_SETTINGS = "AddExceptionDialog";
    private IWorkbenchWindow fWorkbenchWindow = null;

    public void run(IAction action) {
        Shell shell = RdtDebugUiPlugin.getActiveWorkbenchShell();
        AddExceptionDialogExtension ext = new AddExceptionDialogExtension();
        try {
            SelectionDialog dialog = RubyUI.createTypeDialog((Shell)shell, (IRunnableContext)this.fWorkbenchWindow, (IRubySearchScope)SearchEngine.createWorkspaceScope(), (int)4, (boolean)true, (String)"*Error*", (TypeSelectionExtension)ext);
            dialog.setTitle(BreakpointMessages.AddExceptionAction_0);
            dialog.setMessage(BreakpointMessages.AddExceptionAction_1);
            if (dialog.open() == 0) {
                Object[] results = dialog.getResult();
                int i = 0;
                while (i < results.length) {
                    this.createBreakpoint((IType)results[i]);
                    ++i;
                }
            }
        }
        catch (CoreException e) {
            RdtDebugUiPlugin.errorDialog(BreakpointMessages.AddExceptionAction_error, e.getStatus());
        }
    }

    private void createBreakpoint(final IType type) throws CoreException {
        IBreakpoint[] breakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints("org.rubypeople.rdt.debug");
        boolean exists = false;
        IRubyExceptionBreakpoint existingBreakpoint = null;
        int j = 0;
        while (j < breakpoints.length) {
            IBreakpoint breakpoint = breakpoints[j];
            if (breakpoint instanceof IRubyExceptionBreakpoint && (existingBreakpoint = (IRubyExceptionBreakpoint)breakpoint).getException().equals(type.getFullyQualifiedName())) {
                exists = true;
                break;
            }
            ++j;
        }
        if (exists) {
            existingBreakpoint.delete();
        }
        new Job(BreakpointMessages.AddExceptionAction_0){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    new RubyExceptionBreakpoint(type.getFullyQualifiedName());
                    return Status.OK_STATUS;
                }
                catch (CoreException e) {
                    return e.getStatus();
                }
            }
        }.schedule();
    }

    public void init(IViewPart view) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void dispose() {
        this.fWorkbenchWindow = null;
    }

    public void init(IWorkbenchWindow window) {
        this.fWorkbenchWindow = window;
    }
}

