/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.debug.ui.actions;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.ui.IDebugView;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.rubypeople.rdt.debug.core.model.IRubyStackFrame;
import org.rubypeople.rdt.debug.core.model.IRubyVariable;
import org.rubypeople.rdt.internal.debug.core.model.RubyExpression;
import org.rubypeople.rdt.internal.debug.core.model.RubyProcessingException;
import org.rubypeople.rdt.internal.debug.ui.actions.AbstractInspectAction;

public class InspectAction
extends AbstractInspectAction
implements IViewActionDelegate,
IEditorActionDelegate {
    private IRubyVariable inspectResult;

    protected IRubyStackFrame getRubyStackFrame() {
        IViewPart part = this.page.findView("org.eclipse.debug.ui.DebugView");
        if (part == null) {
            return null;
        }
        IDebugView launchView = (IDebugView)part;
        StructuredSelection selected = (StructuredSelection)launchView.getViewer().getSelection();
        if (selected.isEmpty()) {
            return null;
        }
        if (!(selected.getFirstElement() instanceof IRubyStackFrame)) {
            return null;
        }
        return (IRubyStackFrame)selected.getFirstElement();
    }

    public void run(IAction action) {
        final IRubyStackFrame stackFrame = this.getRubyStackFrame();
        if (stackFrame == null) {
            MessageDialog.openInformation((Shell)this.page.getActivePart().getSite().getShell(), (String)"No suitable stack frame", (String)"Could not inspect because there is no context (a ruby stack frame) for inspection selected.");
            return;
        }
        if (!(this.selection instanceof ITextSelection)) {
            return;
        }
        final String selectedText = ((ITextSelection)this.selection).getText().replace('\n', ';').replace('\r', ' ');
        String jobName = "Inspect " + (selectedText.length() < 20 ? selectedText : String.valueOf(selectedText.substring(0, 19)) + "...");
        Job job = new Job(jobName){

            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask("inspecting", -1);
                IStatus result = null;
                try {
                    InspectAction.this.inspectResult = (IRubyVariable)stackFrame.getRubyDebuggerProxy().readInspectExpression(stackFrame, selectedText);
                    result = Status.OK_STATUS;
                }
                catch (RubyProcessingException e) {
                    String message = String.valueOf(e.getRubyExceptionType()) + " inspecting '" + selectedText + "':\n" + e.getMessage();
                    result = new Status(4, "org.rubypeople.rdt.debug.core", 4, message, (Throwable)e);
                }
                return result;
            }
        };
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(final IJobChangeEvent event) {
                Display.getDefault().syncExec(new Runnable(){

                    public void run() {
                        if (event.getResult().isOK()) {
                            InspectAction.this.showExpressionView();
                            DebugPlugin.getDefault().getExpressionManager().addExpression((IExpression)new RubyExpression(selectedText, InspectAction.this.inspectResult));
                        }
                    }
                });
            }
        });
        job.setPriority(20);
        job.schedule();
    }

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        this.page = targetEditor == null || targetEditor.getEditorSite() == null ? null : targetEditor.getEditorSite().getPage();
    }
}

