/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.debug.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.IDebugView;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.texteditor.ITextEditor;
import org.rubypeople.rdt.debug.core.RdtDebugCorePlugin;
import org.rubypeople.rdt.debug.core.model.IEvaluationResult;
import org.rubypeople.rdt.debug.core.model.IRubyStackFrame;
import org.rubypeople.rdt.debug.core.model.IRubyValue;
import org.rubypeople.rdt.debug.core.model.IRubyVariable;
import org.rubypeople.rdt.internal.debug.ui.RdtDebugUiPlugin;
import org.rubypeople.rdt.internal.debug.ui.actions.ActionMessages;
import org.rubypeople.rdt.internal.debug.ui.display.IDataDisplay;
import org.rubypeople.rdt.internal.debug.ui.display.RubyInspectExpression;
import org.rubypeople.rdt.internal.ui.text.RubyWordFinder;

public abstract class EvaluateAction
implements IWorkbenchWindowActionDelegate,
IObjectActionDelegate,
IEditorActionDelegate,
IPartListener,
IViewActionDelegate {
    private IAction fAction;
    private IWorkbenchPart fTargetPart;
    private IWorkbenchWindow fWindow;
    private Object fSelection;
    private IRegion fRegion;
    private boolean fEvaluating;
    private IWorkbenchPart fNewTargetPart = null;
    private IDebugModelPresentation fPresentation;

    protected IRubyValue getObjectContext() {
        IValue value;
        IWorkbenchPage page = RdtDebugUiPlugin.getActivePage();
        if (page == null) {
            return null;
        }
        IWorkbenchPart activePart = page.getActivePart();
        if (activePart == null) {
            return null;
        }
        IDebugView a = (IDebugView)activePart.getAdapter(IDebugView.class);
        if (a == null || a.getViewer() == null) {
            return null;
        }
        ISelection s = a.getViewer().getSelection();
        if (!(s instanceof IStructuredSelection)) {
            return null;
        }
        IStructuredSelection structuredSelection = (IStructuredSelection)s;
        if (structuredSelection.size() != 1) {
            return null;
        }
        Object selection = structuredSelection.getFirstElement();
        if (selection instanceof IRubyVariable) {
            IRubyVariable var = (IRubyVariable)selection;
            try {
                IValue value2;
                if (!var.getName().equals("this") && (value2 = var.getValue()) instanceof IRubyValue) {
                    return (IRubyValue)value2;
                }
            }
            catch (DebugException e) {
                RdtDebugUiPlugin.log(e);
            }
        } else if (selection instanceof RubyInspectExpression && (value = ((RubyInspectExpression)((Object)selection)).getValue()) instanceof IRubyValue) {
            return (IRubyValue)value;
        }
        return null;
    }

    protected IRubyStackFrame getStackFrameContext() {
        try {
            IWorkbenchPart part = this.getTargetPart();
            if (part == null) {
                return RdtDebugUiPlugin.getEvaluationContextManager().getEvaluationContext(this.getWindow());
            }
            return RdtDebugUiPlugin.getEvaluationContextManager().getEvaluationContext(part);
        }
        catch (Throwable e) {
            RdtDebugUiPlugin.log(e);
            return null;
        }
    }

    public void evaluationComplete(IEvaluationResult result) {
        if (RdtDebugUiPlugin.getDefault() == null) {
            return;
        }
        IValue value = result.getValue();
        if (result.hasErrors() || value != null) {
            Display display = RdtDebugUiPlugin.getStandardDisplay();
            if (display.isDisposed()) {
                return;
            }
            this.displayResult(result);
        }
    }

    protected void evaluationCleanup() {
        this.setEvaluating(false);
        this.setTargetPart(this.fNewTargetPart);
    }

    protected abstract void displayResult(IEvaluationResult var1);

    protected void run() {
        this.getObjectContext();
        final IRubyStackFrame stackFrame = this.getStackFrameContext();
        if (stackFrame == null) {
            this.reportError(ActionMessages.Evaluate_error_message_stack_frame_context);
            return;
        }
        stackFrame.getThread();
        this.setNewTargetPart(this.getTargetPart());
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                if (stackFrame.isSuspended()) {
                    Object selection = EvaluateAction.this.getSelectedObject();
                    if (!(selection instanceof String)) {
                        return;
                    }
                    String expression = (String)selection;
                    EvaluateAction.this.setEvaluating(true);
                    IEvaluationResult result = stackFrame.evaluate(expression);
                    EvaluateAction.this.evaluationComplete(result);
                    return;
                }
                throw new InvocationTargetException(null, ActionMessages.EvaluateAction_Thread_not_suspended___unable_to_perform_evaluation__1);
            }
        };
        IWorkbench workbench = RdtDebugUiPlugin.getDefault().getWorkbench();
        try {
            workbench.getProgressService().busyCursorWhile(runnable);
        }
        catch (InvocationTargetException e) {
            this.evaluationCleanup();
            String message = e.getMessage();
            if (message == null) {
                message = e.getClass().getName();
                if (e.getCause() != null) {
                    message = e.getCause().getClass().getName();
                    if (e.getCause().getMessage() != null) {
                        message = e.getCause().getMessage();
                    }
                }
            }
            this.reportError(message);
        }
        catch (InterruptedException interruptedException) {}
    }

    protected void update() {
        IAction action = this.getAction();
        if (action != null) {
            this.resolveSelectedObject();
        }
    }

    protected void resolveSelectedObject() {
        Object selectedObject = null;
        this.fRegion = null;
        ISelection selection = this.getTargetSelection();
        if (selection instanceof ITextSelection) {
            IEditorPart editor;
            ITextSelection ts = (ITextSelection)selection;
            String text = ts.getText();
            if (this.textHasContent(text)) {
                selectedObject = text;
                this.fRegion = new Region(ts.getOffset(), ts.getLength());
            } else if (this.getTargetPart() instanceof IEditorPart && (editor = (IEditorPart)this.getTargetPart()) instanceof ITextEditor) {
                selectedObject = this.resolveSelectedObjectUsingToken(selectedObject, ts, editor);
            }
        } else if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
            if (this.getTargetPart().getSite().getId().equals("org.eclipse.debug.ui.DebugView")) {
                IEditorPart editor = this.getTargetPart().getSite().getPage().getActiveEditor();
                this.setTargetPart((IWorkbenchPart)editor);
                selection = this.getTargetSelection();
                if (selection instanceof ITextSelection) {
                    ITextSelection ts = (ITextSelection)selection;
                    String text = ts.getText();
                    if (this.textHasContent(text)) {
                        selectedObject = text;
                    } else if (editor instanceof ITextEditor) {
                        selectedObject = this.resolveSelectedObjectUsingToken(selectedObject, ts, editor);
                    }
                }
            } else {
                IStructuredSelection ss = (IStructuredSelection)selection;
                Iterator elements = ss.iterator();
                while (elements.hasNext()) {
                    if (elements.next() instanceof IRubyVariable) continue;
                    this.setSelectedObject(null);
                    return;
                }
                selectedObject = ss;
            }
        }
        this.setSelectedObject(selectedObject);
    }

    private Object resolveSelectedObjectUsingToken(Object selectedObject, ITextSelection ts, IEditorPart editor) {
        ITextEditor textEditor = (ITextEditor)editor;
        IDocument doc = textEditor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
        this.fRegion = RubyWordFinder.findWord((IDocument)doc, (int)ts.getOffset());
        if (this.fRegion != null) {
            try {
                selectedObject = doc.get(this.fRegion.getOffset(), this.fRegion.getLength());
            }
            catch (BadLocationException badLocationException) {}
        }
        return selectedObject;
    }

    protected ISelection getTargetSelection() {
        ISelectionProvider provider;
        IWorkbenchPart part = this.getTargetPart();
        if (part != null && (provider = part.getSite().getSelectionProvider()) != null) {
            return provider.getSelection();
        }
        return null;
    }

    protected boolean compareToEditorInput(IStackFrame stackFrame) {
        ILaunch launch = stackFrame.getLaunch();
        if (launch == null) {
            return false;
        }
        ISourceLocator locator = launch.getSourceLocator();
        if (locator == null) {
            return false;
        }
        Object sourceElement = locator.getSourceElement(stackFrame);
        if (sourceElement == null) {
            return false;
        }
        IEditorInput sfEditorInput = this.getDebugModelPresentation().getEditorInput(sourceElement);
        if (this.getTargetPart() instanceof IEditorPart) {
            return ((IEditorPart)this.getTargetPart()).getEditorInput().equals(sfEditorInput);
        }
        return false;
    }

    protected Shell getShell() {
        if (this.getTargetPart() != null) {
            return this.getTargetPart().getSite().getShell();
        }
        return RdtDebugUiPlugin.getActiveWorkbenchShell();
    }

    protected IDataDisplay getDataDisplay() {
        IWorkbenchPart activePart;
        IDataDisplay display = this.getDirectDataDisplay();
        if (display != null) {
            return display;
        }
        IWorkbenchPage page = RdtDebugUiPlugin.getActivePage();
        if (page != null && (activePart = page.getActivePart()) != null) {
            IViewPart view;
            block9: {
                view = page.findView("org.rubypeople.rdt.debug.ui.DisplayView");
                if (view == null) {
                    try {
                        try {
                            view = page.showView("org.rubypeople.rdt.debug.ui.DisplayView");
                        }
                        catch (PartInitException e) {
                            RdtDebugUiPlugin.errorDialog(ActionMessages.EvaluateAction_Cannot_open_Display_view, e);
                            page.activate(activePart);
                            break block9;
                        }
                    }
                    catch (Throwable throwable) {
                        page.activate(activePart);
                        throw throwable;
                    }
                    page.activate(activePart);
                }
            }
            if (view != null) {
                page.bringToTop((IWorkbenchPart)view);
                return (IDataDisplay)view.getAdapter(IDataDisplay.class);
            }
        }
        return null;
    }

    protected IDataDisplay getDirectDataDisplay() {
        IDataDisplay display;
        IWorkbenchPart activePart;
        IDataDisplay display2;
        IWorkbenchPart part = this.getTargetPart();
        if (part != null && (display2 = (IDataDisplay)part.getAdapter(IDataDisplay.class)) != null) {
            IWorkbenchPart activePart2;
            IWorkbenchPage page = RdtDebugUiPlugin.getActivePage();
            if (page != null && (activePart2 = page.getActivePart()) != null && activePart2 != part) {
                page.activate(part);
            }
            return display2;
        }
        IWorkbenchPage page = RdtDebugUiPlugin.getActivePage();
        if (page != null && (activePart = page.getActivePart()) != null && (display = (IDataDisplay)activePart.getAdapter(IDataDisplay.class)) != null) {
            return display;
        }
        return null;
    }

    protected boolean textHasContent(String text) {
        int length;
        if (text != null && (length = text.length()) > 0) {
            int i = 0;
            while (i < length) {
                if (Character.isLetterOrDigit(text.charAt(i))) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    protected void reportErrors(IEvaluationResult result) {
        String message = this.getErrorMessage(result);
        this.reportError(message);
    }

    protected void reportError(String message) {
        IDataDisplay dataDisplay = this.getDirectDataDisplay();
        if (dataDisplay != null) {
            if (message.length() != 0) {
                dataDisplay.displayExpressionValue(MessageFormat.format(ActionMessages.EvaluateAction__evaluation_failed__Reason, this.format(message)));
            } else {
                dataDisplay.displayExpressionValue(ActionMessages.EvaluateAction__evaluation_failed__1);
            }
        } else {
            Status status = new Status(4, RdtDebugUiPlugin.getUniqueIdentifier(), 4, message, null);
            ErrorDialog.openError((Shell)this.getShell(), (String)ActionMessages.Evaluate_error_title_eval_problems, null, (IStatus)status);
        }
    }

    private String format(String message) {
        int pos;
        StringBuffer result = new StringBuffer();
        int index = 0;
        while ((pos = message.indexOf(10, index)) != -1) {
            int n = index;
            index = pos + 1;
            result.append("\t\t").append(message.substring(n, index));
        }
        if (index < message.length()) {
            result.append("\t\t").append(message.substring(index));
        }
        return result.toString();
    }

    public static String getExceptionMessage(Throwable exception) {
        if (exception instanceof CoreException) {
            CoreException ce = (CoreException)exception;
            Throwable throwable = ce.getStatus().getException();
            if (throwable instanceof CoreException) {
                return EvaluateAction.getExceptionMessage(throwable);
            }
            return ce.getStatus().getMessage();
        }
        String message = MessageFormat.format(ActionMessages.Evaluate_error_message_direct_exception, exception.getClass());
        if (exception.getMessage() != null) {
            message = MessageFormat.format(ActionMessages.Evaluate_error_message_exception_pattern, message, exception.getMessage());
        }
        return message;
    }

    protected String getErrorMessage(IEvaluationResult result) {
        String[] errors = result.getErrorMessages();
        if (errors.length == 0) {
            return EvaluateAction.getExceptionMessage(result.getException());
        }
        return this.getErrorMessage(errors);
    }

    protected String getErrorMessage(String[] errors) {
        String message = "";
        int i = 0;
        while (i < errors.length) {
            String msg = errors[i];
            message = i == 0 ? msg : MessageFormat.format(ActionMessages.Evaluate_error_problem_append_pattern, message, msg);
            ++i;
        }
        return message;
    }

    public void run(IAction action) {
        this.update();
        this.run();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.setAction(action);
    }

    public void dispose() {
        this.disposeDebugModelPresentation();
        IWorkbenchWindow win = this.getWindow();
        if (win != null) {
            win.getPartService().removePartListener((IPartListener)this);
        }
    }

    public void init(IWorkbenchWindow window) {
        this.setWindow(window);
        IWorkbenchPage page = window.getActivePage();
        if (page != null) {
            this.setTargetPart(page.getActivePart());
        }
        window.getPartService().addPartListener((IPartListener)this);
        this.update();
    }

    protected IAction getAction() {
        return this.fAction;
    }

    protected void setAction(IAction action) {
        this.fAction = action;
    }

    protected IDebugModelPresentation getDebugModelPresentation() {
        if (this.fPresentation == null) {
            this.fPresentation = DebugUITools.newDebugModelPresentation((String)RdtDebugCorePlugin.getPluginIdentifier());
        }
        return this.fPresentation;
    }

    protected void disposeDebugModelPresentation() {
        if (this.fPresentation != null) {
            this.fPresentation.dispose();
        }
    }

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        this.setAction(action);
        this.setTargetPart((IWorkbenchPart)targetEditor);
    }

    public void partActivated(IWorkbenchPart part) {
        this.setTargetPart(part);
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
        if (part == this.getTargetPart()) {
            this.setTargetPart(null);
        }
        if (part == this.getNewTargetPart()) {
            this.setNewTargetPart(null);
        }
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
    }

    public void init(IViewPart view) {
        this.setTargetPart((IWorkbenchPart)view);
    }

    protected IWorkbenchPart getTargetPart() {
        return this.fTargetPart;
    }

    protected void setTargetPart(IWorkbenchPart part) {
        if (this.isEvaluating()) {
            this.setNewTargetPart(part);
        } else {
            this.fTargetPart = part;
        }
    }

    protected IWorkbenchWindow getWindow() {
        return this.fWindow;
    }

    protected void setWindow(IWorkbenchWindow window) {
        this.fWindow = window;
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.setAction(action);
        this.setTargetPart(targetPart);
        this.update();
    }

    protected Object getSelectedObject() {
        return this.fSelection;
    }

    protected void setSelectedObject(Object selection) {
        this.fSelection = selection;
    }

    protected IWorkbenchPart getNewTargetPart() {
        return this.fNewTargetPart;
    }

    protected void setNewTargetPart(IWorkbenchPart newTargetPart) {
        this.fNewTargetPart = newTargetPart;
    }

    protected boolean isEvaluating() {
        return this.fEvaluating;
    }

    protected void setEvaluating(boolean evaluating) {
        this.fEvaluating = evaluating;
    }

    protected IRegion getRegion() {
        return this.fRegion;
    }

    public static Point getPopupAnchor(ITextViewer viewer) {
        StyledText textWidget = viewer.getTextWidget();
        Point docRange = textWidget.getSelectionRange();
        int midOffset = docRange.x + docRange.y / 2;
        Point point = textWidget.getLocationAtOffset(midOffset);
        point = textWidget.toDisplay(point);
        GC gc = new GC((Drawable)textWidget);
        gc.setFont(textWidget.getFont());
        int height = gc.getFontMetrics().getHeight();
        gc.dispose();
        point.y += height;
        return point;
    }
}

