/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.debug.ui;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IPersistableSourceLocator;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.ui.ISourcePresentation;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;
import org.rubypeople.rdt.debug.core.RdtDebugCorePlugin;
import org.rubypeople.rdt.debug.core.model.IRubyStackFrame;
import org.rubypeople.rdt.internal.debug.ui.RdtDebugUiMessages;
import org.rubypeople.rdt.internal.ui.rubyeditor.ExternalRubyFileEditorInput;
import org.rubypeople.rdt.launching.IRubyLaunchConfigurationConstants;

public class RubySourceLocator
implements IPersistableSourceLocator,
ISourcePresentation {
    private String absoluteWorkingDirectory;
    private String projectName;

    public String getAbsoluteWorkingDirectory() {
        return this.absoluteWorkingDirectory;
    }

    public String getMemento() throws CoreException {
        return null;
    }

    public void initializeFromMemento(String memento) throws CoreException {
    }

    public void initializeDefaults(ILaunchConfiguration configuration) throws CoreException {
        this.absoluteWorkingDirectory = configuration.getAttribute(IRubyLaunchConfigurationConstants.ATTR_WORKING_DIRECTORY, "");
        this.projectName = configuration.getAttribute(IRubyLaunchConfigurationConstants.ATTR_PROJECT_NAME, "");
    }

    public Object getSourceElement(IStackFrame stackFrame) {
        return this.getSourceElement(((IRubyStackFrame)stackFrame).getFileName());
    }

    public Object getSourceElement(String pFilename) {
        return new SourceElement(pFilename, this);
    }

    public String getEditorId(IEditorInput input, Object element) {
        SourceElement sourceElement = (SourceElement)element;
        try {
            IEditorDescriptor desc = IDE.getEditorDescriptor((String)sourceElement.getFilename());
            return desc.getId();
        }
        catch (PartInitException partInitException) {
            return sourceElement.isExternal() ? "org.rubypeople.rdt.ui.ExternalRubyEditor" : "org.rubypeople.rdt.ui.EditorRubyFile";
        }
    }

    public IEditorInput getEditorInput(Object element) {
        SourceElement sourceElement = (SourceElement)element;
        if (!sourceElement.isExternal()) {
            return new FileEditorInput(sourceElement.getWorkspaceFile());
        }
        File filesystemFile = new File(sourceElement.getFilename());
        if (filesystemFile.exists()) {
            return new ExternalRubyFileEditorInput(filesystemFile);
        }
        RdtDebugCorePlugin.log((int)1, (String)RdtDebugUiMessages.getFormattedString(RdtDebugUiMessages.RdtDebugUiPlugin_couldNotOpenFile, sourceElement.getFilename()));
        return null;
    }

    public class SourceElement {
        private String filename;
        private IFile workspaceFile;
        private RubySourceLocator sourceLocator;

        public SourceElement(String aFilename, RubySourceLocator pSourceLocator) {
            this.filename = aFilename;
            this.sourceLocator = pSourceLocator;
            this.init();
        }

        private void init() {
            this.setFileName();
            this.grabWorkspaceFile();
        }

        private void setFileName() {
            IProject project;
            String relativeToProject;
            File file;
            String relativeToWorkingDir;
            File file2;
            if (this.filename == null) {
                return;
            }
            if (this.filename.startsWith("./")) {
                this.filename = this.filename.substring(2);
            }
            if (this.sourceLocator.getAbsoluteWorkingDirectory() != null && this.sourceLocator.getAbsoluteWorkingDirectory().trim().length() > 0 && (file2 = new File(relativeToWorkingDir = String.valueOf(this.sourceLocator.getAbsoluteWorkingDirectory()) + "/" + this.filename)).exists() && !file2.isDirectory()) {
                this.filename = relativeToWorkingDir;
                return;
            }
            if (RubySourceLocator.this.projectName != null && RubySourceLocator.this.projectName.trim().length() > 0 && (file = new File(relativeToProject = String.valueOf((project = this.getProject()).getLocation().toOSString()) + this.filename.substring(1))).exists() && !file.isDirectory()) {
                this.filename = relativeToProject;
                return;
            }
        }

        private IProject getProject() {
            if (RubySourceLocator.this.projectName == null) {
                return null;
            }
            return RdtDebugCorePlugin.getWorkspace().getRoot().getProject(RubySourceLocator.this.projectName);
        }

        private void grabWorkspaceFile() {
            if (this.filename == null) {
                return;
            }
            this.workspaceFile = RdtDebugCorePlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(this.filename));
            if (this.workspaceFile != null && this.workspaceFile.exists()) {
                return;
            }
            try {
                this.workspaceFile = RdtDebugCorePlugin.getWorkspace().getRoot().getFile((IPath)new Path(this.filename));
                if (this.workspaceFile != null && this.workspaceFile.exists()) {
                    return;
                }
            }
            catch (RuntimeException runtimeException) {
                this.workspaceFile = null;
            }
            if (this.getProject() != null) {
                this.workspaceFile = this.getProject().getFile((IPath)new Path(this.filename));
            }
        }

        public boolean isExternal() {
            return this.workspaceFile == null || !this.workspaceFile.exists();
        }

        public IFile getWorkspaceFile() {
            return this.workspaceFile;
        }

        public String getFilename() {
            return this.filename;
        }
    }
}

