/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.debug.ui;

import java.util.Hashtable;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.debug.ui.IEvaluationContextManager;
import org.rubypeople.rdt.debug.ui.RdtDebugUiConstants;
import org.rubypeople.rdt.internal.debug.core.model.RubyVariable;
import org.rubypeople.rdt.internal.debug.ui.ActionFilterAdapterFactory;
import org.rubypeople.rdt.internal.debug.ui.CodeReloader;
import org.rubypeople.rdt.internal.debug.ui.EvaluationContextManager;
import org.rubypeople.rdt.internal.debug.ui.RdtDebugUiMessages;
import org.rubypeople.rdt.internal.debug.ui.evaluation.EvaluationExpressionModel;
import org.rubypeople.rdt.ui.PreferenceConstants;
import org.rubypeople.rdt.ui.text.RubyTextTools;
import org.rubypeople.rdt.ui.viewsupport.ImageDescriptorRegistry;

public class RdtDebugUiPlugin
extends AbstractUIPlugin
implements RdtDebugUiConstants {
    public static final String PLUGIN_ID = "org.rubypeople.rdt.debug.ui";
    protected static RdtDebugUiPlugin plugin;
    private EvaluationExpressionModel evaluationExpressionModel;
    private ImageDescriptorRegistry fImageDescriptorRegistry;
    private RubyTextTools fTextTools;
    private static Hashtable<String, Image> images;
    private static IEvaluationContextManager manager;

    static {
        images = new Hashtable();
    }

    public RdtDebugUiPlugin() {
        plugin = this;
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return RdtDebugUiPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
    }

    public static IWorkbenchPage getActivePage() {
        IWorkbenchWindow w = RdtDebugUiPlugin.getActiveWorkbenchWindow();
        if (w != null) {
            return w.getActivePage();
        }
        return null;
    }

    public static RdtDebugUiPlugin getDefault() {
        return plugin;
    }

    public static IWorkspace getWorkspace() {
        return RubyCore.getWorkspace();
    }

    public static void log(IStatus status) {
        RdtDebugUiPlugin.getDefault().getLog().log(status);
    }

    public static void log(Throwable e) {
        RdtDebugUiPlugin.log((IStatus)new Status(4, PLUGIN_ID, 4, RdtDebugUiMessages.RdtDebugUiPlugin_internalErrorOccurred, e));
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public static Image getImage(String path) {
        if (images.get(path) == null) {
            ImageDescriptor id = RdtDebugUiPlugin.getImageDescriptor(path);
            if (id == null) {
                return null;
            }
            Image i = id.createImage();
            images.put(path, i);
            return i;
        }
        return images.get(path);
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        IAdapterManager manager = Platform.getAdapterManager();
        ActionFilterAdapterFactory actionFilterAdapterFactory = new ActionFilterAdapterFactory();
        manager.registerAdapters((IAdapterFactory)actionFilterAdapterFactory, RubyVariable.class);
        new CodeReloader();
        Job job = new Job("Startup evaluation context manager"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    IEvaluationContextManager manager = RdtDebugUiPlugin.getEvaluationContextManager();
                    if (manager != null) {
                        manager.startup();
                    }
                }
                catch (Throwable e) {
                    RdtDebugUiPlugin.log(e);
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule(2000L);
    }

    public static IEvaluationContextManager getEvaluationContextManager() {
        if (manager == null) {
            IExtensionPoint extension = Platform.getExtensionRegistry().getExtensionPoint(PLUGIN_ID, "evaluationContextManagers");
            if (extension == null) {
                return EvaluationContextManager.instance();
            }
            IExtension[] extensions = extension.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < configElements.length) {
                    IConfigurationElement configElement = configElements[j];
                    String elementName = configElement.getName();
                    if ("evaluationContextManager".equals(elementName)) {
                        try {
                            manager = (IEvaluationContextManager)configElement.createExecutableExtension("class");
                            if (manager != null) {
                                return manager;
                            }
                        }
                        catch (Exception e) {
                            RdtDebugUiPlugin.log(e);
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }
        return manager;
    }

    public void stop(BundleContext context) throws Exception {
        try {
            if (this.fImageDescriptorRegistry != null) {
                this.fImageDescriptorRegistry.dispose();
            }
        }
        finally {
            super.stop(context);
        }
    }

    public EvaluationExpressionModel getEvaluationExpressionModel() {
        if (this.evaluationExpressionModel == null) {
            this.evaluationExpressionModel = new EvaluationExpressionModel();
        }
        return this.evaluationExpressionModel;
    }

    public static String getUniqueIdentifier() {
        return PLUGIN_ID;
    }

    public static Display getStandardDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    public static ImageDescriptorRegistry getImageDescriptorRegistry() {
        if (RdtDebugUiPlugin.getDefault().fImageDescriptorRegistry == null) {
            RdtDebugUiPlugin.getDefault().fImageDescriptorRegistry = new ImageDescriptorRegistry();
        }
        return RdtDebugUiPlugin.getDefault().fImageDescriptorRegistry;
    }

    public RubyTextTools getRubyTextTools() {
        if (this.fTextTools == null) {
            this.fTextTools = new RubyTextTools(PreferenceConstants.getPreferenceStore());
        }
        return this.fTextTools;
    }

    public static Shell getActiveWorkbenchShell() {
        IWorkbenchWindow window = RdtDebugUiPlugin.getActiveWorkbenchWindow();
        if (window != null) {
            return window.getShell();
        }
        return null;
    }

    public static void errorDialog(String message, IStatus status) {
        RdtDebugUiPlugin.log(status);
        Shell shell = RdtDebugUiPlugin.getActiveWorkbenchShell();
        if (shell != null) {
            ErrorDialog.openError((Shell)shell, (String)"Error", (String)message, (IStatus)status);
        }
    }

    public static void errorDialog(String message, Throwable t) {
        RdtDebugUiPlugin.log(t);
        Shell shell = RdtDebugUiPlugin.getActiveWorkbenchShell();
        if (shell != null) {
            Status status = new Status(4, RdtDebugUiPlugin.getUniqueIdentifier(), 0, "Error logged from RDT Debug UI: ", t);
            ErrorDialog.openError((Shell)shell, (String)"Error", (String)message, (IStatus)status);
        }
    }

    public static void statusDialog(String title, IStatus status) {
        Shell shell = RdtDebugUiPlugin.getActiveWorkbenchShell();
        if (shell != null) {
            switch (status.getSeverity()) {
                case 4: {
                    ErrorDialog.openError((Shell)shell, (String)title, null, (IStatus)status);
                    break;
                }
                case 2: {
                    MessageDialog.openWarning((Shell)shell, (String)title, (String)status.getMessage());
                    break;
                }
                case 1: {
                    MessageDialog.openInformation((Shell)shell, (String)title, (String)status.getMessage());
                }
            }
        }
    }
}

