/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.debug.ui;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.rubypeople.rdt.internal.debug.core.model.IRubyDebugTarget;
import org.rubypeople.rdt.internal.debug.ui.CodeReloadJob;
import org.rubypeople.rdt.internal.debug.ui.RdtDebugUiPlugin;
import org.rubypeople.rdt.internal.ui.rubyeditor.RubyEditor;
import org.rubypeople.rdt.launching.IRubyLaunchConfigurationConstants;

public class CodeReloader
implements IPartListener,
IPropertyListener,
IWindowListener {
    public void windowActivated(IWorkbenchWindow window) {
    }

    public void windowClosed(IWorkbenchWindow window) {
        window.getPartService().removePartListener((IPartListener)this);
    }

    public void windowDeactivated(IWorkbenchWindow window) {
    }

    public void windowOpened(IWorkbenchWindow window) {
        window.getPartService().addPartListener((IPartListener)this);
    }

    public void partActivated(IWorkbenchPart part) {
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
        if (part instanceof RubyEditor) {
            part.removePropertyListener((IPropertyListener)this);
        }
    }

    public void partOpened(IWorkbenchPart part) {
        this.addAsListener(part);
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void propertyChanged(Object source, int propId) {
        if (!(source instanceof IEditorPart)) {
            return;
        }
        if (propId != 257) {
            return;
        }
        RubyEditor editor = (RubyEditor)source;
        if (editor.isDirty()) {
            return;
        }
        ILaunch[] launches = DebugPlugin.getDefault().getLaunchManager().getLaunches();
        int i = 0;
        while (i < launches.length) {
            try {
                IResource resource;
                IRubyDebugTarget target;
                ILaunch launch = launches[i];
                if (launch.getLaunchMode().equals("debug") && launch.getLaunchConfiguration().getType().getIdentifier().equals(IRubyLaunchConfigurationConstants.ID_RUBY_APPLICATION) && !(target = (IRubyDebugTarget)launch.getDebugTarget()).isTerminated() && !target.isDisconnected() && (resource = (IResource)editor.getEditorInput().getAdapter(IResource.class)) != null) {
                    CodeReloadJob job = new CodeReloadJob(target, resource.getLocation().toOSString());
                    job.schedule();
                }
            }
            catch (CoreException e) {
                RdtDebugUiPlugin.log((IStatus)new Status(4, "org.rubypeople.rdt.debug.ui", 0, "Error while trying to reload file.", (Throwable)e));
            }
            ++i;
        }
    }

    public void addAsListener(IWorkbenchPart part) {
        if (part == null || !(part instanceof RubyEditor)) {
            return;
        }
        part.addPropertyListener((IPropertyListener)this);
    }

    public CodeReloader() {
        RdtDebugUiPlugin.getDefault().getWorkbench().addWindowListener((IWindowListener)this);
        IWorkbenchWindow[] windows = RdtDebugUiPlugin.getDefault().getWorkbench().getWorkbenchWindows();
        int i = 0;
        while (i < windows.length) {
            IWorkbenchWindow window = windows[i];
            window.getPartService().addPartListener((IPartListener)this);
            ++i;
        }
        DebugUIPlugin.getStandardDisplay().syncExec(new Runnable(){

            public void run() {
                IWorkbenchWindow activeWindow = RdtDebugUiPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
                if (activeWindow == null) {
                    return;
                }
                IWorkbenchPage page = activeWindow.getActivePage();
                if (page == null) {
                    return;
                }
                CodeReloader.this.addAsListener(page.getActivePart());
            }
        });
    }
}

