/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.debug.ui.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.texteditor.AbstractMarkerAnnotationModel;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.IUpdate;
import org.rubypeople.rdt.debug.core.RubyLineBreakpoint;
import org.rubypeople.rdt.internal.debug.ui.RdtDebugUiPlugin;
import org.rubypeople.rdt.internal.ui.rubyeditor.ExternalFileRubyAnnotationModel;
import org.rubypeople.rdt.internal.ui.rubyeditor.IRubyScriptEditorInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManageBreakpointRulerAction
extends Action
implements IUpdate {
    private IVerticalRulerInfo fRuler;
    private ITextEditor fTextEditor;
    private List<IBreakpoint> fMarkers;
    private String fAddLabel;
    private String fRemoveLabel;

    public ManageBreakpointRulerAction(IVerticalRulerInfo ruler, ITextEditor editor) {
        this.fRuler = ruler;
        this.fTextEditor = editor;
        this.fAddLabel = "Add Breakpoint";
        this.fRemoveLabel = "Remove Breakpoint";
    }

    public void update() {
        this.fMarkers = this.getBreakpoints();
        this.setText(this.fMarkers.isEmpty() ? this.fAddLabel : this.fRemoveLabel);
    }

    public void run() {
        if (this.fMarkers.isEmpty()) {
            this.addMarker();
        } else {
            this.removeMarkers(this.fMarkers);
        }
    }

    protected List<IBreakpoint> getBreakpoints() {
        ArrayList<IBreakpoint> breakpoints = new ArrayList<IBreakpoint>();
        AbstractMarkerAnnotationModel model = this.getAnnotationModel();
        if (model == null) {
            return breakpoints;
        }
        try {
            IResource resource = this.getResource();
            if (resource == null) {
                resource = ResourcesPlugin.getWorkspace().getRoot();
            }
            if (resource == null) {
                return breakpoints;
            }
            IMarker[] markers = resource.findMarkers(IBreakpoint.BREAKPOINT_MARKER, true, 2);
            if (markers.length < 1) {
                return breakpoints;
            }
            IBreakpointManager breakpointManager = DebugPlugin.getDefault().getBreakpointManager();
            IDocument document = this.getDocument();
            int i = 0;
            while (i < markers.length) {
                IBreakpoint breakpoint = breakpointManager.getBreakpoint(markers[i]);
                if (breakpoint != null && breakpointManager.isRegistered(breakpoint) && this.includesRulerLine(model, markers[i], document)) {
                    breakpoints.add(breakpoint);
                }
                ++i;
            }
        }
        catch (CoreException x) {
            RdtDebugUiPlugin.log(x.getStatus());
        }
        return breakpoints;
    }

    protected IResource getResource() {
        IEditorInput input = this.fTextEditor.getEditorInput();
        IResource resource = (IResource)input.getAdapter(IFile.class);
        if (resource == null) {
            resource = (IResource)input.getAdapter(IResource.class);
        }
        return resource;
    }

    protected boolean includesRulerLine(AbstractMarkerAnnotationModel model, IMarker marker, IDocument document) {
        if (model instanceof ExternalFileRubyAnnotationModel) {
            Integer lineNum;
            block10: {
                lineNum = (Integer)marker.getAttribute("lineNumber");
                if (lineNum != null) break block10;
                return false;
            }
            try {
                int line = this.fRuler.getLineOfLastMouseButtonActivity();
                if (line == lineNum - 1) {
                    return true;
                }
            }
            catch (CoreException e) {
                RdtDebugUiPlugin.log(e);
            }
        } else {
            Position position = model.getMarkerPosition(marker);
            if (position != null) {
                try {
                    int markerLine = document.getLineOfOffset(position.getOffset());
                    int line = this.fRuler.getLineOfLastMouseButtonActivity();
                    if (line == markerLine) {
                        return true;
                    }
                }
                catch (BadLocationException badLocationException) {}
            }
        }
        return false;
    }

    protected IVerticalRulerInfo getVerticalRulerInfo() {
        return this.fRuler;
    }

    protected ITextEditor getTextEditor() {
        return this.fTextEditor;
    }

    protected AbstractMarkerAnnotationModel getAnnotationModel() {
        IDocumentProvider provider = this.fTextEditor.getDocumentProvider();
        IAnnotationModel model = provider.getAnnotationModel((Object)this.fTextEditor.getEditorInput());
        if (model instanceof AbstractMarkerAnnotationModel) {
            return (AbstractMarkerAnnotationModel)model;
        }
        return null;
    }

    protected IDocument getDocument() {
        IDocumentProvider provider = this.fTextEditor.getDocumentProvider();
        return provider.getDocument((Object)this.fTextEditor.getEditorInput());
    }

    protected void addMarker() {
        IEditorInput editorInput = this.getTextEditor().getEditorInput();
        this.getDocument();
        int rulerLine = this.getVerticalRulerInfo().getLineOfLastMouseButtonActivity();
        try {
            IResource resource = this.getResource(editorInput);
            if (resource.equals((Object)ResourcesPlugin.getWorkspace().getRoot())) {
                new RubyLineBreakpoint(resource, rulerLine, this.getFileName(editorInput));
            } else {
                new RubyLineBreakpoint(resource, rulerLine);
            }
        }
        catch (CoreException x) {
            System.out.println(x.getMessage());
        }
    }

    private String getFileName(IEditorInput editorInput) {
        if (editorInput instanceof IRubyScriptEditorInput) {
            return ((IRubyScriptEditorInput)editorInput).getRubyScript().getPath().makeAbsolute().toOSString();
        }
        return null;
    }

    private IResource getResource(IEditorInput editorInput) {
        if (editorInput instanceof IFileEditorInput) {
            return ((IFileEditorInput)editorInput).getFile();
        }
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    protected void removeMarkers(List<IBreakpoint> markers) {
        for (IBreakpoint breakpoint : this.fMarkers) {
            try {
                DebugPlugin.getDefault().getBreakpointManager().removeBreakpoint(breakpoint, true);
                return;
            }
            catch (CoreException coreException) {}
        }
    }
}

