/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.debug.ui;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.internal.debug.ui.RdtDebugUiMessages;
import org.rubypeople.rdt.internal.debug.ui.RdtDebugUiPlugin;
import org.rubypeople.rdt.launching.IVMInstall;
import org.rubypeople.rdt.launching.RubyRuntime;

public class InstallDeveloperToolsDialog
extends Dialog {
    public InstallDeveloperToolsDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(InstallDeveloperToolsDialog.getDefaultOrientation() | 0x10 | 0x10000 | 0x860);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(RdtDebugUiMessages.ToolChainNotFound_title);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite control = new Composite(composite, 0);
        GridLayout layout = new GridLayout(1, false);
        control.setLayout((Layout)layout);
        control.setLayoutData((Object)new GridData(4, 4, true, true));
        if (Platform.getOS().equals("macosx")) {
            this.createMacDialog(control);
        } else {
            this.createLinuxDialog(control);
        }
        GridData data = new GridData(4, 4, true, true);
        control.setLayoutData((Object)data);
        return composite;
    }

    private void createLinuxDialog(Composite parent) {
        Label label = new Label(parent, 16448);
        label.setText(RdtDebugUiMessages.ToolChainNotFound_msg);
        GridData data = new GridData(4, 4, true, false);
        data.widthHint = 300;
        label.setLayoutData((Object)data);
    }

    private void createMacDialog(Composite parent) {
        FontData[] fds;
        FontData[] fontDataArray = fds = parent.getFont().getFontData();
        int n = fds.length;
        int n2 = 0;
        while (n2 < n) {
            FontData fd = fontDataArray[n2];
            fd.setHeight(fd.getHeight() + 4);
            fd.setStyle(1);
            ++n2;
        }
        final Font font = new Font((Device)parent.getDisplay(), fds);
        FontData[] fontDataArray2 = fds = parent.getFont().getFontData();
        int n3 = fds.length;
        n = 0;
        while (n < n3) {
            FontData fd = fontDataArray2[n];
            fd.setHeight(fd.getHeight() + 2);
            fd.setStyle(1);
            ++n;
        }
        final Font font2 = new Font((Device)parent.getDisplay(), fds);
        Composite top = new Composite(parent, 0);
        top.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (font != null && !font.isDisposed()) {
                    font.dispose();
                }
                if (font2 != null && !font2.isDisposed()) {
                    font2.dispose();
                }
            }
        });
        GridLayout tLayout = new GridLayout(2, false);
        tLayout.marginHeight = 0;
        tLayout.marginWidth = 0;
        tLayout.marginBottom = 10;
        top.setLayout((Layout)tLayout);
        top.setLayoutData((Object)new GridData(4, 4, true, false));
        GridData iconData = new GridData(4, 128, true, false);
        iconData.verticalIndent = 5;
        Label icon = new Label(top, 16384);
        icon.setImage(RdtDebugUiPlugin.getImage("images/radrails32.png"));
        icon.setLayoutData((Object)iconData);
        Composite rightTop = new Composite(top, 0);
        GridLayout rtLayout = new GridLayout(1, false);
        rtLayout.marginHeight = 0;
        rtLayout.marginWidth = 0;
        rightTop.setLayout((Layout)rtLayout);
        Label title = new Label(rightTop, 16384);
        title.setFont(font);
        title.setText("Welcome to the Mac OS X version of RadRails!");
        title.setLayoutData((Object)new GridData(4, 128, true, false));
        Label line1 = new Label(rightTop, 16384);
        line1.setText("Rails for the Mac requires the Mac OS X developer tools be installed.");
        Label line2 = new Label(rightTop, 16384);
        line2.setText("These tools came with your Mac but are not yet installed.");
        Label installDiskLabel = new Label(parent, 16384);
        installDiskLabel.setImage(RdtDebugUiPlugin.getImage("images/osx_disc.png"));
        installDiskLabel.setLayoutData((Object)new GridData(0x1000000, 0x1000008, true, false));
        GridData oData = new GridData(4, 4, true, false);
        oData.horizontalIndent = 10;
        Label optionA = new Label(parent, 16384);
        optionA.setLayoutData((Object)oData);
        optionA.setFont(font2);
        optionA.setText("Please insert your OS X installation disk");
        GridData iData = new GridData(4, 4, true, false);
        iData.horizontalIndent = 25;
        Label instructionA = new Label(parent, 16384);
        instructionA.setLayoutData((Object)iData);
        instructionA.setText("1) Find the Xcode Tools directory.\n2) Double-click the XcodeTools.mpkg file to begin installation.\n3) Once Xcode is installed, please restart RadRails.\n");
        Label optionB = new Label(parent, 16384);
        GridData oData2 = new GridData(4, 4, true, false);
        oData2.horizontalIndent = 10;
        oData2.verticalIndent = 10;
        optionB.setFont(font2);
        optionB.setLayoutData((Object)oData2);
        optionB.setText("No installation disk?");
        Link instructionsB = new Link(parent, 16384);
        instructionsB.setText("1) Go to <a>http://developer.apple.com/tools/download/</a>\n2) Download Xcode\n3) Install from the downloaded DMG file.\n4) Once Xcode is installed, please restart RadRails.");
        instructionsB.setLayoutData((Object)iData);
        instructionsB.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    IWorkbenchBrowserSupport support = PlatformUI.getWorkbench().getBrowserSupport();
                    if (support != null) {
                        support.createBrowser(null).openURL(new URL("http://developer.apple.com/tools/download/"));
                    }
                }
                catch (PartInitException e1) {
                    RdtDebugUiPlugin.log(e1);
                }
                catch (MalformedURLException e1) {
                    RdtDebugUiPlugin.log(e1);
                }
            }
        });
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }

    private static boolean osAndVMNeedCompiling() {
        if (RubyRuntime.currentVMIsCygwin()) {
            return true;
        }
        if (RubyRuntime.currentVMIsJRuby()) {
            return false;
        }
        return !Platform.getOS().equals("win32");
    }

    private static boolean hasMake() {
        IPath path;
        if (RubyRuntime.currentVMIsCygwin()) {
            IVMInstall install = RubyRuntime.getDefaultVMInstall();
            File location = install.getInstallLocation();
            String[] binDirs = new String[]{"bin", "usr/sbin", "usr/bin"};
            int i = 0;
            while (i < binDirs.length) {
                File exe = new File(String.valueOf(location.getAbsolutePath()) + File.separator + binDirs[i] + File.separator + "make.exe");
                if (exe.exists() && exe.isFile()) {
                    return true;
                }
                ++i;
            }
        }
        if ((path = RubyCore.checkSystemPath((String)"make")) != null && path.toFile().exists()) {
            return true;
        }
        path = RubyCore.checkCommonBinLocations((String)"make");
        return path != null && path.toFile().exists();
    }

    public static boolean shouldShow() {
        return InstallDeveloperToolsDialog.osAndVMNeedCompiling() && !InstallDeveloperToolsDialog.hasMake();
    }
}

