/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.yml;

import com.aptana.ide.editor.yml.YMLErrorManager;
import com.aptana.ide.editors.unified.BaseFileLanguageService;
import com.aptana.ide.editors.unified.FileService;
import com.aptana.ide.editors.unified.IFileLanguageService;
import com.aptana.ide.editors.unified.IFileServiceFactory;
import com.aptana.ide.editors.unified.IFileSourceProvider;
import com.aptana.ide.editors.unified.IParentOffsetMapper;
import com.aptana.ide.editors.unified.LanguageRegistry;
import com.aptana.ide.editors.unified.ParentOffsetMapper;
import com.aptana.ide.editors.unified.errors.IErrorManager;
import com.aptana.ide.parsing.IParseState;
import com.aptana.ide.parsing.IParser;

public class YMLFileServiceFactory
implements IFileServiceFactory {
    private static YMLFileServiceFactory instance;
    private IParser _parser = LanguageRegistry.getParser((String)"text/yaml");

    public static IFileServiceFactory getInstance() {
        if (instance == null) {
            instance = new YMLFileServiceFactory();
        }
        return instance;
    }

    public FileService createFileService(IFileSourceProvider sourceProvider) {
        return this.createFileService(sourceProvider, true);
    }

    public FileService createFileService(IFileSourceProvider sourceProvider, boolean parse) {
        IParseState parseState = this._parser.createParseState(null);
        FileService fileService = new FileService(this._parser, parseState, sourceProvider, "text/yaml");
        fileService.setErrorManager((IErrorManager)new YMLErrorManager(fileService));
        ParentOffsetMapper parentMapper = new ParentOffsetMapper(fileService);
        BaseFileLanguageService languageService = new BaseFileLanguageService(fileService, parseState, this._parser, (IParentOffsetMapper)parentMapper);
        fileService.addLanguageService("text/yaml", (IFileLanguageService)languageService);
        if (parse) {
            fileService.doFullParse();
        }
        return fileService;
    }
}

