/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ti.util;

import org.jruby.ast.Node;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.evaluator.Instruction;
import org.rubypeople.rdt.internal.ti.util.INodeAcceptor;
import org.rubypeople.rdt.internal.ti.util.NodeLocator;

public class ClosestSpanningNodeLocator
extends NodeLocator {
    private static ClosestSpanningNodeLocator staticInstance = new ClosestSpanningNodeLocator();
    private int offset;
    private INodeAcceptor acceptor;
    private Node locatedNode;

    private ClosestSpanningNodeLocator() {
    }

    public static ClosestSpanningNodeLocator Instance() {
        return staticInstance;
    }

    public Node findClosestSpanner(Node rootNode, int offset, INodeAcceptor acceptor) {
        this.locatedNode = null;
        this.offset = offset;
        this.acceptor = acceptor;
        rootNode.accept((NodeVisitor)this);
        return this.locatedNode;
    }

    public Instruction handleNode(Node iVisited) {
        boolean nodeSpansMoreCloselyThanCurrent;
        boolean nodeSpansOffset = ClosestSpanningNodeLocator.nodeSpansOffset(iVisited, this.offset);
        boolean bl = nodeSpansMoreCloselyThanCurrent = this.locatedNode == null || this.calculateSpanLength(iVisited) <= this.calculateSpanLength(this.locatedNode);
        if (nodeSpansOffset && nodeSpansMoreCloselyThanCurrent && this.acceptor.doesAccept(iVisited)) {
            this.locatedNode = iVisited;
        }
        return super.handleNode(iVisited);
    }

    public static boolean nodeSpansOffset(Node node, int offset) {
        return node.getPosition().getStartOffset() <= offset && node.getPosition().getEndOffset() > offset;
    }

    private int calculateSpanLength(Node node) {
        if (node == null) {
            return 0;
        }
        if (node.getPosition() == null) {
            return 0;
        }
        return node.getPosition().getEndOffset() - node.getPosition().getStartOffset();
    }
}

