/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ti;

import org.jruby.ast.CallNode;
import org.jruby.ast.ClassNode;
import org.jruby.ast.ConstNode;
import org.jruby.ast.DefnNode;
import org.jruby.ast.DefsNode;
import org.jruby.ast.IterNode;
import org.jruby.ast.LocalAsgnNode;
import org.jruby.ast.LocalVarNode;
import org.jruby.ast.ModuleNode;
import org.jruby.ast.Node;
import org.jruby.evaluator.Instruction;
import org.rubypeople.rdt.internal.core.parser.InOrderVisitor;
import org.rubypeople.rdt.internal.ti.BasicTypeGuess;
import org.rubypeople.rdt.internal.ti.Scope;
import org.rubypeople.rdt.internal.ti.Variable;
import org.rubypeople.rdt.internal.ti.data.LiteralNodeTypeNames;
import org.rubypeople.rdt.internal.ti.data.TypicalMethodReturnNames;

public class TypeInferenceVisitor
extends InOrderVisitor {
    private Scope globalScope;
    private Scope currentScope;

    public TypeInferenceVisitor(Node rootNode) {
        this.currentScope = this.globalScope = new Scope(rootNode, null);
    }

    public Instruction visitModuleNode(ModuleNode iVisited) {
        Scope newScope = this.pushScope((Node)iVisited);
        Variable.insertLocalsFromScopeNode(iVisited.getScope(), newScope);
        return super.visitModuleNode(iVisited);
    }

    public Instruction visitClassNode(ClassNode iVisited) {
        Scope newScope = this.pushScope((Node)iVisited);
        Variable.insertLocalsFromScopeNode(iVisited.getScope(), newScope);
        return super.visitClassNode(iVisited);
    }

    public Instruction visitDefnNode(DefnNode iVisited) {
        Scope newScope = this.pushScope((Node)iVisited);
        Variable.insertLocalsFromScopeNode(iVisited.getScope(), newScope);
        return super.visitDefnNode(iVisited);
    }

    public Instruction visitDefsNode(DefsNode iVisited) {
        Scope newScope = this.pushScope((Node)iVisited);
        Variable.insertLocalsFromScopeNode(iVisited.getScope(), newScope);
        return super.visitDefsNode(iVisited);
    }

    public Instruction visitIterNode(IterNode iVisited) {
        this.pushScope((Node)iVisited);
        return super.visitIterNode(iVisited);
    }

    private Scope pushScope(Node node) {
        Scope newScope;
        this.currentScope = newScope = new Scope(node, this.currentScope);
        return newScope;
    }

    private void popScope() {
        this.currentScope = this.currentScope.getParentScope();
    }

    public Instruction visitCallNode(CallNode iVisited) {
        Variable var = this.getVariableByVarNode(iVisited.getReceiverNode());
        return super.visitCallNode(iVisited);
    }

    private Variable getVariableByVarNode(Node node) {
        if (node instanceof LocalVarNode) {
            LocalVarNode localVarNode = (LocalVarNode)node;
            return this.currentScope.getLocalVariableByCount(localVarNode.getIndex());
        }
        return null;
    }

    public Instruction visitLocalAsgnNode(LocalAsgnNode iVisited) {
        Variable var = this.currentScope.getLocalVariableByCount(iVisited.getIndex());
        if (var == null && this.currentScope == this.globalScope) {
            var = new Variable(this.globalScope, iVisited.getName(), iVisited.getIndex());
            this.currentScope.getVariables().add(var);
        }
        System.out.print("Associating a type to Variable " + var.getName() + ": ");
        Node valueNode = iVisited.getValueNode();
        String concreteGuess = LiteralNodeTypeNames.get(valueNode.getClass().getSimpleName());
        if (concreteGuess != null) {
            var.getTypeGuesses().add(new BasicTypeGuess(concreteGuess, 100));
        } else if (valueNode instanceof CallNode) {
            CallNode callValueNode = (CallNode)valueNode;
            String method = callValueNode.getName();
            if (method.equals("new") && callValueNode.getReceiverNode() instanceof ConstNode) {
                var.getTypeGuesses().add(new BasicTypeGuess(((ConstNode)callValueNode.getReceiverNode()).getName(), 100));
            } else {
                String methodReturnTypeGuess = TypicalMethodReturnNames.get(method);
                if (methodReturnTypeGuess != null) {
                    var.getTypeGuesses().add(new BasicTypeGuess(methodReturnTypeGuess, 100));
                }
            }
        }
        return super.visitLocalAsgnNode(iVisited);
    }

    private String stringifyNode(Node node) {
        return String.valueOf(node.getClass().getName()) + "@ :" + node.getPosition().getStartLine();
    }
}

