/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ti;

import org.jruby.ast.BlockNode;
import org.jruby.ast.CallNode;
import org.jruby.ast.ClassNode;
import org.jruby.ast.DefnNode;
import org.jruby.ast.DefsNode;
import org.jruby.ast.IterNode;
import org.jruby.ast.LocalAsgnNode;
import org.jruby.ast.ModuleNode;
import org.jruby.ast.NewlineNode;
import org.jruby.ast.Node;
import org.jruby.parser.StaticScope;
import org.rubypeople.rdt.internal.ti.Scope;
import org.rubypeople.rdt.internal.ti.Variable;

public class ScopingVisitor {
    protected Scope globalScope;
    protected Scope currentScope;

    public ScopingVisitor(Node root) {
        this.currentScope = this.globalScope = new Scope(root, null);
        if (this.isScopingNode(root)) {
            this.processNode(root);
        } else if (root instanceof BlockNode) {
            BlockNode blockRoot = (BlockNode)root;
            for (Object node : blockRoot.childNodes()) {
                if (!(node instanceof NewlineNode)) continue;
                NewlineNode newlineNode = (NewlineNode)node;
                this.processNode(newlineNode.getNextNode());
            }
        }
    }

    private void processNode(Node node) {
        if (node == null) {
            return;
        }
        if (this.isScopingNode(node)) {
            this.currentScope = new Scope(node, this.currentScope);
            this.visitScopingNode(node);
            for (Object child : node.childNodes()) {
                this.processNode((Node)child);
            }
            this.currentScope = this.currentScope.getParentScope();
        } else {
            this.visitNode(node);
        }
    }

    protected void visitScopingNode(Node node) {
        StaticScope bodyNode = null;
        if (node instanceof ModuleNode) {
            bodyNode = ((ModuleNode)node).getScope();
        }
        if (node instanceof ClassNode) {
            bodyNode = ((ClassNode)node).getScope();
        }
        if (node instanceof DefnNode) {
            bodyNode = ((DefnNode)node).getScope();
        }
        if (node instanceof DefsNode) {
            bodyNode = ((DefsNode)node).getScope();
        }
        if (node instanceof IterNode) {
            bodyNode = ((IterNode)node).getScope();
        }
        Variable.insertLocalsFromScopeNode(bodyNode, this.currentScope);
    }

    protected void visitNode(Node node) {
        System.out.print("ScopedVisitor :: ");
        if (node != null) {
            String pos = "";
            String cls = "";
            if (node.getPosition() != null) {
                pos = Integer.toString(node.getPosition().getStartLine());
            }
            if (node.getClass() != null) {
                cls = node.getClass().getName();
            }
            System.out.print("Visiting " + node.getClass().getSimpleName() + "\tat line " + pos + " of class " + cls);
            System.out.println("[ Spanning " + node.getPosition().getStartOffset() + "-" + node.getPosition().getEndOffset() + "]");
        }
        if (node instanceof CallNode) {
            this.visitCallNode((CallNode)node);
        }
        if (node instanceof LocalAsgnNode) {
            this.visitLocalAsgnNode((LocalAsgnNode)node);
        }
    }

    protected void visitCallNode(CallNode node) {
    }

    protected void visitLocalAsgnNode(LocalAsgnNode node) {
    }

    private boolean isScopingNode(Node node) {
        return node instanceof ModuleNode || node instanceof ClassNode || node instanceof DefnNode || node instanceof DefsNode || node instanceof IterNode;
    }
}

