/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ti;

import java.util.LinkedList;
import java.util.List;
import org.jruby.ast.ArgumentNode;
import org.jruby.ast.BlockNode;
import org.jruby.ast.ClassNode;
import org.jruby.ast.Colon2Node;
import org.jruby.ast.ConstNode;
import org.jruby.ast.DVarNode;
import org.jruby.ast.DefnNode;
import org.jruby.ast.DefsNode;
import org.jruby.ast.GlobalAsgnNode;
import org.jruby.ast.GlobalVarNode;
import org.jruby.ast.InstAsgnNode;
import org.jruby.ast.InstVarNode;
import org.jruby.ast.LocalAsgnNode;
import org.jruby.ast.LocalVarNode;
import org.jruby.ast.Node;
import org.jruby.ast.types.INameNode;
import org.jruby.common.IRubyWarnings;
import org.jruby.common.NullWarnings;
import org.jruby.lexer.yacc.IDESourcePosition;
import org.jruby.lexer.yacc.ISourcePosition;
import org.rubypeople.rdt.internal.core.parser.RubyParser;
import org.rubypeople.rdt.internal.ti.IReferenceFinder;
import org.rubypeople.rdt.internal.ti.util.FirstPrecursorNodeLocator;
import org.rubypeople.rdt.internal.ti.util.INodeAcceptor;
import org.rubypeople.rdt.internal.ti.util.OffsetNodeLocator;
import org.rubypeople.rdt.internal.ti.util.ScopedNodeLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultReferenceFinder
implements IReferenceFinder {
    private static final boolean VERBOSE = false;

    @Override
    public List<ISourcePosition> findReferences(String source, int offset) {
        LinkedList<ISourcePosition> references = new LinkedList<ISourcePosition>();
        RubyParser parser = new RubyParser((IRubyWarnings)new NullWarnings());
        Node root = parser.parse(source).getAST();
        Node orig = OffsetNodeLocator.Instance().getNodeAtOffset(root, offset);
        this.log("Origin: " + orig.getClass().getName());
        if (this.isLocalVarRef(orig)) {
            this.pushLocalVarRefs(root, orig, references);
        }
        if (this.isInstanceVarRef(orig)) {
            this.pushInstVarRefs(root, orig, references);
        }
        if (this.isGlobalVarRef(orig)) {
            this.pushGlobalVarRefs(root, orig, references);
        }
        if (orig instanceof ConstNode) {
            this.pushConstRefs(root, orig, references);
        }
        return references;
    }

    private ISourcePosition getPositionOfName(Node node, Node scope) {
        ISourcePosition pos = node.getPosition();
        String name = null;
        if (this.isLocalVarRef(node)) {
            name = this.getLocalVarRefName(node, scope);
        }
        if (this.isInstanceVarRef(node)) {
            name = this.getInstVarRefName(node, scope);
        }
        if (this.isGlobalVarRef(node)) {
            name = this.getGlobalVarRefName(node);
        }
        if (node instanceof ConstNode) {
            name = ((ConstNode)node).getName();
        }
        if (name == null) {
            System.err.println("Couldn't get the name for: " + node.toString() + " in " + scope.toString());
            name = "";
        }
        return new IDESourcePosition(pos.getFile(), pos.getStartLine(), pos.getEndLine(), pos.getStartOffset(), pos.getStartOffset() + name.length());
    }

    private String getLocalVarRefName(Node node, Node scope) {
        if (node instanceof INameNode) {
            return ((INameNode)node).getName();
        }
        return null;
    }

    private String getClassNodeName(ClassNode classNode) {
        if (classNode.getCPath() instanceof Colon2Node) {
            Colon2Node c2node = (Colon2Node)classNode.getCPath();
            return c2node.getName();
        }
        System.err.println("ClassNode.getCPath() returned other than Colon2Node: " + classNode.toString());
        return null;
    }

    private String getInstVarRefName(Node node, Node scope) {
        if (node instanceof InstAsgnNode) {
            return ((InstAsgnNode)node).getName();
        }
        if (node instanceof ArgumentNode) {
            return ((ArgumentNode)node).getName();
        }
        if (node instanceof InstVarNode) {
            return ((InstVarNode)node).getName();
        }
        if (node instanceof DVarNode) {
            return ((DVarNode)node).getName();
        }
        return null;
    }

    private String getGlobalVarRefName(Node node) {
        if (node instanceof GlobalVarNode) {
            return ((GlobalVarNode)node).getName();
        }
        if (node instanceof GlobalAsgnNode) {
            return ((GlobalAsgnNode)node).getName();
        }
        return null;
    }

    private boolean isLocalVarRef(Node node) {
        return node instanceof LocalAsgnNode || node instanceof ArgumentNode || node instanceof LocalVarNode;
    }

    private boolean isInstanceVarRef(Node node) {
        return node instanceof InstAsgnNode || node instanceof InstVarNode;
    }

    private boolean isGlobalVarRef(Node node) {
        return node instanceof GlobalAsgnNode || node instanceof GlobalVarNode;
    }

    private void pushLocalVarRefs(Node root, Node orig, List<ISourcePosition> references) {
        this.log("Finding references for a local variable " + orig.toString());
        Node searchSpace = FirstPrecursorNodeLocator.Instance().findFirstPrecursor(root, orig.getPosition().getStartOffset(), new INodeAcceptor(){

            public boolean doesAccept(Node node) {
                return node instanceof DefnNode || node instanceof DefsNode;
            }
        });
        if (searchSpace == null) {
            searchSpace = root;
        }
        final Node finalSearchSpace = searchSpace;
        final String origName = this.getLocalVarRefName(orig, searchSpace);
        List<Node> searchResults = ScopedNodeLocator.Instance().findNodesInScope(searchSpace, new INodeAcceptor(){

            public boolean doesAccept(Node node) {
                String name = DefaultReferenceFinder.this.getLocalVarRefName(node, finalSearchSpace);
                return name != null && name.equals(origName);
            }
        });
        for (Node searchResult : searchResults) {
            references.add(this.getPositionOfName(searchResult, searchSpace));
        }
    }

    private void log(String string) {
    }

    private void pushInstVarRefs(Node root, Node orig, List<ISourcePosition> references) {
        Node searchSpace;
        this.log("Finding references for an instance variable " + orig.toString());
        ClassNode enclosingClass = (ClassNode)FirstPrecursorNodeLocator.Instance().findFirstPrecursor(root, orig.getPosition().getStartOffset(), new INodeAcceptor(){

            public boolean doesAccept(Node node) {
                return node instanceof ClassNode;
            }
        });
        if (enclosingClass == null) {
            searchSpace = root;
        } else {
            final String className = this.getClassNodeName(enclosingClass);
            List<Node> classNodes = ScopedNodeLocator.Instance().findNodesInScope(root, new INodeAcceptor(){

                public boolean doesAccept(Node node) {
                    if (node instanceof ClassNode) {
                        return DefaultReferenceFinder.this.getClassNodeName((ClassNode)node).equals(className);
                    }
                    return false;
                }
            });
            BlockNode blockNode = new BlockNode((ISourcePosition)new IDESourcePosition());
            for (Node classNode : classNodes) {
                blockNode.add(classNode);
            }
            searchSpace = blockNode;
        }
        final Node finalSearchSpace = searchSpace;
        final String origName = this.getInstVarRefName(orig, searchSpace);
        List<Node> searchResults = ScopedNodeLocator.Instance().findNodesInScope(searchSpace, new INodeAcceptor(){

            public boolean doesAccept(Node node) {
                if (DefaultReferenceFinder.this.isInstanceVarRef(node)) {
                    String name = DefaultReferenceFinder.this.getInstVarRefName(node, finalSearchSpace);
                    return name != null && name.equals(origName);
                }
                return false;
            }
        });
        for (Node searchResult : searchResults) {
            references.add(this.getPositionOfName(searchResult, searchSpace));
        }
    }

    private void pushGlobalVarRefs(Node root, Node orig, List<ISourcePosition> references) {
        Node searchSpace = root;
        final String origName = this.getGlobalVarRefName(orig);
        List<Node> searchResults = ScopedNodeLocator.Instance().findNodesInScope(searchSpace, new INodeAcceptor(){

            public boolean doesAccept(Node node) {
                return DefaultReferenceFinder.this.isGlobalVarRef(node) && DefaultReferenceFinder.this.getGlobalVarRefName(node).equals(origName);
            }
        });
        for (Node searchResult : searchResults) {
            references.add(this.getPositionOfName(searchResult, searchSpace));
        }
    }

    private void pushConstRefs(Node root, Node orig, List<ISourcePosition> references) {
        if (!(orig instanceof ConstNode)) {
            return;
        }
        final String matchName = ((ConstNode)orig).getName();
        List<Node> searchResults = ScopedNodeLocator.Instance().findNodesInScope(root, new INodeAcceptor(){

            public boolean doesAccept(Node node) {
                if (node instanceof ConstNode) {
                    return ((ConstNode)node).getName().equals(matchName);
                }
                return false;
            }
        });
        for (Node searchResult : searchResults) {
            references.add(this.getPositionOfName(searchResult, root));
        }
    }
}

