/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ti;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.jruby.ast.CallNode;
import org.jruby.ast.ClassNode;
import org.jruby.ast.ClassVarAsgnNode;
import org.jruby.ast.ClassVarDeclNode;
import org.jruby.ast.ClassVarNode;
import org.jruby.ast.Colon2Node;
import org.jruby.ast.ConstNode;
import org.jruby.ast.DAsgnNode;
import org.jruby.ast.DVarNode;
import org.jruby.ast.DefnNode;
import org.jruby.ast.DefsNode;
import org.jruby.ast.FCallNode;
import org.jruby.ast.GlobalAsgnNode;
import org.jruby.ast.GlobalVarNode;
import org.jruby.ast.InstAsgnNode;
import org.jruby.ast.InstVarNode;
import org.jruby.ast.ListNode;
import org.jruby.ast.LocalAsgnNode;
import org.jruby.ast.LocalVarNode;
import org.jruby.ast.ModuleNode;
import org.jruby.ast.Node;
import org.jruby.ast.ReturnNode;
import org.jruby.ast.SelfNode;
import org.jruby.ast.VCallNode;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.core.parser.ReturnVisitor;
import org.rubypeople.rdt.internal.core.parser.RubyParser;
import org.rubypeople.rdt.internal.core.util.ASTUtil;
import org.rubypeople.rdt.internal.ti.BasicTypeGuess;
import org.rubypeople.rdt.internal.ti.ITypeGuess;
import org.rubypeople.rdt.internal.ti.ITypeInferrer;
import org.rubypeople.rdt.internal.ti.TypeInferenceHelper;
import org.rubypeople.rdt.internal.ti.data.LiteralNodeTypeNames;
import org.rubypeople.rdt.internal.ti.data.TypicalMethodReturnNames;
import org.rubypeople.rdt.internal.ti.util.ClosestSpanningNodeLocator;
import org.rubypeople.rdt.internal.ti.util.INodeAcceptor;
import org.rubypeople.rdt.internal.ti.util.MethodDefinitionLocator;
import org.rubypeople.rdt.internal.ti.util.MethodInvocationLocator;
import org.rubypeople.rdt.internal.ti.util.OffsetNodeLocator;
import org.rubypeople.rdt.internal.ti.util.ScopedNodeLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataFlowTypeInferrer
implements ITypeInferrer {
    private static final boolean VERBOSE = false;
    TypeInferenceHelper helper;
    private String source;
    private Node rootNode;
    private List<Node> inferNodeStack;

    private void sysout(String string) {
    }

    private void prettyPrint(Node node) {
        this.sysout("----------------------------------------\nNode: " + node.getClass().getSimpleName() + "\n" + "Source:\n[" + node.getPosition().getStartOffset() + ".." + node.getPosition().getEndOffset() + "]\n" + this.source.substring(node.getPosition().getStartOffset(), node.getPosition().getEndOffset()) + "\n" + "----------------------------------------");
    }

    public List<ITypeGuess> infer(String source, int offset) {
        if (source == null) {
            return Collections.emptyList();
        }
        this.rootNode = null;
        try {
            this.rootNode = new RubyParser().parse(source).getAST();
        }
        catch (Exception e) {
            RubyCore.log(e);
            return Collections.emptyList();
        }
        LinkedList<ITypeGuess> guesses = new LinkedList();
        this.helper = TypeInferenceHelper.Instance();
        this.source = source;
        this.inferNodeStack = new LinkedList<Node>();
        Node node = OffsetNodeLocator.Instance().getNodeAtOffset(this.rootNode, offset);
        if (node == null) {
            return null;
        }
        guesses = this.inferNodeType(node);
        guesses = this.redistributeGuessConfidences(guesses);
        guesses = this.combineSameGuesses(guesses);
        return guesses;
    }

    private List<ITypeGuess> combineSameGuesses(List<ITypeGuess> guesses) {
        HashMap<String, Integer> combined = new HashMap<String, Integer>();
        for (ITypeGuess typeGuess : guesses) {
            Integer percent = (Integer)combined.get(typeGuess.getType());
            if (percent == null) {
                combined.put(typeGuess.getType(), typeGuess.getConfidence());
                continue;
            }
            combined.put(typeGuess.getType(), percent + typeGuess.getConfidence());
        }
        ArrayList<ITypeGuess> combinedGuesses = new ArrayList<ITypeGuess>(combined.size());
        for (String type : combined.keySet()) {
            combinedGuesses.add(new BasicTypeGuess(type, (Integer)combined.get(type)));
        }
        return combinedGuesses;
    }

    private List<ITypeGuess> redistributeGuessConfidences(List<ITypeGuess> guesses) {
        int sum = 0;
        for (ITypeGuess guess : guesses) {
            sum += guess.getConfidence();
        }
        ArrayList<ITypeGuess> newGuesses = new ArrayList<ITypeGuess>(guesses.size());
        for (ITypeGuess guess : guesses) {
            BasicTypeGuess newGuess = new BasicTypeGuess(guess.getType(), (int)((double)guess.getConfidence() / (double)sum * 100.0));
            newGuesses.add(newGuess);
        }
        return newGuesses;
    }

    private List<ITypeGuess> inferNodeType(Node node) {
        if (node == null) {
            return Collections.emptyList();
        }
        this.sysout("Inferring node: " + node.getClass().getSimpleName());
        ArrayList<ITypeGuess> guesses = new ArrayList<ITypeGuess>(1);
        if (this.inferNodeStack.indexOf(node) != -1) {
            this.sysout("Data flow graph cycle detected:");
            this.prettyPrint(node);
            return guesses;
        }
        this.inferNodeStack.add(0, node);
        if (this.isSelfReferenceNode(node)) {
            guesses.add(this.getSelfReferenceNodeType(node));
        }
        if (this.isAssignmentNode(node)) {
            guesses.addAll(this.inferNodeType(this.getAssignmentNodeValueNode(node)));
        }
        if (this.isTypeDefinitionNode(node)) {
            guesses.add(this.getTypeDefinitionNodeType(node));
        }
        if (this.isConstantNode(node)) {
            guesses.add(this.getConstantNodeType(node));
        }
        if (node instanceof LocalVarNode) {
            guesses.addAll(this.getLocalVarReferenceNodeTypes((LocalVarNode)node));
        }
        if (node instanceof DVarNode) {
            guesses.addAll(this.getDVarReferenceNodeTypes((DVarNode)node));
        }
        if (node instanceof InstVarNode) {
            guesses.addAll(this.getInstanceVarReferenceNodeTypes((InstVarNode)node));
        }
        if (node instanceof ClassVarNode) {
            guesses.addAll(this.getClassVarReferenceNodeTypes((ClassVarNode)node));
        }
        if (node instanceof GlobalVarNode) {
            guesses.addAll(this.getGlobalVarReferenceNodeTypes((GlobalVarNode)node));
        }
        if (this.isCallNode(node)) {
            guesses.addAll(this.getCallNodeTypes(node));
        }
        this.inferNodeStack.remove(0);
        return guesses;
    }

    private boolean isConstantNode(Node node) {
        return node instanceof Colon2Node || node instanceof ConstNode || LiteralNodeTypeNames.get(node.getClass().getSimpleName()) != null;
    }

    private ITypeGuess getConstantNodeType(Node node) {
        if (node instanceof ConstNode) {
            return new BasicTypeGuess(((ConstNode)node).getName(), 100);
        }
        if (node instanceof Colon2Node) {
            String name = ASTUtil.getFullyQualifiedName((Colon2Node)node);
            return new BasicTypeGuess(name, 100);
        }
        return new BasicTypeGuess(LiteralNodeTypeNames.get(node.getClass().getSimpleName()), 100);
    }

    private boolean isTypeDefinitionNode(Node node) {
        return node instanceof ClassNode || node instanceof ModuleNode;
    }

    private ITypeGuess getTypeDefinitionNodeType(Node node) {
        String typeNodeName = this.helper.getTypeNodeName(node);
        if (typeNodeName != null) {
            return new BasicTypeGuess(typeNodeName, 100);
        }
        return null;
    }

    private boolean isSelfReferenceNode(Node node) {
        return node instanceof SelfNode;
    }

    private ITypeGuess getSelfReferenceNodeType(Node node) {
        Node enclosingTypeNode = this.findEnclosingTypeNode(node);
        return this.getTypeDefinitionNodeType(enclosingTypeNode);
    }

    private List<Node> findAllSendersOfMethod(String typeName, String methodName) {
        return MethodInvocationLocator.Instance().findMethodInvocations(this.rootNode, typeName, methodName, new DataFlowTypeInferrer());
    }

    private List<Node> findAllMethodDefinitions(String typeName, String methodName) {
        return MethodDefinitionLocator.Instance().findMethodDefinitions(this.rootNode, typeName, methodName);
    }

    private List<Node> findRetvalExprs(Node methodNode) {
        ReturnVisitor visitor = new ReturnVisitor();
        visitor.acceptNode(methodNode);
        List<Node> returnNodes = visitor.getReturnValues();
        ArrayList<Node> retvalExprs = new ArrayList<Node>(returnNodes.size());
        for (Node returnNode : returnNodes) {
            if (returnNode instanceof ReturnNode) {
                retvalExprs.add(((ReturnNode)returnNode).getValueNode());
                continue;
            }
            retvalExprs.add(returnNode);
        }
        this.sysout("Found " + retvalExprs.size() + " + retval exprs in method " + this.helper.getMethodDefinitionNodeName(methodNode));
        return retvalExprs;
    }

    private Node findEnclosingMethodNode(Node node) {
        Node enclosingScopeNode = ClosestSpanningNodeLocator.Instance().findClosestSpanner(this.rootNode, node.getPosition().getStartOffset(), new INodeAcceptor(){

            public boolean doesAccept(Node node) {
                return node instanceof DefnNode || node instanceof DefsNode;
            }
        });
        if (enclosingScopeNode == null) {
            enclosingScopeNode = this.rootNode;
        }
        return enclosingScopeNode;
    }

    private Node findEnclosingTypeNode(Node node) {
        Node enclosingTypeNode = ClosestSpanningNodeLocator.Instance().findClosestSpanner(this.rootNode, node.getPosition().getStartOffset(), new INodeAcceptor(){

            public boolean doesAccept(Node node) {
                return node instanceof ClassNode || node instanceof ModuleNode;
            }
        });
        if (enclosingTypeNode == null) {
            enclosingTypeNode = this.rootNode;
        }
        return enclosingTypeNode;
    }

    private List<ITypeGuess> getLocalVarReferenceNodeTypes(LocalVarNode node) {
        ArrayList<ITypeGuess> possibleTypes = new ArrayList<ITypeGuess>(1);
        Node enclosingScopeNode = this.findEnclosingMethodNode((Node)node);
        if (enclosingScopeNode == this.rootNode) {
            this.sysout("localvarnode outside a method!");
            enclosingScopeNode = this.findEnclosingTypeNode((Node)node);
        }
        final String localVarName = this.helper.getVarName((Node)node);
        List<Node> localAssignsIntoNode = ScopedNodeLocator.Instance().findNodesInScope(enclosingScopeNode, new INodeAcceptor(){

            public boolean doesAccept(Node acceptNode) {
                if (acceptNode instanceof LocalAsgnNode) {
                    return ((LocalAsgnNode)acceptNode).getName().equals(localVarName);
                }
                return false;
            }
        });
        if (localAssignsIntoNode != null && localAssignsIntoNode.size() > 0) {
            for (Node asgnNode : localAssignsIntoNode) {
                possibleTypes.addAll(this.inferNodeType(((LocalAsgnNode)asgnNode).getValueNode()));
            }
            return possibleTypes;
        }
        if (this.helper.isArgumentInMethod(localVarName, enclosingScopeNode)) {
            Node enclosingMethodNode = enclosingScopeNode;
            this.sysout("Is arg in method");
            Node enclosingTypeNode = this.findEnclosingTypeNode((Node)node);
            String enclosingTypeName = "Kernel";
            if (enclosingTypeNode != this.rootNode) {
                enclosingTypeName = this.helper.getTypeNodeName(enclosingTypeNode);
            }
            String enclosingMethodName = this.helper.getMethodDefinitionNodeName(enclosingMethodNode);
            this.sysout("Inferring type of argument " + localVarName + " in method " + enclosingMethodName);
            ListNode argsListNode = this.helper.getArgsListNode(enclosingMethodNode);
            int paramIndex = this.helper.getArgIndex(argsListNode, localVarName);
            List<Node> sendExprs = this.findAllSendersOfMethod(enclosingTypeName, enclosingMethodName);
            this.sysout("Found " + sendExprs.size() + " senders: ");
            ArrayList<Node> argExprs = new ArrayList<Node>(sendExprs.size());
            for (Node sendExpr : sendExprs) {
                this.prettyPrint(sendExpr);
                argExprs.add(this.helper.findNthArgExprInSendExpr(paramIndex, sendExpr));
            }
            this.sysout("Inflowing argexprs:" + argExprs.size());
            for (Node argExpr : argExprs) {
                this.prettyPrint(argExpr);
                possibleTypes.addAll(this.inferNodeType(argExpr));
            }
            return possibleTypes;
        }
        this.sysout("bottom");
        return possibleTypes;
    }

    private List<ITypeGuess> getDVarReferenceNodeTypes(DVarNode node) {
        ArrayList<ITypeGuess> possibleTypes = new ArrayList<ITypeGuess>(1);
        Node enclosingScopeNode = this.findEnclosingMethodNode((Node)node);
        if (enclosingScopeNode == this.rootNode) {
            enclosingScopeNode = this.findEnclosingTypeNode((Node)node);
        }
        final String varName = node.getName();
        List<Node> dynAsgnNodes = ScopedNodeLocator.Instance().findNodesInScope(enclosingScopeNode, new INodeAcceptor(){

            public boolean doesAccept(Node acceptNode) {
                if (acceptNode instanceof DAsgnNode) {
                    return ((DAsgnNode)acceptNode).getName().equals(varName);
                }
                return false;
            }
        });
        if (dynAsgnNodes != null) {
            for (Node dynAsgnNode : dynAsgnNodes) {
                possibleTypes.addAll(this.inferNodeType(((DAsgnNode)dynAsgnNode).getValueNode()));
            }
        }
        return possibleTypes;
    }

    private List<ITypeGuess> getInstanceVarReferenceNodeTypes(InstVarNode node) {
        ArrayList<ITypeGuess> possibleTypes = new ArrayList<ITypeGuess>(1);
        Node enclosingTypeNode = this.findEnclosingTypeNode((Node)node);
        final String instanceVarName = this.helper.getVarName((Node)node);
        List<Node> instAsgnNodes = ScopedNodeLocator.Instance().findNodesInScope(enclosingTypeNode, new INodeAcceptor(){

            public boolean doesAccept(Node acceptNode) {
                if (acceptNode instanceof InstAsgnNode) {
                    return ((InstAsgnNode)acceptNode).getName().equals(instanceVarName);
                }
                return false;
            }
        });
        if (instAsgnNodes != null) {
            for (Node instAsgnNode : instAsgnNodes) {
                possibleTypes.addAll(this.inferNodeType(((InstAsgnNode)instAsgnNode).getValueNode()));
            }
        }
        return possibleTypes;
    }

    private List<ITypeGuess> getClassVarReferenceNodeTypes(ClassVarNode node) {
        ArrayList<ITypeGuess> possibleTypes = new ArrayList<ITypeGuess>(1);
        Node enclosingTypeNode = this.findEnclosingTypeNode((Node)node);
        final String classVarName = this.helper.getVarName((Node)node);
        this.prettyPrint(enclosingTypeNode);
        List<Node> classAsgnNodes = ScopedNodeLocator.Instance().findNodesInScope(enclosingTypeNode, new INodeAcceptor(){

            public boolean doesAccept(Node acceptNode) {
                if (acceptNode instanceof ClassVarAsgnNode) {
                    return ((ClassVarAsgnNode)acceptNode).getName().equals(classVarName);
                }
                if (acceptNode instanceof ClassVarDeclNode) {
                    return ((ClassVarDeclNode)acceptNode).getName().equals(classVarName);
                }
                return false;
            }
        });
        if (classAsgnNodes != null) {
            this.sysout("asgns not null: " + classAsgnNodes.size());
            for (Node classAsgnNode : classAsgnNodes) {
                if (classAsgnNode instanceof ClassVarAsgnNode) {
                    possibleTypes.addAll(this.inferNodeType(((ClassVarAsgnNode)classAsgnNode).getValueNode()));
                }
                if (!(classAsgnNode instanceof ClassVarDeclNode)) continue;
                possibleTypes.addAll(this.inferNodeType(((ClassVarDeclNode)classAsgnNode).getValueNode()));
            }
        }
        return possibleTypes;
    }

    private List<ITypeGuess> getGlobalVarReferenceNodeTypes(GlobalVarNode node) {
        ArrayList<ITypeGuess> possibleTypes = new ArrayList<ITypeGuess>(1);
        final String globalVarName = this.helper.getVarName((Node)node);
        List<Node> globalAsgnNodes = ScopedNodeLocator.Instance().findNodesInScope(this.rootNode, new INodeAcceptor(){

            public boolean doesAccept(Node acceptNode) {
                if (acceptNode instanceof GlobalAsgnNode) {
                    return ((GlobalAsgnNode)acceptNode).getName().equals(globalVarName);
                }
                return false;
            }
        });
        for (Node globalAsgnNode : globalAsgnNodes) {
            possibleTypes.addAll(this.inferNodeType(((GlobalAsgnNode)globalAsgnNode).getValueNode()));
        }
        return possibleTypes;
    }

    private boolean isAssignmentNode(Node node) {
        return node instanceof LocalAsgnNode || node instanceof InstAsgnNode || node instanceof GlobalAsgnNode;
    }

    private Node getAssignmentNodeValueNode(Node node) {
        if (node instanceof InstAsgnNode) {
            return ((InstAsgnNode)node).getValueNode();
        }
        if (node instanceof LocalAsgnNode) {
            return ((LocalAsgnNode)node).getValueNode();
        }
        if (node instanceof GlobalAsgnNode) {
            return ((GlobalAsgnNode)node).getValueNode();
        }
        return null;
    }

    private boolean isCallNode(Node node) {
        return node instanceof CallNode || node instanceof FCallNode || node instanceof VCallNode;
    }

    private List<ITypeGuess> getCallNodeTypes(Node node) {
        String methodName = this.helper.getCallNodeMethodName(node);
        if (methodName.equals("new")) {
            return this.getInstantiationCallNodeTypes(node);
        }
        LinkedList<ITypeGuess> possibleTypes = new LinkedList<ITypeGuess>();
        String methodReturnTypeGuess = TypicalMethodReturnNames.get(methodName);
        if (methodReturnTypeGuess != null) {
            possibleTypes.add(new BasicTypeGuess(methodReturnTypeGuess, 100));
        }
        ArrayList<String> receiverTypes = new ArrayList<String>();
        if (node instanceof CallNode) {
            List<ITypeGuess> receiverTypeInferences = this.inferNodeType(((CallNode)node).getReceiverNode());
            if (receiverTypeInferences != null && receiverTypeInferences.size() > 0) {
                for (ITypeGuess typeGuess : receiverTypeInferences) {
                    if (typeGuess == null) continue;
                    receiverTypes.add(typeGuess.getType());
                }
            }
        } else if (node instanceof FCallNode || node instanceof VCallNode) {
            String receiverTypeName = this.helper.getTypeNodeName(this.findEnclosingTypeNode(node));
            if (receiverTypeName == null) {
                receiverTypeName = "Kernel";
            }
            receiverTypes.add(receiverTypeName);
        }
        ArrayList<Node> defnNodes = new ArrayList<Node>();
        for (String receiverType : receiverTypes) {
            List<Node> result = this.findAllMethodDefinitions(receiverType, methodName);
            defnNodes.addAll(result);
            this.sysout("Receiver type name: " + receiverType);
            this.sysout(" " + result.size() + " defnnodes found");
        }
        LinkedList<Node> retvalExprs = new LinkedList<Node>();
        for (Node defnNode : defnNodes) {
            retvalExprs.addAll(this.findRetvalExprs(defnNode));
        }
        for (Node retvalExpr : retvalExprs) {
            possibleTypes.addAll(this.inferNodeType(retvalExpr));
        }
        return possibleTypes;
    }

    private List<ITypeGuess> getInstantiationCallNodeTypes(Node node) {
        Node enclosingTypeNode;
        ArrayList<ITypeGuess> possibleTypes = new ArrayList<ITypeGuess>(1);
        if (node instanceof CallNode) {
            Node receiverNode = ((CallNode)node).getReceiverNode();
            return this.inferNodeType(receiverNode);
        }
        if (node instanceof FCallNode) {
            enclosingTypeNode = this.findEnclosingTypeNode(node);
            possibleTypes.add(this.getTypeDefinitionNodeType(enclosingTypeNode));
        }
        if (node instanceof VCallNode) {
            enclosingTypeNode = this.findEnclosingTypeNode(node);
            possibleTypes.add(this.getTypeDefinitionNodeType(enclosingTypeNode));
        }
        return possibleTypes;
    }
}

