/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.formatter;

import java.util.HashMap;
import java.util.Map;

public class DefaultCodeFormatterOptions {
    private static final int DEFAULT_INDENT_SIZE = 4;
    private static final int DEFAULT_TAB_SIZE = 4;
    public static final int TAB = 1;
    public static final int SPACE = 2;
    public static final int MIXED = 4;
    public int indentation_size;
    public int tab_char;
    public int tab_size;
    public int comment_line_length;
    public boolean indent_case_body = false;
    public boolean indent_empty_lines = true;

    public static DefaultCodeFormatterOptions getDefaultSettings() {
        DefaultCodeFormatterOptions options = new DefaultCodeFormatterOptions();
        options.setDefaultSettings();
        return options;
    }

    public static DefaultCodeFormatterOptions getEclipseDefaultSettings() {
        DefaultCodeFormatterOptions options = new DefaultCodeFormatterOptions();
        options.setEclipseDefaultSettings();
        return options;
    }

    public static DefaultCodeFormatterOptions getRubyConventionsSettings() {
        DefaultCodeFormatterOptions options = new DefaultCodeFormatterOptions();
        options.setRubyConventionsSettings();
        return options;
    }

    private DefaultCodeFormatterOptions() {
    }

    public DefaultCodeFormatterOptions(Map settings) {
        this.setDefaultSettings();
        if (settings == null) {
            return;
        }
        this.set(settings);
    }

    public void setDefaultSettings() {
        this.tab_char = 1;
        this.tab_size = 4;
        this.indentation_size = 4;
        this.indent_case_body = true;
        this.indent_empty_lines = true;
    }

    public void setEclipseDefaultSettings() {
        this.setRubyConventionsSettings();
    }

    public void setRubyConventionsSettings() {
        this.setDefaultSettings();
        this.tab_char = 2;
        this.tab_size = 2;
        this.indentation_size = 2;
        this.indent_case_body = true;
        this.indent_empty_lines = true;
    }

    public Map getMap() {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("org.rubypeople.rdt.core.formatter.comment.line_length", Integer.toString(this.comment_line_length));
        options.put("org.rubypeople.rdt.core.formatter.indentation.size", Integer.toString(this.indentation_size));
        switch (this.tab_char) {
            case 2: {
                options.put("org.rubypeople.rdt.core.formatter.tabulation.char", "space");
                break;
            }
            case 1: {
                options.put("org.rubypeople.rdt.core.formatter.tabulation.char", "tab");
                break;
            }
            case 4: {
                options.put("org.rubypeople.rdt.core.formatter.tabulation.char", "mixed");
            }
        }
        options.put("org.rubypeople.rdt.core.formatter.tabulation.size", Integer.toString(this.tab_size));
        options.put("org.rubypeople.rdt.core.formatter.indent_case_body", Boolean.toString(this.indent_case_body));
        options.put("org.rubypeople.rdt.core.formatter.indent_empty_lines", Boolean.toString(this.indent_empty_lines));
        return options;
    }

    public void set(Map settings) {
        Object useTabOption;
        Object tabSizeOption;
        Object indentationSizeOption;
        Object commentLineLengthOption;
        Object indentEmptyLinesOption;
        Object indentCaseBodyOption = settings.get("org.rubypeople.rdt.core.formatter.indent_case_body");
        if (indentCaseBodyOption != null) {
            try {
                this.indent_case_body = Boolean.parseBoolean((String)indentCaseBodyOption);
            }
            catch (NumberFormatException numberFormatException) {
                this.indent_case_body = false;
            }
            catch (ClassCastException classCastException) {
                this.indent_case_body = false;
            }
        }
        if ((indentEmptyLinesOption = settings.get("org.rubypeople.rdt.core.formatter.indent_empty_lines")) != null) {
            try {
                this.indent_empty_lines = Boolean.parseBoolean((String)indentEmptyLinesOption);
            }
            catch (NumberFormatException numberFormatException) {
                this.indent_empty_lines = true;
            }
            catch (ClassCastException classCastException) {
                this.indent_empty_lines = true;
            }
        }
        if ((commentLineLengthOption = settings.get("org.rubypeople.rdt.core.formatter.comment.line_length")) != null) {
            try {
                this.comment_line_length = Integer.parseInt((String)commentLineLengthOption);
            }
            catch (NumberFormatException numberFormatException) {
                this.comment_line_length = 80;
            }
            catch (ClassCastException classCastException) {
                this.comment_line_length = 80;
            }
        }
        if ((indentationSizeOption = settings.get("org.rubypeople.rdt.core.formatter.indentation.size")) != null) {
            try {
                this.indentation_size = Integer.parseInt((String)indentationSizeOption);
            }
            catch (NumberFormatException numberFormatException) {
                this.indentation_size = 4;
            }
            catch (ClassCastException classCastException) {
                this.indentation_size = 4;
            }
        }
        if ((tabSizeOption = settings.get("org.rubypeople.rdt.core.formatter.tabulation.size")) != null) {
            try {
                this.tab_size = Integer.parseInt((String)tabSizeOption);
            }
            catch (NumberFormatException numberFormatException) {
                this.tab_size = 4;
            }
            catch (ClassCastException classCastException) {
                this.tab_size = 4;
            }
        }
        if ((useTabOption = settings.get("org.rubypeople.rdt.core.formatter.tabulation.char")) != null) {
            this.tab_char = "tab".equals(useTabOption) ? 1 : ("space".equals(useTabOption) ? 2 : 4);
        }
    }
}

