/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.core.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.core.IType;
import org.rubypeople.rdt.core.RubyConventions;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.core.RubyElement;
import org.rubypeople.rdt.internal.core.util.CharOperation;
import org.rubypeople.rdt.internal.core.util.SimpleWordSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Util {
    private static boolean ENABLE_RUBY_LIKE_EXTENSIONS = true;
    private static char[][] RUBY_LIKE_EXTENSIONS;
    private static char[][] RUBY_LIKE_FILENAMES;
    private static final String NAMESPACE_DELIMETER = "::";
    private static final int DEFAULT_READING_SIZE = 8192;
    private static char[][] names;
    private static final String ARGUMENTS_DELIMITER = "#";
    private static final String EMPTY_ARGUMENT = "   ";

    private Util() {
    }

    public static void sort(Object[] objects, Comparer comparer) {
        if (objects.length > 1) {
            Util.quickSort(objects, 0, objects.length - 1, comparer);
        }
    }

    private static void quickSort(Object[] sortedCollection, int left, int right, Comparer comparer) {
        int original_left = left;
        int original_right = right;
        Object mid = sortedCollection[(left + right) / 2];
        while (true) {
            if (comparer.compare(sortedCollection[left], mid) < 0) {
                ++left;
                continue;
            }
            while (comparer.compare(mid, sortedCollection[right]) < 0) {
                --right;
            }
            if (left <= right) {
                Object tmp = sortedCollection[left];
                sortedCollection[left] = sortedCollection[right];
                sortedCollection[right] = tmp;
                ++left;
                --right;
            }
            if (left > right) break;
        }
        if (original_left < right) {
            Util.quickSort(sortedCollection, original_left, right, comparer);
        }
        if (left < original_right) {
            Util.quickSort(sortedCollection, left, original_right, comparer);
        }
    }

    public static final boolean isExcluded(IPath resourcePath, char[][] inclusionPatterns, char[][] exclusionPatterns, boolean isFolderPath) {
        if (inclusionPatterns == null && exclusionPatterns == null) {
            return false;
        }
        return Util.isExcluded(resourcePath.toString().toCharArray(), inclusionPatterns, exclusionPatterns, isFolderPath);
    }

    public static final boolean isExcluded(IResource resource, char[][] inclusionPatterns, char[][] exclusionPatterns) {
        IPath path = resource.getFullPath();
        return Util.isExcluded(path, inclusionPatterns, exclusionPatterns, resource.getType() == 2);
    }

    public static final boolean isExcluded(char[] path, char[][] inclusionPatterns, char[][] exclusionPatterns, boolean isFolderPath) {
        int length;
        int i;
        block9: {
            if (inclusionPatterns == null && exclusionPatterns == null) {
                return false;
            }
            if (inclusionPatterns != null) {
                i = 0;
                length = inclusionPatterns.length;
                while (i < length) {
                    int star;
                    int lastSlash;
                    char[] pattern;
                    char[] folderPattern = pattern = inclusionPatterns[i];
                    if (isFolderPath && (lastSlash = CharOperation.lastIndexOf('/', pattern)) != -1 && lastSlash != pattern.length - 1 && ((star = CharOperation.indexOf('*', pattern, lastSlash)) == -1 || star >= pattern.length - 1 || pattern[star + 1] != '*')) {
                        folderPattern = CharOperation.subarray(pattern, 0, lastSlash);
                    }
                    if (!CharOperation.pathMatch(folderPattern, path, true, '/')) {
                        ++i;
                        continue;
                    }
                    break block9;
                }
                return true;
            }
        }
        if (isFolderPath) {
            path = CharOperation.concat(path, new char[]{'*'}, '/');
        }
        if (exclusionPatterns != null) {
            i = 0;
            length = exclusionPatterns.length;
            while (i < length) {
                if (CharOperation.pathMatch(exclusionPatterns[i], path, true, '/')) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public static void verbose(String log) {
        Util.verbose(log, System.out);
    }

    public static synchronized void verbose(String log, PrintStream printStream) {
        int end;
        int start = 0;
        do {
            end = log.indexOf(10, start);
            printStream.print(Thread.currentThread());
            printStream.print(" ");
            printStream.print(log.substring(start, end == -1 ? log.length() : end + 1));
        } while ((start = end + 1) != 0);
        printStream.println();
    }

    public static final boolean isRubyLikeFileName(String name) {
        if (name == null) {
            return false;
        }
        char[][] rubyFileNames = Util.getRubyLikeFilenames();
        int i = 0;
        while (i < rubyFileNames.length) {
            char[] filename = rubyFileNames[i];
            if (name.equals(new String(filename))) {
                return true;
            }
            ++i;
        }
        return Util.indexOfRubyLikeExtension(name) != -1;
    }

    public static final boolean isRubyOrERBLikeFileName(String name) {
        return Util.isRubyLikeFileName(name) || Util.isERBLikeFileName(name);
    }

    public static boolean isValidRubyScriptName(String name) {
        return RubyConventions.validateRubyScriptName(name).getSeverity() != 4;
    }

    public static boolean equalArraysOrNull(Object[] a, Object[] b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        int len = a.length;
        if (len != b.length) {
            return false;
        }
        int i = 0;
        while (i < len) {
            if (a[i] == null ? b[i] != null : !a[i].equals(b[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static void log(Throwable e, String message) {
        Throwable nestedException;
        if (e instanceof RubyModelException && (nestedException = ((RubyModelException)((Object)e)).getException()) != null) {
            e = nestedException;
        }
        Status status = new Status(4, "org.rubypeople.rdt.core", 4, message, e);
        RubyCore.getPlugin().getLog().log((IStatus)status);
    }

    public static int combineHashCodes(int hashCode1, int hashCode2) {
        return hashCode1 * 17 + hashCode2;
    }

    public static final boolean isExcluded(IRubyElement element) {
        int elementType = element.getElementType();
        switch (elementType) {
            case 0: 
            case 1: {
                return false;
            }
            case 4: {
                IResource resource = element.getResource();
                if (resource == null) {
                    return false;
                }
                return Util.isExcluded(element.getParent());
            }
        }
        IRubyElement cu = element.getAncestor(4);
        return cu != null && Util.isExcluded(cu);
    }

    public static String getNameWithoutRubyLikeExtension(String fileName) {
        int index = Util.indexOfRubyLikeExtension(fileName);
        if (index == -1) {
            return fileName;
        }
        return fileName.substring(0, index);
    }

    public static int indexOfRubyLikeExtension(String fileName) {
        int fileNameLength = fileName.length();
        char[][] rubyLikeExtensions = Util.getRubyLikeExtensions();
        int i = 0;
        int length = rubyLikeExtensions.length;
        while (i < length) {
            block4: {
                char[] extension = rubyLikeExtensions[i];
                int extensionLength = extension.length;
                int extensionStart = fileNameLength - extensionLength;
                int dotIndex = extensionStart - 1;
                if (dotIndex >= 0 && fileName.charAt(dotIndex) == '.') {
                    int j = 0;
                    while (j < extensionLength) {
                        if (fileName.charAt(extensionStart + j) == extension[j]) {
                            ++j;
                            continue;
                        }
                        break block4;
                    }
                    return dotIndex;
                }
            }
            ++i;
        }
        return -1;
    }

    public static char[][] getRubyLikeExtensions() {
        if (RUBY_LIKE_EXTENSIONS == null) {
            if (!ENABLE_RUBY_LIKE_EXTENSIONS) {
                RUBY_LIKE_EXTENSIONS = new char[][]{"rb".toCharArray(), "rbw".toCharArray(), "rjs".toCharArray(), "rxml".toCharArray(), "rake".toCharArray()};
            } else {
                IContentType rubyContentType = Platform.getContentTypeManager().getContentType("org.rubypeople.rdt.core.rubySource");
                String[] fileExtensions = rubyContentType == null ? null : rubyContentType.getFileSpecs(8);
                int length = fileExtensions == null ? 0 : fileExtensions.length;
                char[][] extensions = new char[length][];
                SimpleWordSet knownExtensions = new SimpleWordSet(length);
                extensions[0] = "rb".toCharArray();
                knownExtensions.add(extensions[0]);
                int index = 1;
                int i = 0;
                while (i < length) {
                    String fileExtension = fileExtensions[i];
                    char[] extension = fileExtension.toCharArray();
                    if (!knownExtensions.includes(extension)) {
                        extensions[index++] = extension;
                        knownExtensions.add(extension);
                    }
                    ++i;
                }
                if (index != length) {
                    char[][] cArrayArray = extensions;
                    extensions = new char[index][];
                    System.arraycopy(cArrayArray, 0, extensions, 0, index);
                }
                RUBY_LIKE_EXTENSIONS = extensions;
            }
        }
        return RUBY_LIKE_EXTENSIONS;
    }

    public static char[][] getRubyLikeFilenames() {
        if (RUBY_LIKE_FILENAMES == null) {
            IContentType rubyContentType = Platform.getContentTypeManager().getContentType("org.rubypeople.rdt.core.rubySource");
            String[] filenames = rubyContentType == null ? null : rubyContentType.getFileSpecs(4);
            int length = filenames == null ? 0 : filenames.length;
            names = new char[length][];
            SimpleWordSet knownExtensions = new SimpleWordSet(length);
            Util.names[0] = "Rakefile".toCharArray();
            knownExtensions.add(names[0]);
            int index = 1;
            int i = 0;
            while (i < length) {
                String fileExtension = filenames[i];
                char[] extension = fileExtension.toCharArray();
                if (!knownExtensions.includes(extension)) {
                    Util.names[index++] = extension;
                    knownExtensions.add(extension);
                }
                ++i;
            }
            if (index != length) {
                char[][] cArray = names;
                char[][] cArrayArray = new char[index][];
                names = cArrayArray;
                System.arraycopy(cArray, 0, cArrayArray, 0, index);
            }
            RUBY_LIKE_FILENAMES = names;
        }
        return RUBY_LIKE_FILENAMES;
    }

    public static char[] getResourceContentsAsCharArray(IFile file) throws RubyModelException {
        String encoding = null;
        try {
            encoding = file.getCharset();
        }
        catch (CoreException coreException) {}
        return Util.getResourceContentsAsCharArray(file, encoding);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static char[] getResourceContentsAsCharArray(IFile file, String encoding) throws RubyModelException {
        char[] cArray;
        BufferedInputStream stream = null;
        try {
            stream = new BufferedInputStream(file.getContents(true));
        }
        catch (CoreException e) {
            throw new RubyModelException(e, 969);
        }
        try {
            cArray = Util.getInputStreamAsCharArray(stream, -1, encoding);
        }
        catch (IOException e) {
            try {
                throw new RubyModelException(e, 985);
            }
            catch (Throwable throwable) {
                try {
                    ((InputStream)stream).close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
        }
        try {
            ((InputStream)stream).close();
            return cArray;
        }
        catch (IOException iOException) {}
        return cArray;
    }

    public static char[] getInputStreamAsCharArray(InputStream stream, int length, String encoding) throws IOException {
        char[] contents;
        InputStreamReader reader = null;
        InputStreamReader inputStreamReader = reader = encoding == null ? new InputStreamReader(stream) : new InputStreamReader(stream, encoding);
        if (length == -1) {
            contents = new char[]{};
            int contentsLength = 0;
            int amountRead = -1;
            do {
                int amountRequested;
                if (contentsLength + (amountRequested = Math.max(stream.available(), 8192)) > contents.length) {
                    char[] cArray = contents;
                    contents = new char[contentsLength + amountRequested];
                    System.arraycopy(cArray, 0, contents, 0, contentsLength);
                }
                if ((amountRead = reader.read(contents, contentsLength, amountRequested)) <= 0) continue;
                contentsLength += amountRead;
            } while (amountRead != -1);
            int start = 0;
            if (contentsLength > 0 && "UTF-8".equals(encoding) && contents[0] == '\ufeff') {
                --contentsLength;
                start = 1;
            }
            if (contentsLength < contents.length) {
                char[] cArray = contents;
                contents = new char[contentsLength];
                System.arraycopy(cArray, start, contents, 0, contentsLength);
            }
        } else {
            contents = new char[length];
            int len = 0;
            int readSize = 0;
            while (readSize != -1 && len != length) {
                readSize = reader.read(contents, len += readSize, length - len);
            }
            int start = 0;
            if (length > 0 && "UTF-8".equals(encoding) && contents[0] == '\ufeff') {
                --len;
                start = 1;
            }
            if (len != length) {
                char[] cArray = contents;
                contents = new char[len];
                System.arraycopy(cArray, start, contents, 0, len);
            }
        }
        return contents;
    }

    public static void resetRubyLikeExtensions() {
        RUBY_LIKE_EXTENSIONS = null;
        RUBY_LIKE_FILENAMES = null;
    }

    public static final String[] arrayConcat(String[] first, String second) {
        if (second == null) {
            return first;
        }
        if (first == null) {
            return new String[]{second};
        }
        int length = first.length;
        if (first.length == 0) {
            return new String[]{second};
        }
        String[] result = new String[length + 1];
        System.arraycopy(first, 0, result, 0, length);
        result[length] = second;
        return result;
    }

    public static String[] getTrimmedSimpleNames(String packageName) {
        if (packageName.length() == 0) {
            return new String[0];
        }
        return packageName.split("\\" + File.separator);
    }

    public static String concatWith(String[] array, char separator) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        int length = array.length;
        while (i < length) {
            buffer.append(array[i]);
            if (i < length - 1) {
                buffer.append(separator);
            }
            ++i;
        }
        return buffer.toString();
    }

    public static boolean isValidSourceFolderName(String name) {
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] getResourceContentsAsByteArray(IFile file) throws RubyModelException {
        byte[] byArray;
        InputStream stream = null;
        try {
            stream = file.getContents(true);
        }
        catch (CoreException e) {
            throw new RubyModelException(e);
        }
        try {
            byArray = org.rubypeople.rdt.core.util.Util.getInputStreamAsByteArray(stream, -1);
        }
        catch (IOException e) {
            try {
                throw new RubyModelException(e, 985);
            }
            catch (Throwable throwable) {
                try {
                    stream.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
        }
        try {
            stream.close();
            return byArray;
        }
        catch (IOException iOException) {}
        return byArray;
    }

    public static File toLocalFile(URI uri, IProgressMonitor monitor) throws CoreException {
        IFileStore fileStore = EFS.getStore((URI)uri);
        File localFile = fileStore.toLocalFile(0, monitor);
        if (localFile == null) {
            localFile = fileStore.toLocalFile(4096, monitor);
        }
        return localFile;
    }

    public static String getProblemArgumentsForMarker(String[] arguments) {
        StringBuffer args = new StringBuffer(10);
        args.append(arguments.length);
        args.append(':');
        int j = 0;
        while (j < arguments.length) {
            if (j != 0) {
                args.append(ARGUMENTS_DELIMITER);
            }
            if (arguments[j].length() == 0) {
                args.append(EMPTY_ARGUMENT);
            } else {
                args.append(arguments[j]);
            }
            ++j;
        }
        return args.toString();
    }

    public static String getLineSeparator(String text, IRubyProject project) {
        IScopeContext[] scopeContext;
        String lineSeparator = null;
        if (text != null && text.length() != 0 && (lineSeparator = Util.findLineSeparator(text.toCharArray())) != null) {
            return lineSeparator;
        }
        if (project != null) {
            scopeContext = new IScopeContext[]{new ProjectScope(project.getProject())};
            lineSeparator = Platform.getPreferencesService().getString("org.eclipse.core.runtime", "line.separator", null, scopeContext);
            if (lineSeparator != null) {
                return lineSeparator;
            }
        }
        scopeContext = new IScopeContext[]{new InstanceScope()};
        lineSeparator = Platform.getPreferencesService().getString("org.eclipse.core.runtime", "line.separator", null, scopeContext);
        if (lineSeparator != null) {
            return lineSeparator;
        }
        return org.rubypeople.rdt.core.util.Util.LINE_SEPARATOR;
    }

    public static String findLineSeparator(char[] text) {
        int length = text.length;
        if (length > 0) {
            int nextChar = text[0];
            int i = 0;
            while (i < length) {
                int currentChar = nextChar;
                nextChar = i < length - 1 ? text[i + 1] : 32;
                switch (currentChar) {
                    case 10: {
                        return "\n";
                    }
                    case 13: {
                        return nextChar == 10 ? "\r\n" : "\r";
                    }
                }
                ++i;
            }
        }
        return null;
    }

    public static void sort(String[] strings) {
        if (strings.length > 1) {
            Util.quickSort(strings, 0, strings.length - 1);
        }
    }

    private static void quickSort(String[] sortedCollection, int left, int right) {
        int original_left = left;
        int original_right = right;
        String mid = sortedCollection[(left + right) / 2];
        while (true) {
            if (sortedCollection[left].compareTo(mid) < 0) {
                ++left;
                continue;
            }
            while (mid.compareTo(sortedCollection[right]) < 0) {
                --right;
            }
            if (left <= right) {
                String tmp = sortedCollection[left];
                sortedCollection[left] = sortedCollection[right];
                sortedCollection[right] = tmp;
                ++left;
                --right;
            }
            if (left > right) break;
        }
        if (original_left < right) {
            Util.quickSort(sortedCollection, original_left, right);
        }
        if (left < original_right) {
            Util.quickSort(sortedCollection, left, original_right);
        }
    }

    public static boolean equalArrays(Object[] a, Object[] b, int len) {
        if (a == b) {
            return true;
        }
        if (a.length < len || b.length < len) {
            return false;
        }
        int i = 0;
        while (i < len) {
            if (a[i] == null ? b[i] != null : !a[i].equals(b[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static String getSimpleName(String fullyQualifiedName) {
        if (fullyQualifiedName == null) {
            return null;
        }
        String[] names = Util.getTypeNameParts(fullyQualifiedName);
        if (names.length == 0) {
            return null;
        }
        return names[names.length - 1];
    }

    public static boolean parentsMatch(IType type, String fullyQualifiedName) {
        String[] names = Util.getTypeNameParts(fullyQualifiedName);
        int i = names.length - 2;
        while (i >= 0) {
            IType parent = type.getDeclaringType();
            if (parent == null || !names[i].equals(parent.getElementName())) {
                return false;
            }
            type = parent;
            --i;
        }
        return true;
    }

    public static String[] getTypeNameParts(String fullyQualifiedName) {
        if (fullyQualifiedName == null) {
            return new String[0];
        }
        return fullyQualifiedName.split(NAMESPACE_DELIMETER);
    }

    public static void sort(int[] list) {
        if (list.length > 1) {
            Util.quickSort(list, 0, list.length - 1);
        }
    }

    private static void quickSort(int[] list, int left, int right) {
        int original_left = left;
        int original_right = right;
        int mid = list[(left + right) / 2];
        while (true) {
            if (list[left] < mid) {
                ++left;
                continue;
            }
            while (mid < list[right]) {
                --right;
            }
            if (left <= right) {
                int tmp = list[left];
                list[left] = list[right];
                list[right] = tmp;
                ++left;
                --right;
            }
            if (left > right) break;
        }
        if (original_left < right) {
            Util.quickSort(list, original_left, right);
        }
        if (left < original_right) {
            Util.quickSort(list, left, original_right);
        }
    }

    public static String relativePath(IPath fullPath, int skipSegmentCount) {
        boolean hasTrailingSeparator = fullPath.hasTrailingSeparator();
        String[] segments = fullPath.segments();
        int length = 0;
        int max = segments.length;
        if (max > skipSegmentCount) {
            int i1 = skipSegmentCount;
            while (i1 < max) {
                length += segments[i1].length();
                ++i1;
            }
            length += max - skipSegmentCount - 1;
        }
        if (hasTrailingSeparator) {
            ++length;
        }
        char[] result = new char[length];
        int offset = 0;
        int len = segments.length - 1;
        if (len >= skipSegmentCount) {
            int i = skipSegmentCount;
            while (i < len) {
                int size = segments[i].length();
                segments[i].getChars(0, size, result, offset);
                offset += size;
                result[offset++] = 47;
                ++i;
            }
            int size = segments[len].length();
            segments[len].getChars(0, size, result, offset);
            offset += size;
        }
        if (hasTrailingSeparator) {
            result[offset++] = 47;
        }
        return new String(result);
    }

    public static IRubyElement[] sortCopy(IRubyElement[] elements) {
        int len = elements.length;
        Object[] copy = new IRubyElement[len];
        System.arraycopy(elements, 0, copy, 0, len);
        Util.sort(copy, new Comparer(){

            public int compare(Object a, Object b) {
                return ((RubyElement)a).toStringWithAncestors().compareTo(((RubyElement)b).toStringWithAncestors());
            }
        });
        return copy;
    }

    public static String identifierToConstant(String typeName) {
        StringBuffer buffer = new StringBuffer();
        boolean doNextAsUpper = true;
        int i = 0;
        while (i < typeName.length()) {
            char c = typeName.charAt(i);
            if (doNextAsUpper) {
                buffer.append(Character.toUpperCase(c));
                doNextAsUpper = false;
            } else if (c == '_') {
                doNextAsUpper = true;
            } else {
                buffer.append(c);
            }
            ++i;
        }
        return buffer.toString();
    }

    public static void sortReverseOrder(String[] strings) {
        if (strings.length > 1) {
            Util.quickSortReverse(strings, 0, strings.length - 1);
        }
    }

    private static void quickSortReverse(String[] sortedCollection, int left, int right) {
        int original_left = left;
        int original_right = right;
        String mid = sortedCollection[(left + right) / 2];
        while (true) {
            if (sortedCollection[left].compareTo(mid) > 0) {
                ++left;
                continue;
            }
            while (mid.compareTo(sortedCollection[right]) > 0) {
                --right;
            }
            if (left <= right) {
                String tmp = sortedCollection[left];
                sortedCollection[left] = sortedCollection[right];
                sortedCollection[right] = tmp;
                ++left;
                --right;
            }
            if (left > right) break;
        }
        if (original_left < right) {
            Util.quickSortReverse(sortedCollection, original_left, right);
        }
        if (left < original_right) {
            Util.quickSortReverse(sortedCollection, left, original_right);
        }
    }

    public static final String concatWith(String[] array, String name, char separator) {
        if (array == null || array.length == 0) {
            return name;
        }
        if (name == null || name.length() == 0) {
            return Util.concatWith(array, separator);
        }
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        int length = array.length;
        while (i < length) {
            buffer.append(array[i]);
            buffer.append(separator);
            ++i;
        }
        buffer.append(name);
        return buffer.toString();
    }

    public static boolean ignore(String message) {
        return message.startsWith("Useless") || message.startsWith("Found '='");
    }

    public static boolean isERBLikeFileName(String name) {
        return name.endsWith(".erb") || name.endsWith(".rhtml");
    }

    public static char[] replaceNonRubyCodeWithWhitespace(String source) {
        List<String> code = Util.getRubyCodeChunks(source);
        StringBuffer buffer = new StringBuffer();
        if (code == null || code.size() == 0) {
            int j = 0;
            while (j < source.length()) {
                char chr = source.charAt(j);
                if (Character.isWhitespace(chr)) {
                    buffer.append(chr);
                } else {
                    buffer.append(' ');
                }
                ++j;
            }
            return buffer.toString().toCharArray();
        }
        int endOfLastFragment = 0;
        for (String codeFragment : code) {
            int beginningOfCurrentFragment = source.indexOf(codeFragment, endOfLastFragment);
            String portion = source.substring(endOfLastFragment, beginningOfCurrentFragment);
            int j = 0;
            while (j < portion.length()) {
                char chr = portion.charAt(j);
                if (Character.isWhitespace(chr)) {
                    buffer.append(chr);
                } else if (j != 0 && chr == '>' && portion.charAt(j - 1) == '%') {
                    buffer.append(';');
                } else {
                    buffer.append(' ');
                }
                ++j;
            }
            buffer.append(codeFragment);
            endOfLastFragment = beginningOfCurrentFragment + codeFragment.length();
        }
        return buffer.toString().toCharArray();
    }

    private static List<String> getRubyCodeChunks(String stringContents) {
        ArrayList<String> code = new ArrayList<String>();
        String[] pieces = stringContents.split("(<%%)|(%%>)|(<%=)|(<%#)|(<%)|(\\-?%>)");
        int i = 0;
        while (i < pieces.length) {
            if (i % 2 == 1) {
                code.add(pieces[i]);
            }
            ++i;
        }
        return code;
    }

    public static boolean isValidRubyOrERBScriptName(String name) {
        if (RubyConventions.validateRubyScriptName(name).getSeverity() != 4) {
            return true;
        }
        return Util.isERBLikeFileName(name);
    }

    public static interface Comparer {
        public int compare(Object var1, Object var2);
    }
}

