/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.core.util;

import org.rubypeople.rdt.internal.compiler.parser.ScannerHelper;

public class CharOperation {
    public static final char[] NO_CHAR = new char[0];
    public static final String[] NO_STRINGS = new String[0];
    public static final char[][] NO_CHAR_CHAR = new char[0][];

    public static final int indexOf(char toBeFound, char[] array, int start) {
        int i = start;
        while (i < array.length) {
            if (toBeFound == array[i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static final char[] replace(char[] array, char[] toBeReplaced, char[] replacementChars) {
        int max = array.length;
        int replacedLength = toBeReplaced.length;
        int replacementLength = replacementChars.length;
        int[] starts = new int[5];
        int occurrenceCount = 0;
        if (!CharOperation.equals(toBeReplaced, replacementChars)) {
            int i = 0;
            while (i < max) {
                block7: {
                    int j = 0;
                    while (j < replacedLength) {
                        if (i + j != max && array[i + j] == toBeReplaced[j++]) {
                            continue;
                        }
                        break block7;
                    }
                    if (occurrenceCount == starts.length) {
                        int[] nArray = starts;
                        starts = new int[occurrenceCount * 2];
                        System.arraycopy(nArray, 0, starts, 0, occurrenceCount);
                    }
                    starts[occurrenceCount++] = i;
                }
                ++i;
            }
        }
        if (occurrenceCount == 0) {
            return array;
        }
        char[] result = new char[max + occurrenceCount * (replacementLength - replacedLength)];
        int inStart = 0;
        int outStart = 0;
        int i = 0;
        while (i < occurrenceCount) {
            int offset = starts[i] - inStart;
            System.arraycopy(array, inStart, result, outStart, offset);
            inStart += offset;
            System.arraycopy(replacementChars, 0, result, outStart += offset, replacementLength);
            inStart += replacedLength;
            outStart += replacementLength;
            ++i;
        }
        System.arraycopy(array, inStart, result, outStart, max - inStart);
        return result;
    }

    public static final boolean equals(char[] first, char[] second) {
        if (first == second) {
            return true;
        }
        if (first == null || second == null) {
            return false;
        }
        if (first.length != second.length) {
            return false;
        }
        int i = first.length;
        while (--i >= 0) {
            if (first[i] == second[i]) continue;
            return false;
        }
        return true;
    }

    public static final boolean pathMatch(char[] pattern, char[] filepath, boolean isCaseSensitive, char pathSeparator) {
        int pSegmentRestart;
        if (filepath == null) {
            return false;
        }
        if (pattern == null) {
            return true;
        }
        int pSegmentStart = pattern[0] == pathSeparator ? 1 : 0;
        int pLength = pattern.length;
        int pSegmentEnd = CharOperation.indexOf(pathSeparator, pattern, pSegmentStart + 1);
        if (pSegmentEnd < 0) {
            pSegmentEnd = pLength;
        }
        boolean freeTrailingDoubleStar = pattern[pLength - 1] == pathSeparator;
        int fLength = filepath.length;
        int fSegmentStart = filepath[0] != pathSeparator ? 0 : 1;
        if (fSegmentStart != pSegmentStart) {
            return false;
        }
        int fSegmentEnd = CharOperation.indexOf(pathSeparator, filepath, fSegmentStart + 1);
        if (fSegmentEnd < 0) {
            fSegmentEnd = fLength;
        }
        while (!(pSegmentStart >= pLength || pSegmentEnd == pLength && freeTrailingDoubleStar || pSegmentEnd == pSegmentStart + 2 && pattern[pSegmentStart] == '*' && pattern[pSegmentStart + 1] == '*')) {
            if (fSegmentStart >= fLength) {
                return false;
            }
            if (!CharOperation.match(pattern, pSegmentStart, pSegmentEnd, filepath, fSegmentStart, fSegmentEnd, isCaseSensitive)) {
                return false;
            }
            pSegmentStart = pSegmentEnd + 1;
            if ((pSegmentEnd = CharOperation.indexOf(pathSeparator, pattern, pSegmentStart)) < 0) {
                pSegmentEnd = pLength;
            }
            if ((fSegmentEnd = CharOperation.indexOf(pathSeparator, filepath, fSegmentStart = fSegmentEnd + 1)) >= 0) continue;
            fSegmentEnd = fLength;
        }
        if (pSegmentStart >= pLength && freeTrailingDoubleStar || pSegmentEnd == pSegmentStart + 2 && pattern[pSegmentStart] == '*' && pattern[pSegmentStart + 1] == '*') {
            pSegmentStart = pSegmentEnd + 1;
            if ((pSegmentEnd = CharOperation.indexOf(pathSeparator, pattern, pSegmentStart)) < 0) {
                pSegmentEnd = pLength;
            }
            pSegmentRestart = pSegmentStart;
        } else {
            if (pSegmentStart >= pLength) {
                return fSegmentStart >= fLength;
            }
            pSegmentRestart = 0;
        }
        int fSegmentRestart = fSegmentStart;
        while (fSegmentStart < fLength) {
            if (pSegmentStart >= pLength) {
                if (freeTrailingDoubleStar) {
                    return true;
                }
                pSegmentStart = pSegmentRestart;
                pSegmentEnd = CharOperation.indexOf(pathSeparator, pattern, pSegmentStart);
                if (pSegmentEnd < 0) {
                    pSegmentEnd = pLength;
                }
                if ((fSegmentRestart = CharOperation.indexOf(pathSeparator, filepath, fSegmentRestart + 1)) < 0) {
                    fSegmentRestart = fLength;
                }
                fSegmentStart = ++fSegmentRestart;
                fSegmentEnd = CharOperation.indexOf(pathSeparator, filepath, fSegmentStart);
                if (fSegmentEnd >= 0) continue;
                fSegmentEnd = fLength;
                continue;
            }
            if (pSegmentEnd == pSegmentStart + 2 && pattern[pSegmentStart] == '*' && pattern[pSegmentStart + 1] == '*') {
                pSegmentStart = pSegmentEnd + 1;
                if ((pSegmentEnd = CharOperation.indexOf(pathSeparator, pattern, pSegmentStart)) < 0) {
                    pSegmentEnd = pLength;
                }
                pSegmentRestart = pSegmentStart;
                fSegmentRestart = fSegmentStart;
                if (pSegmentStart < pLength) continue;
                return true;
            }
            if (!CharOperation.match(pattern, pSegmentStart, pSegmentEnd, filepath, fSegmentStart, fSegmentEnd, isCaseSensitive)) {
                pSegmentStart = pSegmentRestart;
                pSegmentEnd = CharOperation.indexOf(pathSeparator, pattern, pSegmentStart);
                if (pSegmentEnd < 0) {
                    pSegmentEnd = pLength;
                }
                if ((fSegmentRestart = CharOperation.indexOf(pathSeparator, filepath, fSegmentRestart + 1)) < 0) {
                    fSegmentRestart = fLength;
                }
                fSegmentStart = ++fSegmentRestart;
                fSegmentEnd = CharOperation.indexOf(pathSeparator, filepath, fSegmentStart);
                if (fSegmentEnd >= 0) continue;
                fSegmentEnd = fLength;
                continue;
            }
            pSegmentStart = pSegmentEnd + 1;
            if ((pSegmentEnd = CharOperation.indexOf(pathSeparator, pattern, pSegmentStart)) < 0) {
                pSegmentEnd = pLength;
            }
            if ((fSegmentEnd = CharOperation.indexOf(pathSeparator, filepath, fSegmentStart = fSegmentEnd + 1)) >= 0) continue;
            fSegmentEnd = fLength;
        }
        return pSegmentRestart >= pSegmentEnd || fSegmentStart >= fLength && pSegmentStart >= pLength || pSegmentStart == pLength - 2 && pattern[pSegmentStart] == '*' && pattern[pSegmentStart + 1] == '*' || pSegmentStart == pLength && freeTrailingDoubleStar;
    }

    public static final boolean match(char[] pattern, int patternStart, int patternEnd, char[] name, int nameStart, int nameEnd, boolean isCaseSensitive) {
        if (name == null) {
            return false;
        }
        if (pattern == null) {
            return true;
        }
        int iPattern = patternStart;
        int iName = nameStart;
        if (patternEnd < 0) {
            patternEnd = pattern.length;
        }
        if (nameEnd < 0) {
            nameEnd = name.length;
        }
        char patternChar = '\u0000';
        while (iPattern < patternEnd && (patternChar = pattern[iPattern]) != '*') {
            if (iName == nameEnd) {
                return false;
            }
            if (patternChar != (isCaseSensitive ? name[iName] : Character.toLowerCase(name[iName])) && patternChar != '?') {
                return false;
            }
            ++iName;
            ++iPattern;
        }
        int segmentStart = patternChar == '*' ? ++iPattern : 0;
        int prefixStart = iName;
        while (iName < nameEnd) {
            if (iPattern == patternEnd) {
                iPattern = segmentStart;
                iName = ++prefixStart;
                continue;
            }
            patternChar = pattern[iPattern];
            if (patternChar == '*') {
                if ((segmentStart = ++iPattern) == patternEnd) {
                    return true;
                }
                prefixStart = iName;
                continue;
            }
            if ((isCaseSensitive ? name[iName] : Character.toLowerCase(name[iName])) != patternChar && patternChar != '?') {
                iPattern = segmentStart;
                iName = ++prefixStart;
                continue;
            }
            ++iName;
            ++iPattern;
        }
        return segmentStart == patternEnd || iName == nameEnd && iPattern == patternEnd || iPattern == patternEnd - 1 && pattern[iPattern] == '*';
    }

    public static final char[] subarray(char[] array, int start, int end) {
        if (end == -1) {
            end = array.length;
        }
        if (start > end) {
            return null;
        }
        if (start < 0) {
            return null;
        }
        if (end > array.length) {
            return null;
        }
        char[] result = new char[end - start];
        System.arraycopy(array, start, result, 0, end - start);
        return result;
    }

    public static final char[] concat(char[] first, char[] second, char separator) {
        if (first == null) {
            return second;
        }
        if (second == null) {
            return first;
        }
        int length1 = first.length;
        if (length1 == 0) {
            return second;
        }
        int length2 = second.length;
        if (length2 == 0) {
            return first;
        }
        char[] result = new char[length1 + length2 + 1];
        System.arraycopy(first, 0, result, 0, length1);
        result[length1] = separator;
        System.arraycopy(second, 0, result, length1 + 1, length2);
        return result;
    }

    public static final int lastIndexOf(char toBeFound, char[] array) {
        int i = array.length;
        while (--i >= 0) {
            if (toBeFound != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static final boolean equals(char[][] first, char[][] second) {
        if (first == second) {
            return true;
        }
        if (first == null || second == null) {
            return false;
        }
        if (first.length != second.length) {
            return false;
        }
        int i = first.length;
        while (--i >= 0) {
            if (CharOperation.equals(first[i], second[i])) continue;
            return false;
        }
        return true;
    }

    public static final boolean equals(String[] first, String[] second) {
        if (first == second) {
            return true;
        }
        if (first == null || second == null) {
            return false;
        }
        if (first.length != second.length) {
            return false;
        }
        int i = first.length;
        while (--i >= 0) {
            if (first[i].equals(second[i])) continue;
            return false;
        }
        return true;
    }

    public static final int hashCode(char[] array) {
        int hash;
        int length = array.length;
        int n = hash = length == 0 ? 31 : array[0];
        if (length < 8) {
            int i = length;
            while (--i > 0) {
                hash = hash * 31 + array[i];
            }
        } else {
            int i = length - 1;
            int last = i > 16 ? i - 16 : 0;
            while (i > last) {
                hash = hash * 31 + array[i];
                i -= 2;
            }
        }
        return hash & Integer.MAX_VALUE;
    }

    public static final char[] concatWith(char[][] array, char separator) {
        int length;
        int n = length = array == null ? 0 : array.length;
        if (length == 0) {
            return NO_CHAR;
        }
        int size = length - 1;
        int index = length;
        while (--index >= 0) {
            if (array[index].length == 0) {
                --size;
                continue;
            }
            size += array[index].length;
        }
        if (size <= 0) {
            return NO_CHAR;
        }
        char[] result = new char[size];
        index = length;
        while (--index >= 0) {
            length = array[index].length;
            if (length <= 0) continue;
            System.arraycopy(array[index], 0, result, size -= length, length);
            if (--size < 0) continue;
            result[size] = separator;
        }
        return result;
    }

    public static final char[][] splitOn(char divider, char[] array) {
        int length;
        int n = length = array == null ? 0 : array.length;
        if (length == 0) {
            return NO_CHAR_CHAR;
        }
        int wordCount = 1;
        int i = 0;
        while (i < length) {
            if (array[i] == divider) {
                ++wordCount;
            }
            ++i;
        }
        char[][] split = new char[wordCount][];
        int last = 0;
        int currentWord = 0;
        int i2 = 0;
        while (i2 < length) {
            if (array[i2] == divider) {
                split[currentWord] = new char[i2 - last];
                System.arraycopy(array, last, split[currentWord++], 0, i2 - last);
                last = i2 + 1;
            }
            ++i2;
        }
        split[currentWord] = new char[length - last];
        System.arraycopy(array, last, split[currentWord], 0, length - last);
        return split;
    }

    public static final boolean prefixEquals(char[] prefix, char[] name) {
        int max = prefix.length;
        if (name.length < max) {
            return false;
        }
        int i = max;
        while (--i >= 0) {
            if (prefix[i] == name[i]) continue;
            return false;
        }
        return true;
    }

    public static final boolean camelCaseMatch(char[] pattern, char[] name) {
        if (pattern == null) {
            return true;
        }
        if (name == null) {
            return false;
        }
        return CharOperation.camelCaseMatch(pattern, 0, pattern.length, name, 0, name.length);
    }

    public static final boolean camelCaseMatch(char[] pattern, int patternStart, int patternEnd, char[] name, int nameStart, int nameEnd) {
        if (name == null) {
            return false;
        }
        if (pattern == null) {
            return true;
        }
        if (patternEnd < 0) {
            patternEnd = pattern.length;
        }
        if (nameEnd < 0) {
            nameEnd = name.length;
        }
        if (patternEnd <= patternStart) {
            return nameEnd <= nameStart;
        }
        if (nameEnd <= nameStart) {
            return false;
        }
        if (name[nameStart] != pattern[patternStart]) {
            return false;
        }
        int iPattern = patternStart;
        int iName = nameStart;
        block0: while (true) {
            char nameChar;
            ++iName;
            if (++iPattern == patternEnd) {
                return true;
            }
            if (iName == nameEnd) {
                return false;
            }
            char patternChar = pattern[iPattern];
            if (patternChar == name[iName]) continue;
            if (patternChar < '\u0080' ? (ScannerHelper.OBVIOUS_IDENT_CHAR_NATURES[patternChar] & 0x20) == 0 : Character.isJavaIdentifierPart(patternChar) && !Character.isUpperCase(patternChar)) {
                return false;
            }
            while (true) {
                if (iName == nameEnd) {
                    return false;
                }
                nameChar = name[iName];
                if (nameChar < '\u0080') {
                    if ((ScannerHelper.OBVIOUS_IDENT_CHAR_NATURES[nameChar] & 0x94) != 0) {
                        ++iName;
                        continue;
                    }
                    if (patternChar == nameChar) continue block0;
                    return false;
                }
                if (!Character.isJavaIdentifierPart(nameChar) || Character.isUpperCase(nameChar)) break;
                ++iName;
            }
            if (patternChar != nameChar) break;
        }
        return false;
    }

    public static final boolean equals(char[] first, char[] second, boolean isCaseSensitive) {
        if (isCaseSensitive) {
            return CharOperation.equals(first, second);
        }
        if (first == second) {
            return true;
        }
        if (first == null || second == null) {
            return false;
        }
        if (first.length != second.length) {
            return false;
        }
        int i = first.length;
        while (--i >= 0) {
            if (ScannerHelper.toLowerCase(first[i]) == ScannerHelper.toLowerCase(second[i])) continue;
            return false;
        }
        return true;
    }

    public static final boolean prefixEquals(char[] prefix, char[] name, boolean isCaseSensitive) {
        int max = prefix.length;
        if (name.length < max) {
            return false;
        }
        if (isCaseSensitive) {
            int i = max;
            while (--i >= 0) {
                if (prefix[i] == name[i]) continue;
                return false;
            }
            return true;
        }
        int i = max;
        while (--i >= 0) {
            if (ScannerHelper.toLowerCase(prefix[i]) == ScannerHelper.toLowerCase(name[i])) continue;
            return false;
        }
        return true;
    }

    public static final boolean match(char[] pattern, char[] name, boolean isCaseSensitive) {
        if (name == null) {
            return false;
        }
        if (pattern == null) {
            return true;
        }
        return CharOperation.match(pattern, 0, pattern.length, name, 0, name.length, isCaseSensitive);
    }

    public static final char[] toLowerCase(char[] chars) {
        if (chars == null) {
            return null;
        }
        int length = chars.length;
        char[] lowerChars = null;
        int i = 0;
        while (i < length) {
            char c = chars[i];
            char lc = ScannerHelper.toLowerCase(c);
            if (c != lc || lowerChars != null) {
                if (lowerChars == null) {
                    lowerChars = new char[length];
                    System.arraycopy(chars, 0, lowerChars, 0, i);
                }
                lowerChars[i] = lc;
            }
            ++i;
        }
        return lowerChars == null ? chars : lowerChars;
    }

    public static final char[][] subarray(char[][] array, int start, int end) {
        if (end == -1) {
            end = array.length;
        }
        if (start > end) {
            return null;
        }
        if (start < 0) {
            return null;
        }
        if (end > array.length) {
            return null;
        }
        char[][] result = new char[end - start][];
        System.arraycopy(array, start, result, 0, end - start);
        return result;
    }

    public static final char[] concat(char[] first, char sep1, char[] second, char sep2, char[] third) {
        if (first == null) {
            return CharOperation.concat(second, third, sep2);
        }
        if (second == null) {
            return CharOperation.concat(first, third, sep1);
        }
        if (third == null) {
            return CharOperation.concat(first, second, sep1);
        }
        int length1 = first.length;
        int length2 = second.length;
        int length3 = third.length;
        char[] result = new char[length1 + length2 + length3 + 2];
        System.arraycopy(first, 0, result, 0, length1);
        result[length1] = sep1;
        System.arraycopy(second, 0, result, length1 + 1, length2);
        result[length1 + length2 + 1] = sep2;
        System.arraycopy(third, 0, result, length1 + length2 + 2, length3);
        return result;
    }

    public static final char[] append(char[] array, char suffix) {
        if (array == null) {
            return new char[]{suffix};
        }
        int length = array.length;
        char[] cArray = array;
        array = new char[length + 1];
        System.arraycopy(cArray, 0, array, 0, length);
        array[length] = suffix;
        return array;
    }

    public static final boolean equals(char[][] first, char[][] second, boolean isCaseSensitive) {
        if (isCaseSensitive) {
            return CharOperation.equals(first, second);
        }
        if (first == second) {
            return true;
        }
        if (first == null || second == null) {
            return false;
        }
        if (first.length != second.length) {
            return false;
        }
        int i = first.length;
        while (--i >= 0) {
            if (CharOperation.equals(first[i], second[i], false)) continue;
            return false;
        }
        return true;
    }

    public static char[][] splitOn(String divider, char[] key, int start, int last) {
        String newKey = new String(key);
        newKey = newKey.substring(start, last);
        String[] result = newKey.split(divider);
        char[][] resultEnd = new char[result.length][];
        int i = 0;
        while (i < resultEnd.length) {
            resultEnd[i] = result[i].toCharArray();
            ++i;
        }
        return resultEnd;
    }

    public static char[][] splitOn(String divider, char[] key) {
        String newKey = new String(key);
        String[] result = newKey.split(divider);
        char[][] resultEnd = new char[result.length][];
        int i = 0;
        while (i < resultEnd.length) {
            resultEnd[i] = result[i].toCharArray();
            ++i;
        }
        return resultEnd;
    }

    public static int occurencesOf(String toBeFound, char[] originalString) {
        String newKey = new String(originalString);
        int count = 0;
        int index = newKey.indexOf(toBeFound);
        while (index > -1) {
            ++count;
            if (newKey.length() < index + toBeFound.length()) break;
            newKey = newKey.substring(index + toBeFound.length());
            index = newKey.indexOf(toBeFound);
        }
        return count;
    }

    public static int lastIndexOf(String toBeFound, char[] typePart) {
        if (typePart == null || typePart.length == 0) {
            return -1;
        }
        return new String(typePart).lastIndexOf(toBeFound);
    }

    public static final char[] concat(char[] first, char[] second) {
        if (first == null) {
            return second;
        }
        if (second == null) {
            return first;
        }
        int length1 = first.length;
        int length2 = second.length;
        char[] result = new char[length1 + length2];
        System.arraycopy(first, 0, result, 0, length1);
        System.arraycopy(second, 0, result, length1, length2);
        return result;
    }

    public static char[] lastSegment(char[] typeName, String divider) {
        if (typeName == null) {
            return NO_CHAR;
        }
        char[][] result = CharOperation.splitOn(divider, typeName);
        return result[result.length - 1];
    }

    public static final char[][] arrayConcat(char[][] first, char[][] second) {
        if (first == null) {
            return second;
        }
        if (second == null) {
            return first;
        }
        int length1 = first.length;
        int length2 = second.length;
        char[][] result = new char[length1 + length2][];
        System.arraycopy(first, 0, result, 0, length1);
        System.arraycopy(second, 0, result, length1, length2);
        return result;
    }

    public static final char[][] arrayConcat(char[][] first, char[] second) {
        if (second == null) {
            return first;
        }
        if (first == null) {
            return new char[][]{second};
        }
        int length = first.length;
        char[][] result = new char[length + 1][];
        System.arraycopy(first, 0, result, 0, length);
        result[length] = second;
        return result;
    }

    public static char[] concatWith(char[][] enclosingTypeNames, String string) {
        if (enclosingTypeNames == null) {
            return NO_CHAR;
        }
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < enclosingTypeNames.length) {
            char[] name = enclosingTypeNames[i];
            if (i > 0) {
                buffer.append(string);
            }
            buffer.append(name);
            ++i;
        }
        return buffer.toString().toCharArray();
    }

    public static char[] concat(char[] one, char[] two, String separator) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(one);
        buffer.append(separator);
        buffer.append(two);
        return buffer.toString().toCharArray();
    }
}

