/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.core.util;

import java.util.Map;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;
import org.jruby.ast.Node;
import org.jruby.lexer.yacc.ISourcePosition;

public class ASTRewrite {
    private Node ast;
    private TextEdit currentEdit;
    private String lineDelim;

    protected ASTRewrite(Node ast, IDocument document) {
        this.ast = ast;
        MultiTextEdit edit = new MultiTextEdit();
        this.lineDelim = TextUtilities.getDefaultLineDelimiter((IDocument)document);
        this.currentEdit = edit;
    }

    public static ASTRewrite create(Node ast, IDocument document) {
        return new ASTRewrite(ast, document);
    }

    public TextEdit rewriteAST(IDocument document, Map options) {
        return this.currentEdit;
    }

    final void doTextInsert(int offset, String insertString) {
        if (insertString.length() > 0) {
            InsertEdit edit;
            if (!insertString.startsWith(this.getLineDelimiter())) {
                edit = new InsertEdit(offset, this.getLineDelimiter());
                this.addEdit((TextEdit)edit);
            }
            edit = new InsertEdit(offset, insertString);
            this.addEdit((TextEdit)edit);
        }
    }

    private String getLineDelimiter() {
        return this.lineDelim;
    }

    public void insertBefore(String source, Node insert, Node element, TextEditGroup group) {
        ISourcePosition pos = element.getPosition();
        this.doTextInsert(pos.getStartOffset(), source);
    }

    final void addEdit(TextEdit edit) {
        this.currentEdit.addChild(edit);
    }

    public void insertAfter(String source, Node insert, Node element, TextEditGroup group) {
        ISourcePosition pos = element.getPosition();
        this.doTextInsert(pos.getEndOffset() + 1, source);
    }

    public void insertLast(String source, Node insert, TextEditGroup group) {
        ISourcePosition pos = this.ast.getPosition();
        this.doTextInsert(pos.getEndOffset() - "end".length(), source);
    }
}

