/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.core.search.matching;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.jruby.ast.CallNode;
import org.jruby.ast.DefnNode;
import org.jruby.ast.DefsNode;
import org.jruby.ast.FCallNode;
import org.jruby.ast.IArgumentNode;
import org.jruby.ast.Node;
import org.jruby.ast.VCallNode;
import org.jruby.ast.types.INameNode;
import org.jruby.evaluator.Instruction;
import org.rubypeople.rdt.core.IMember;
import org.rubypeople.rdt.core.IMethod;
import org.rubypeople.rdt.core.IParent;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.ISourceRange;
import org.rubypeople.rdt.core.IType;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.core.RubyScript;
import org.rubypeople.rdt.internal.core.parser.InOrderVisitor;
import org.rubypeople.rdt.internal.core.parser.RubyParser;
import org.rubypeople.rdt.internal.core.search.matching.MatchLocator;
import org.rubypeople.rdt.internal.core.search.matching.MethodPattern;
import org.rubypeople.rdt.internal.core.search.matching.PatternLocator;

public class MethodLocator
extends PatternLocator {
    private MethodPattern pattern;

    public MethodLocator(MethodPattern pattern) {
        super(pattern);
        this.pattern = pattern;
    }

    public void reportMatches(RubyScript script, MatchLocator locator) {
        if (!this.pattern.findReferences) {
            this.reportMatches((IParent)script, locator);
        } else {
            this.reportASTMatches(script, locator);
        }
    }

    private void reportASTMatches(final RubyScript script, final MatchLocator locator) {
        try {
            Node ast = script.lastGoodAST;
            if (ast == null) {
                ast = new RubyParser().parse(script.getElementName(), script.getSource()).getAST();
            }
            final boolean findDeclarations = this.pattern.findDeclarations;
            new InOrderVisitor(){

                public Instruction visitVCallNode(VCallNode iVisited) {
                    this.match((Node)iVisited, 0);
                    return super.visitVCallNode(iVisited);
                }

                public Instruction visitFCallNode(FCallNode iVisited) {
                    this.match((Node)iVisited, this.getArgumentsFromFunctionCall((IArgumentNode)iVisited).size());
                    return super.visitFCallNode(iVisited);
                }

                public Instruction visitCallNode(CallNode iVisited) {
                    this.match((Node)iVisited, this.getArgumentsFromFunctionCall((IArgumentNode)iVisited).size());
                    return super.visitCallNode(iVisited);
                }

                public Instruction visitDefnNode(DefnNode iVisited) {
                    if (findDeclarations) {
                        this.matchDeclaration((Node)iVisited, iVisited.getArgsNode().getRequiredArgsCount());
                    }
                    return super.visitDefnNode(iVisited);
                }

                public Instruction visitDefsNode(DefsNode iVisited) {
                    if (findDeclarations) {
                        this.matchDeclaration((Node)iVisited, iVisited.getArgsNode().getRequiredArgsCount());
                    }
                    return super.visitDefsNode(iVisited);
                }

                private void match(Node iVisited, int arity) {
                    String name = ((INameNode)iVisited).getName();
                    int accuracy = MethodLocator.this.getAccuracy(name, arity);
                    if (accuracy != 0) {
                        try {
                            IRubyElement element = script.getElementAt(iVisited.getPosition().getStartOffset());
                            if (element == null) {
                                element = script;
                            }
                            if (locator.encloses(element)) {
                                IRubyElement binding = this.resolve(element, iVisited);
                                int start = iVisited.getPosition().getStartOffset();
                                int length = iVisited.getPosition().getEndOffset() - start;
                                boolean isConstructor = false;
                                if (name.equals("new")) {
                                    isConstructor = true;
                                }
                                ArrayList<String> args = new ArrayList();
                                if (iVisited instanceof IArgumentNode) {
                                    args = this.getArgumentsFromFunctionCall((IArgumentNode)iVisited);
                                }
                                locator.report(locator.newMethodReferenceMatch(element, binding, args, accuracy, start, length, isConstructor, iVisited));
                            }
                        }
                        catch (CoreException e) {
                            RubyCore.log((Exception)((Object)e));
                        }
                    }
                }

                private IRubyElement resolve(IRubyElement element, Node visited) {
                    return element;
                }

                private void matchDeclaration(Node iVisited, int arity) {
                    String name = ((INameNode)iVisited).getName();
                    int accuracy = MethodLocator.this.getAccuracy(name, arity);
                    if (accuracy != 0) {
                        try {
                            IRubyElement element = script.getElementAt(iVisited.getPosition().getStartOffset());
                            if (element == null) {
                                element = script;
                            }
                            if (locator.encloses(element)) {
                                int start = iVisited.getPosition().getStartOffset();
                                int length = iVisited.getPosition().getEndOffset() - start;
                                locator.report(locator.newDeclarationMatch(element, accuracy, start, length));
                            }
                        }
                        catch (CoreException e) {
                            RubyCore.log((Exception)((Object)e));
                        }
                    }
                }
            }.acceptNode(ast);
        }
        catch (RubyModelException e) {
            RubyCore.log((Exception)((Object)e));
        }
    }

    private void reportMatches(IParent parent, MatchLocator locator) {
        try {
            IRubyElement[] children = parent.getChildren();
            int i = 0;
            while (i < children.length) {
                IMethod method;
                int accuracy;
                IRubyElement child = children[i];
                if (child.isType(6) && locator.encloses(child) && (accuracy = this.getAccuracy(method = (IMethod)child)) != 0) {
                    IMember member = (IMember)child;
                    ISourceRange range = member.getSourceRange();
                    try {
                        locator.report(locator.newDeclarationMatch(child, accuracy, range.getOffset(), range.getLength()));
                    }
                    catch (CoreException e) {
                        RubyCore.log((Exception)((Object)e));
                    }
                }
                if (child instanceof IParent) {
                    IParent parentTwo = (IParent)((Object)child);
                    this.reportMatches(parentTwo, locator);
                }
                ++i;
            }
        }
        catch (RubyModelException e) {
            RubyCore.log((Exception)((Object)e));
        }
    }

    private int getAccuracy(IMethod method) throws RubyModelException {
        int accuracy = this.getAccuracy(method.getElementName(), method.getParameterNames().length);
        if (accuracy == 0) {
            return accuracy;
        }
        IType type = method.getDeclaringType();
        char[] declaringTypeName = new char[]{};
        if (type != null) {
            declaringTypeName = type.getElementName().toCharArray();
        }
        if (this.pattern.declaringSimpleName != null && !this.matchesName(this.pattern.declaringSimpleName, declaringTypeName)) {
            return 0;
        }
        return 3;
    }

    private int getAccuracy(String name, int arity) {
        int length;
        if (!this.matchesName(this.pattern.selector, name.toCharArray())) {
            return 0;
        }
        if (this.pattern.parameterNames != null && (length = this.pattern.parameterNames.length) != arity) {
            return 0;
        }
        return 3;
    }
}

