/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.core.search.matching;

import org.eclipse.core.runtime.CoreException;
import org.rubypeople.rdt.core.IField;
import org.rubypeople.rdt.core.IMember;
import org.rubypeople.rdt.core.IParent;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.ISourceRange;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.core.RubyScript;
import org.rubypeople.rdt.internal.core.search.matching.LocalVariablePattern;
import org.rubypeople.rdt.internal.core.search.matching.MatchLocator;
import org.rubypeople.rdt.internal.core.search.matching.VariableLocator;

public class LocalVariableLocator
extends VariableLocator {
    public LocalVariableLocator(LocalVariablePattern pattern) {
        super(pattern);
    }

    public void reportMatches(RubyScript script, MatchLocator locator) {
        this.reportMatches((IParent)script, locator);
    }

    private void reportMatches(IParent parent, MatchLocator locator) {
        try {
            IRubyElement[] children = parent.getChildren();
            int i = 0;
            while (i < children.length) {
                int accuracy;
                IRubyElement child = children[i];
                if (child.isType(12) && (accuracy = this.getAccuracy((IField)child)) != 0) {
                    IMember member = (IMember)child;
                    ISourceRange range = member.getSourceRange();
                    try {
                        locator.report(locator.newDeclarationMatch(child, accuracy, range.getOffset(), range.getLength()));
                    }
                    catch (CoreException e) {
                        RubyCore.log((Exception)((Object)e));
                    }
                }
                if (child instanceof IParent) {
                    IParent parentTwo = (IParent)((Object)child);
                    this.reportMatches(parentTwo, locator);
                }
                ++i;
            }
        }
        catch (RubyModelException e) {
            RubyCore.log((Exception)((Object)e));
        }
    }
}

