/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.core.search.indexing;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.CRC32;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.rubypeople.rdt.core.ILoadpathEntry;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.core.search.IRubySearchScope;
import org.rubypeople.rdt.core.search.SearchDocument;
import org.rubypeople.rdt.core.search.SearchParticipant;
import org.rubypeople.rdt.core.util.Util;
import org.rubypeople.rdt.internal.compiler.ISourceElementRequestor;
import org.rubypeople.rdt.internal.compiler.util.SimpleLookupTable;
import org.rubypeople.rdt.internal.compiler.util.SimpleSet;
import org.rubypeople.rdt.internal.core.RubyModel;
import org.rubypeople.rdt.internal.core.RubyModelManager;
import org.rubypeople.rdt.internal.core.RubyProject;
import org.rubypeople.rdt.internal.core.SourceElementParser;
import org.rubypeople.rdt.internal.core.index.Index;
import org.rubypeople.rdt.internal.core.search.BasicSearchEngine;
import org.rubypeople.rdt.internal.core.search.PatternSearchJob;
import org.rubypeople.rdt.internal.core.search.indexing.AddExternalFolderToIndex;
import org.rubypeople.rdt.internal.core.search.indexing.AddFolderToIndex;
import org.rubypeople.rdt.internal.core.search.indexing.IndexAllProject;
import org.rubypeople.rdt.internal.core.search.indexing.IndexRequest;
import org.rubypeople.rdt.internal.core.search.indexing.ReadWriteMonitor;
import org.rubypeople.rdt.internal.core.search.indexing.RemoveFolderFromIndex;
import org.rubypeople.rdt.internal.core.search.indexing.RemoveFromIndex;
import org.rubypeople.rdt.internal.core.search.processing.IJob;
import org.rubypeople.rdt.internal.core.search.processing.JobManager;
import org.rubypeople.rdt.internal.core.util.CharOperation;
import org.rubypeople.rdt.internal.core.util.Messages;

public class IndexManager
extends JobManager {
    public SimpleLookupTable indexLocations = new SimpleLookupTable();
    private Map<IPath, Index> indexes = new HashMap<IPath, Index>(5);
    private boolean needToSave = false;
    private static final CRC32 checksumCalculator = new CRC32();
    private IPath rubyPluginLocation = null;
    private SimpleLookupTable indexStates = null;
    private File savedIndexNamesFile = new File(this.getSavedIndexesDirectory(), "savedIndexNames.txt");
    public static Integer SAVED_STATE = new Integer(0);
    public static Integer UPDATING_STATE = new Integer(1);
    public static Integer UNKNOWN_STATE = new Integer(2);
    public static Integer REBUILDING_STATE = new Integer(3);

    private IPath getRubyPluginWorkingLocation() {
        IPath stateLocation;
        if (this.rubyPluginLocation != null) {
            return this.rubyPluginLocation;
        }
        this.rubyPluginLocation = stateLocation = RubyCore.getPlugin().getStateLocation();
        return this.rubyPluginLocation;
    }

    private File getSavedIndexesDirectory() {
        return new File(this.getRubyPluginWorkingLocation().toOSString());
    }

    public synchronized void jobWasCancelled(IPath containerPath) {
        IPath indexLocation = this.computeIndexLocation(containerPath);
        Index index = this.getIndex(indexLocation);
        if (index != null) {
            index.monitor = null;
            this.indexes.remove(indexLocation);
        }
        this.updateIndexState(indexLocation, UNKNOWN_STATE);
    }

    public IPath computeIndexLocation(IPath containerPath) {
        IPath indexLocation = (IPath)this.indexLocations.get(containerPath);
        if (indexLocation == null) {
            String pathString = containerPath.toOSString();
            checksumCalculator.reset();
            checksumCalculator.update(pathString.getBytes());
            String fileName = String.valueOf(Long.toString(checksumCalculator.getValue())) + ".index";
            if (VERBOSE) {
                org.rubypeople.rdt.internal.core.util.Util.verbose("-> index name for " + pathString + " is " + fileName);
            }
            indexLocation = (IPath)this.getIndexStates().getKey(this.getRubyPluginWorkingLocation().append(fileName));
            this.indexLocations.put(containerPath, indexLocation);
        }
        return indexLocation;
    }

    public synchronized Index getIndex(IPath indexLocation) {
        return this.indexes.get(indexLocation);
    }

    private SimpleLookupTable getIndexStates() {
        if (this.indexStates != null) {
            return this.indexStates;
        }
        this.indexStates = new SimpleLookupTable();
        IPath indexesDirectoryPath = this.getRubyPluginWorkingLocation();
        char[][] savedNames = this.readIndexState(indexesDirectoryPath.toOSString());
        if (savedNames != null) {
            int i = 1;
            int l = savedNames.length;
            while (i < l) {
                char[] savedName = savedNames[i];
                if (savedName.length > 0) {
                    IPath indexLocation = indexesDirectoryPath.append(new String(savedName));
                    if (VERBOSE) {
                        org.rubypeople.rdt.internal.core.util.Util.verbose("Reading saved index file " + indexLocation);
                    }
                    this.indexStates.put(indexLocation, SAVED_STATE);
                }
                ++i;
            }
        } else {
            this.deleteIndexFiles();
        }
        return this.indexStates;
    }

    public void deleteIndexFiles() {
        this.savedIndexNamesFile.delete();
        this.deleteIndexFiles(null);
    }

    private void deleteIndexFiles(SimpleSet pathsToKeep) {
        File[] indexesFiles = this.getSavedIndexesDirectory().listFiles();
        if (indexesFiles == null) {
            return;
        }
        int i = 0;
        int l = indexesFiles.length;
        while (i < l) {
            String fileName = indexesFiles[i].getAbsolutePath();
            if (pathsToKeep == null || !pathsToKeep.includes(fileName)) {
                String suffix = ".index";
                if (fileName.regionMatches(true, fileName.length() - suffix.length(), suffix, 0, suffix.length())) {
                    if (VERBOSE) {
                        org.rubypeople.rdt.internal.core.util.Util.verbose("Deleting index file " + indexesFiles[i]);
                    }
                    indexesFiles[i].delete();
                }
            }
            ++i;
        }
    }

    private synchronized void updateIndexState(IPath indexLocation, Integer indexState) {
        if (indexLocation.isEmpty()) {
            throw new IllegalArgumentException();
        }
        this.getIndexStates();
        if (indexState != null) {
            if (indexState.equals(this.indexStates.get(indexLocation))) {
                return;
            }
            this.indexStates.put(indexLocation, indexState);
        } else {
            if (!this.indexStates.containsKey(indexLocation)) {
                return;
            }
            this.indexStates.removeKey(indexLocation);
        }
        this.writeSavedIndexNamesFile();
        if (VERBOSE) {
            String state = "?";
            if (indexState == SAVED_STATE) {
                state = "SAVED";
            } else if (indexState == UPDATING_STATE) {
                state = "UPDATING";
            } else if (indexState == UNKNOWN_STATE) {
                state = "UNKNOWN";
            } else if (indexState == REBUILDING_STATE) {
                state = "REBUILDING";
            }
            org.rubypeople.rdt.internal.core.util.Util.verbose("-> index state updated to: " + state + " for: " + indexLocation);
        }
    }

    private void writeSavedIndexNamesFile() {
        block17: {
            BufferedWriter writer = null;
            try {
                try {
                    writer = new BufferedWriter(new FileWriter(this.savedIndexNamesFile));
                    writer.write("INDEX VERSION 1.125");
                    writer.write(43);
                    writer.write(this.getRubyPluginWorkingLocation().toOSString());
                    writer.write(10);
                    Object[] keys = this.indexStates.keyTable;
                    Object[] states = this.indexStates.valueTable;
                    int i = 0;
                    int l = states.length;
                    while (i < l) {
                        IPath key = (IPath)keys[i];
                        if (key != null && !key.isEmpty() && states[i] == SAVED_STATE) {
                            writer.write(key.lastSegment());
                            writer.write(10);
                        }
                        ++i;
                    }
                }
                catch (IOException iOException) {
                    if (VERBOSE) {
                        org.rubypeople.rdt.internal.core.util.Util.verbose("Failed to write saved index file names", System.err);
                    }
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (IOException iOException2) {}
                    }
                    break block17;
                }
            }
            catch (Throwable throwable) {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private char[][] readIndexState(String dirOSString) {
        block3: {
            try {
                String savedSignature;
                char[][] names;
                char[] savedIndexNames = Util.getFileCharContent(this.savedIndexNamesFile, null);
                if (savedIndexNames.length > 0 && (names = CharOperation.splitOn('\n', savedIndexNames)).length > 1 && (savedSignature = "INDEX VERSION 1.125+" + dirOSString).equals(new String(names[0]))) {
                    return names;
                }
            }
            catch (IOException iOException) {
                if (!VERBOSE) break block3;
                org.rubypeople.rdt.internal.core.util.Util.verbose("Failed to read saved index file names");
            }
        }
        return null;
    }

    public String processName() {
        return Messages.process_name;
    }

    public synchronized void aboutToUpdateIndex(IPath containerPath, Integer newIndexState) {
        Integer currentIndexState;
        IPath indexLocation = this.computeIndexLocation(containerPath);
        Object state = this.getIndexStates().get(indexLocation);
        Integer n = currentIndexState = state == null ? UNKNOWN_STATE : (Integer)state;
        if (currentIndexState.equals(REBUILDING_STATE)) {
            return;
        }
        int compare = newIndexState.compareTo(currentIndexState);
        if (compare > 0) {
            this.updateIndexState(indexLocation, newIndexState);
        } else if (compare < 0 && this.indexes.get(indexLocation) == null) {
            this.rebuildIndex(indexLocation, containerPath);
        }
    }

    private void rebuildIndex(IPath indexLocation, IPath containerPath) {
        Object target = RubyModel.getTarget(containerPath, true);
        if (target == null) {
            return;
        }
        if (VERBOSE) {
            org.rubypeople.rdt.internal.core.util.Util.verbose("-> request to rebuild index: " + indexLocation + " path: " + containerPath);
        }
        this.updateIndexState(indexLocation, REBUILDING_STATE);
        IndexRequest request = null;
        if (target instanceof IProject) {
            IProject p = (IProject)target;
            if (RubyProject.hasRubyNature(p)) {
                request = new IndexAllProject(p, this);
            }
        } else if (target instanceof File) {
            request = new AddExternalFolderToIndex(containerPath, this);
        }
        if (request != null) {
            this.request(request);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveIndex(Index index) throws IOException {
        if (index.hasChanged()) {
            if (VERBOSE) {
                org.rubypeople.rdt.internal.core.util.Util.verbose("-> saving index " + index.getIndexFile());
            }
            index.save();
        }
        IndexManager indexManager = this;
        synchronized (indexManager) {
            Path containerPath = new Path(index.containerPath);
            if (this.jobEnd > this.jobStart) {
                int i = this.jobEnd;
                while (i > this.jobStart) {
                    IJob job = this.awaitingJobs[i];
                    if (job instanceof IndexRequest && ((IndexRequest)job).containerPath.equals((Object)containerPath)) {
                        return;
                    }
                    --i;
                }
            }
            IPath indexLocation = this.computeIndexLocation((IPath)containerPath);
            this.updateIndexState(indexLocation, SAVED_STATE);
        }
    }

    public synchronized Index getIndexForUpdate(IPath containerPath, boolean reuseExistingFile, boolean createIfMissing) {
        IPath indexLocation = this.computeIndexLocation(containerPath);
        if (this.getIndexStates().get(indexLocation) == REBUILDING_STATE) {
            return this.getIndex(containerPath, indexLocation, reuseExistingFile, createIfMissing);
        }
        return null;
    }

    public synchronized Index getIndex(IPath containerPath, IPath indexLocation, boolean reuseExistingFile, boolean createIfMissing) {
        Index index = this.getIndex(indexLocation);
        if (index == null) {
            Integer currentIndexState;
            Object state = this.getIndexStates().get(indexLocation);
            Integer n = currentIndexState = state == null ? UNKNOWN_STATE : (Integer)state;
            if (currentIndexState == UNKNOWN_STATE) {
                this.rebuildIndex(indexLocation, containerPath);
                return null;
            }
            String containerPathString = containerPath.getDevice() == null ? containerPath.toString() : containerPath.toOSString();
            String indexLocationString = indexLocation.toOSString();
            if (reuseExistingFile) {
                block13: {
                    File indexFile = new File(indexLocationString);
                    if (indexFile.exists()) {
                        try {
                            index = new Index(indexLocationString, containerPathString, true);
                            this.indexes.put(indexLocation, index);
                            return index;
                        }
                        catch (IOException iOException) {
                            if (currentIndexState == REBUILDING_STATE) break block13;
                            if (VERBOSE) {
                                org.rubypeople.rdt.internal.core.util.Util.verbose("-> cannot reuse existing index: " + indexLocationString + " path: " + containerPathString);
                            }
                            this.rebuildIndex(indexLocation, containerPath);
                            return null;
                        }
                    }
                }
                if (currentIndexState == SAVED_STATE) {
                    this.rebuildIndex(indexLocation, containerPath);
                    return null;
                }
            }
            if (createIfMissing) {
                try {
                    if (VERBOSE) {
                        org.rubypeople.rdt.internal.core.util.Util.verbose("-> create empty index: " + indexLocationString + " path: " + containerPathString);
                    }
                    index = new Index(indexLocationString, containerPathString, false);
                    this.indexes.put(indexLocation, index);
                    return index;
                }
                catch (IOException iOException) {
                    if (VERBOSE) {
                        org.rubypeople.rdt.internal.core.util.Util.verbose("-> unable to create empty index: " + indexLocationString + " path: " + containerPathString);
                    }
                    return null;
                }
            }
        }
        return index;
    }

    public synchronized void removeIndex(IPath containerPath) {
        if (VERBOSE) {
            org.rubypeople.rdt.internal.core.util.Util.verbose("removing index " + containerPath);
        }
        IPath indexLocation = this.computeIndexLocation(containerPath);
        Index index = this.getIndex(indexLocation);
        File indexFile = null;
        if (index != null) {
            index.monitor = null;
            indexFile = index.getIndexFile();
        }
        if (indexFile == null) {
            indexFile = new File(indexLocation.toOSString());
        }
        if (indexFile.exists()) {
            indexFile.delete();
        }
        this.indexes.remove(indexLocation);
        this.updateIndexState(indexLocation, null);
    }

    public void remove(String containerRelativePath, IPath indexedContainer) {
        this.request(new RemoveFromIndex(containerRelativePath, indexedContainer, this));
    }

    public synchronized Index getIndex(IPath containerPath, boolean reuseExistingFile, boolean createIfMissing) {
        IPath indexLocation = this.computeIndexLocation(containerPath);
        return this.getIndex(containerPath, indexLocation, reuseExistingFile, createIfMissing);
    }

    public void addSource(IFile resource, IPath containerPath, SourceElementParser parser) {
        if (RubyCore.getPlugin() == null) {
            return;
        }
        SearchParticipant participant = BasicSearchEngine.getDefaultSearchParticipant();
        SearchDocument document = participant.getDocument(resource.getFullPath().toString());
        document.parser = parser;
        IPath indexLocation = this.computeIndexLocation(containerPath);
        this.scheduleDocumentIndexing(document, containerPath, indexLocation, participant);
    }

    public void scheduleDocumentIndexing(final SearchDocument searchDocument, IPath container, final IPath indexLocation, final SearchParticipant searchParticipant) {
        this.request(new IndexRequest(container, this){

            public boolean execute(IProgressMonitor progressMonitor) {
                if (this.isCancelled || progressMonitor != null && progressMonitor.isCanceled()) {
                    return true;
                }
                Index index = IndexManager.this.getIndex(this.containerPath, indexLocation, true, true);
                if (index == null) {
                    return true;
                }
                ReadWriteMonitor monitor = index.monitor;
                if (monitor == null) {
                    return true;
                }
                try {
                    monitor.enterWrite();
                    IndexManager.this.indexDocument(searchDocument, searchParticipant, index, indexLocation);
                }
                finally {
                    monitor.exitWrite();
                }
                return true;
            }

            public String toString() {
                return "indexing " + searchDocument.getPath();
            }
        });
    }

    public void indexDocument(SearchDocument searchDocument, SearchParticipant searchParticipant, Index index, IPath indexLocation) {
        try {
            searchDocument.index = index;
            searchParticipant.indexDocument(searchDocument, indexLocation);
        }
        finally {
            searchDocument.index = null;
        }
    }

    public void cleanUpIndexes() {
        SimpleSet knownPaths = new SimpleSet();
        IRubySearchScope scope = BasicSearchEngine.createWorkspaceScope();
        PatternSearchJob job = new PatternSearchJob(null, BasicSearchEngine.getDefaultSearchParticipant(), scope, null);
        Index[] selectedIndexes = job.getIndexes(null);
        int i = 0;
        int l = selectedIndexes.length;
        while (i < l) {
            String path = selectedIndexes[i].getIndexFile().getAbsolutePath();
            knownPaths.add(path);
            ++i;
        }
        if (this.indexStates != null) {
            Object[] keys = this.indexStates.keyTable;
            IPath[] locations = new IPath[this.indexStates.elementSize];
            int count = 0;
            int i2 = 0;
            int l2 = keys.length;
            while (i2 < l2) {
                IPath key = (IPath)keys[i2];
                if (key != null && !knownPaths.includes(key.toOSString())) {
                    locations[count++] = key;
                }
                ++i2;
            }
            if (count > 0) {
                this.removeIndexesState(locations);
            }
        }
        this.deleteIndexFiles(knownPaths);
    }

    private synchronized void removeIndexesState(IPath[] locations) {
        this.getIndexStates();
        int length = locations.length;
        boolean changed = false;
        int i = 0;
        while (i < length) {
            if (locations[i] != null && this.indexStates.removeKey(locations[i]) != null) {
                changed = true;
                if (VERBOSE) {
                    org.rubypeople.rdt.internal.core.util.Util.verbose("-> index state updated to: ? for: " + locations[i]);
                }
            }
            ++i;
        }
        if (!changed) {
            return;
        }
        this.writeSavedIndexNamesFile();
    }

    public SourceElementParser getSourceElementParser(IRubyProject project, ISourceElementRequestor requestor) {
        return new SourceElementParser(requestor);
    }

    public void indexLibrary(IPath path, IProject project) {
        if (RubyCore.getPlugin() == null) {
            return;
        }
        Object target = RubyModel.getTarget(path, true);
        AddExternalFolderToIndex request = null;
        if (target instanceof File) {
            if (!((File)target).isDirectory()) {
                return;
            }
        } else {
            return;
        }
        request = new AddExternalFolderToIndex(path, this);
        if (!this.isJobWaiting(request)) {
            this.request(request);
        }
    }

    public void indexAll(IProject project) {
        if (RubyCore.getPlugin() == null) {
            return;
        }
        try {
            RubyModel model = RubyModelManager.getRubyModelManager().getRubyModel();
            RubyProject javaProject = (RubyProject)model.getRubyProject((IResource)project);
            ILoadpathEntry[] entries = javaProject.getResolvedLoadpath(true, false, false);
            int i = 0;
            while (i < entries.length) {
                ILoadpathEntry entry = entries[i];
                if (entry.getEntryKind() == 1) {
                    this.indexLibrary(entry.getPath(), project);
                }
                ++i;
            }
        }
        catch (RubyModelException rubyModelException) {}
        IndexAllProject request = new IndexAllProject(project, this);
        if (!this.isJobWaiting(request)) {
            this.request(request);
        }
    }

    public synchronized void removeIndexFamily(IPath path) {
        ArrayList<IPath> toRemove = null;
        Object[] containerPaths = this.indexLocations.keyTable;
        int i = 0;
        int length = containerPaths.length;
        while (i < length) {
            IPath containerPath = (IPath)containerPaths[i];
            if (containerPath != null && path.isPrefixOf(containerPath)) {
                if (toRemove == null) {
                    toRemove = new ArrayList<IPath>();
                }
                toRemove.add(containerPath);
            }
            ++i;
        }
        if (toRemove != null) {
            i = 0;
            length = toRemove.size();
            while (i < length) {
                this.removeIndex((IPath)toRemove.get(i));
                ++i;
            }
        }
    }

    public synchronized Index recreateIndex(IPath containerPath) {
        String containerPathString = containerPath.getDevice() == null ? containerPath.toString() : containerPath.toOSString();
        try {
            ReadWriteMonitor monitor;
            IPath indexLocation = this.computeIndexLocation(containerPath);
            Index index = this.indexes.get(indexLocation);
            ReadWriteMonitor readWriteMonitor = monitor = index == null ? null : index.monitor;
            if (VERBOSE) {
                org.rubypeople.rdt.internal.core.util.Util.verbose("-> recreating index: " + indexLocation + " for path: " + containerPathString);
            }
            index = new Index(indexLocation.toString(), containerPathString, false);
            this.indexes.put(indexLocation, index);
            index.monitor = monitor;
            return index;
        }
        catch (IOException e) {
            if (VERBOSE) {
                org.rubypeople.rdt.internal.core.util.Util.verbose("-> failed to recreate index for path: " + containerPathString);
                e.printStackTrace();
            }
            return null;
        }
    }

    public void removeSourceFolderFromIndex(RubyProject javaProject, IPath sourceFolder, char[][] inclusionPatterns, char[][] exclusionPatterns) {
        IndexAllProject request;
        IProject project = javaProject.getProject();
        if (this.jobEnd > this.jobStart && this.isJobWaiting(request = new IndexAllProject(project, this))) {
            return;
        }
        this.request(new RemoveFolderFromIndex(sourceFolder, inclusionPatterns, exclusionPatterns, project, this));
    }

    public void indexSourceFolder(RubyProject javaProject, IPath sourceFolder, char[][] inclusionPatterns, char[][] exclusionPatterns) {
        IndexAllProject request;
        IProject project = javaProject.getProject();
        if (this.jobEnd > this.jobStart && this.isJobWaiting(request = new IndexAllProject(project, this))) {
            return;
        }
        this.request(new AddFolderToIndex(sourceFolder, project, inclusionPatterns, exclusionPatterns, this));
    }

    public synchronized void reset() {
        super.reset();
        if (this.indexes != null) {
            this.indexes = new HashMap<IPath, Index>(5);
            this.indexStates = null;
        }
        this.indexLocations = new SimpleLookupTable();
        this.rubyPluginLocation = null;
    }
}

