/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.core.search.indexing;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.rubypeople.rdt.core.search.SearchParticipant;
import org.rubypeople.rdt.internal.compiler.util.SimpleLookupTable;
import org.rubypeople.rdt.internal.core.RubyModelManager;
import org.rubypeople.rdt.internal.core.index.Index;
import org.rubypeople.rdt.internal.core.search.BasicSearchEngine;
import org.rubypeople.rdt.internal.core.search.ERBSearchDocument;
import org.rubypeople.rdt.internal.core.search.RubySearchDocument;
import org.rubypeople.rdt.internal.core.search.indexing.IndexManager;
import org.rubypeople.rdt.internal.core.search.indexing.IndexRequest;
import org.rubypeople.rdt.internal.core.search.indexing.ReadWriteMonitor;
import org.rubypeople.rdt.internal.core.search.processing.JobManager;
import org.rubypeople.rdt.internal.core.util.Util;

public class AddExternalFolderToIndex
extends IndexRequest {
    public AddExternalFolderToIndex(IPath containerPath, IndexManager manager) {
        super(containerPath, manager);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean execute(IProgressMonitor progressMonitor) {
        if (this.isCancelled) return true;
        if (progressMonitor != null && progressMonitor.isCanceled()) {
            return true;
        }
        try {
            Index index = this.manager.getIndexForUpdate(this.containerPath, false, false);
            if (index != null) {
                if (!JobManager.VERBOSE) return true;
                Util.verbose("-> no indexing required (index already exists) for " + this.containerPath);
                return true;
            }
            index = this.manager.getIndexForUpdate(this.containerPath, true, true);
            if (index == null) {
                if (!JobManager.VERBOSE) return true;
                Util.verbose("-> index could not be created for " + this.containerPath);
                return true;
            }
            ReadWriteMonitor monitor = index.monitor;
            if (monitor == null) {
                if (!JobManager.VERBOSE) return true;
                Util.verbose("-> index for " + this.containerPath + " just got deleted");
                return true;
            }
            File file = null;
            try {
                monitor.enterWrite();
                if (RubyModelManager.ZIP_ACCESS_VERBOSE) {
                    System.out.println("(" + Thread.currentThread() + ") [AddJarFileToIndex.execute()] Creating ZipFile on " + this.containerPath);
                }
                file = this.containerPath.toFile();
                if (this.isCancelled) {
                    if (!JobManager.VERBOSE) return false;
                    Util.verbose("-> indexing of " + file.getName() + " has been cancelled");
                    return false;
                }
                if (JobManager.VERBOSE) {
                    Util.verbose("-> indexing " + file.getName());
                }
                long initialTime = System.currentTimeMillis();
                String[] paths = index.queryDocumentNames("");
                if (paths != null) {
                    boolean needToReindex;
                    int max = paths.length;
                    String EXISTS = "OK";
                    String DELETED = "DELETED";
                    SimpleLookupTable indexedFileNames = new SimpleLookupTable(max == 0 ? 33 : max + 11);
                    int i = 0;
                    while (true) {
                        if (i >= max) {
                            this.addDirectorysChildren(file, EXISTS, indexedFileNames);
                            boolean bl = needToReindex = indexedFileNames.elementSize != max;
                        }
                        indexedFileNames.put(paths[i], DELETED);
                        ++i;
                    }
                    if (!needToReindex) {
                        Object[] valueTable = indexedFileNames.valueTable;
                        int i2 = 0;
                        int l = valueTable.length;
                        while (i2 < l) {
                            if (valueTable[i2] == DELETED) {
                                needToReindex = true;
                                break;
                            }
                            ++i2;
                        }
                        if (!needToReindex) {
                            if (JobManager.VERBOSE) {
                                Util.verbose("-> no indexing required (index is consistent with library) for " + file.getName() + " (" + (System.currentTimeMillis() - initialTime) + "ms)");
                            }
                            this.manager.saveIndex(index);
                            return true;
                        }
                    }
                }
                SearchParticipant participant = BasicSearchEngine.getDefaultSearchParticipant();
                index = this.manager.recreateIndex(this.containerPath);
                if (index == null) {
                    this.manager.removeIndex(this.containerPath);
                    return false;
                }
                if (!this.indexFiles(index, file, participant)) {
                    return false;
                }
                this.manager.saveIndex(index);
                if (!JobManager.VERBOSE) return true;
                Util.verbose("-> done indexing of " + file.getName() + " (" + (System.currentTimeMillis() - initialTime) + "ms)");
                return true;
            }
            finally {
                monitor.exitWrite();
            }
        }
        catch (IOException e) {
            if (JobManager.VERBOSE) {
                Util.verbose("-> failed to index " + this.containerPath + " because of the following exception:");
                e.printStackTrace();
            }
            this.manager.removeIndex(this.containerPath);
            return false;
        }
    }

    private boolean indexFiles(Index index, File file, SearchParticipant participant) throws FileNotFoundException, IOException {
        File[] children = file.listFiles();
        if (children == null) {
            return true;
        }
        int i = 0;
        while (i < children.length) {
            if (this.isCancelled) {
                if (JobManager.VERBOSE) {
                    Util.verbose("-> indexing of " + file.getName() + " has been cancelled");
                }
                return false;
            }
            String name = children[i].getName();
            if (children[i].isFile() && Util.isRubyOrERBLikeFileName(name)) {
                FileInputStream stream = new FileInputStream(children[i]);
                char[] contents = Util.getInputStreamAsCharArray(stream, -1, null);
                RubySearchDocument entryDocument = Util.isERBLikeFileName(name) ? new ERBSearchDocument(children[i].getAbsolutePath(), contents, participant) : new RubySearchDocument(children[i].getAbsolutePath(), contents, participant);
                this.manager.indexDocument(entryDocument, participant, index, this.containerPath);
            }
            if (!this.indexFiles(index, children[i], participant)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void addDirectorysChildren(File file, String EXISTS, SimpleLookupTable indexedFileNames) {
        File[] children = file.listFiles();
        if (children == null) {
            return;
        }
        int i = 0;
        while (i < children.length) {
            String name = children[i].getName();
            if (Util.isRubyOrERBLikeFileName(name)) {
                indexedFileNames.put(name, EXISTS);
            }
            this.addDirectorysChildren(children[i], EXISTS, indexedFileNames);
            ++i;
        }
    }

    protected Integer updatedIndexState() {
        return IndexManager.REBUILDING_STATE;
    }

    public String toString() {
        return "indexing " + this.containerPath.toString();
    }

    public boolean equals(Object o) {
        if (o instanceof AddExternalFolderToIndex && this.containerPath != null) {
            return this.containerPath.equals((Object)((AddExternalFolderToIndex)o).containerPath);
        }
        return false;
    }

    public int hashCode() {
        if (this.containerPath != null) {
            return this.containerPath.hashCode();
        }
        return -1;
    }
}

