/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.core.search;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.rubypeople.rdt.core.IField;
import org.rubypeople.rdt.core.ILoadpathContainer;
import org.rubypeople.rdt.core.ILoadpathEntry;
import org.rubypeople.rdt.core.IMember;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyElementDelta;
import org.rubypeople.rdt.core.IRubyModel;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.core.ISourceFolderRoot;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.core.search.IRubySearchScope;
import org.rubypeople.rdt.internal.core.LoadpathEntry;
import org.rubypeople.rdt.internal.core.RubyModelManager;
import org.rubypeople.rdt.internal.core.RubyProject;
import org.rubypeople.rdt.internal.core.SourceFolder;
import org.rubypeople.rdt.internal.core.search.AbstractSearchScope;
import org.rubypeople.rdt.internal.core.util.Util;

public class RubySearchScope
extends AbstractSearchScope
implements IRubySearchScope {
    private List<IRubyElement> elements;
    private ArrayList<String> projectPaths = new ArrayList();
    private int[] projectIndexes;
    private String[] containerPaths;
    private String[] relativePaths;
    private boolean[] isPkgPath;
    private int pathsCount;
    private int threshold;
    private IPath[] enclosingProjectsAndJars;

    public RubySearchScope() {
        this(5);
    }

    private RubySearchScope(int size) {
        this.initialize(size);
    }

    protected void initialize(int size) {
        this.pathsCount = 0;
        this.threshold = size;
        int extraRoom = (int)((float)size * 1.75f);
        if (this.threshold == extraRoom) {
            ++extraRoom;
        }
        this.relativePaths = new String[extraRoom];
        this.containerPaths = new String[extraRoom];
        this.projectPaths = new ArrayList();
        this.projectIndexes = new int[extraRoom];
        this.isPkgPath = new boolean[extraRoom];
        this.enclosingProjectsAndJars = new IPath[0];
    }

    public boolean encloses(String resourcePathString) {
        int index1 = this.indexOf(resourcePathString);
        if (index1 >= 0) {
            return true;
        }
        int i = 0;
        while (i < this.containerPaths.length) {
            String containerPath = this.containerPaths[i];
            if (containerPath != null && resourcePathString.startsWith(containerPath)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private int indexOf(String fullPath) {
        int i = 0;
        int length = this.relativePaths.length;
        while (i < length) {
            String currentRelativePath = this.relativePaths[i];
            if (currentRelativePath != null) {
                String currentFullPath;
                String currentContainerPath = this.containerPaths[i];
                String string = currentFullPath = currentRelativePath.length() == 0 ? currentContainerPath : String.valueOf(currentContainerPath) + '/' + currentRelativePath;
                if (this.encloses(currentFullPath, fullPath, i)) {
                    return i;
                }
            }
            ++i;
        }
        return -1;
    }

    private boolean encloses(String enclosingPath, String path, int index) {
        int enclosingLength;
        int pathLength = (path = this.normalize(path)).length();
        if (pathLength < (enclosingLength = enclosingPath.length())) {
            return false;
        }
        if (enclosingLength == 0) {
            return true;
        }
        if (pathLength == enclosingLength) {
            return path.equals(enclosingPath);
        }
        if (!this.isPkgPath[index]) {
            return path.startsWith(enclosingPath) && path.charAt(enclosingLength) == '/';
        }
        return path.startsWith(enclosingPath) && (enclosingPath.length() == path.lastIndexOf(47) || enclosingPath.length() == path.length());
    }

    private void add(String projectPath, String relativePath, String containerPath, boolean isPackage) {
        String currentContainerPath;
        String currentRelativePath;
        containerPath = this.normalize(containerPath);
        relativePath = this.normalize(relativePath);
        int length = this.containerPaths.length;
        int index = (containerPath.hashCode() & Integer.MAX_VALUE) % length;
        while ((currentRelativePath = this.relativePaths[index]) != null && (currentContainerPath = this.containerPaths[index]) != null) {
            if (currentRelativePath.equals(relativePath) && currentContainerPath.equals(containerPath)) {
                return;
            }
            if (++index != length) continue;
            index = 0;
        }
        int idx = this.projectPaths.indexOf(projectPath);
        if (idx == -1) {
            this.projectPaths.add(projectPath);
            idx = this.projectPaths.indexOf(projectPath);
        }
        this.projectIndexes[index] = idx;
        this.relativePaths[index] = relativePath;
        this.containerPaths[index] = containerPath;
        this.isPkgPath[index] = isPackage;
        if (++this.pathsCount > this.threshold) {
            this.rehash();
        }
    }

    void add(RubyProject rubyProject, IPath pathToAdd, int includeMask, HashSet visitedProjects, ILoadpathEntry referringEntry) throws RubyModelException {
        IProject project = rubyProject.getProject();
        if (!project.isAccessible() || !visitedProjects.add(project)) {
            return;
        }
        IPath projectPath = project.getFullPath();
        String projectPathString = projectPath.toString();
        this.addEnclosingProjectOrJar(projectPath);
        ILoadpathEntry[] entries = rubyProject.getResolvedLoadpath(true);
        IRubyModel model = rubyProject.getRubyModel();
        RubyModelManager.PerProjectInfo perProjectInfo = rubyProject.getPerProjectInfo();
        int i = 0;
        int length = entries.length;
        while (i < length) {
            block16: {
                LoadpathEntry cpEntry;
                ILoadpathEntry entry;
                block15: {
                    entry = entries[i];
                    cpEntry = (LoadpathEntry)entry;
                    if (referringEntry == null) break block15;
                    if (!entry.isExported() && entry.getEntryKind() != 3) break block16;
                    cpEntry = cpEntry.combineWith((LoadpathEntry)referringEntry);
                }
                block0 : switch (entry.getEntryKind()) {
                    case 1: {
                        IPath path;
                        ILoadpathEntry rawEntry = null;
                        Map resolvedPathToRawEntries = perProjectInfo.resolvedPathToRawEntries;
                        if (resolvedPathToRawEntries != null) {
                            rawEntry = (ILoadpathEntry)resolvedPathToRawEntries.get(entry.getPath());
                        }
                        if (rawEntry == null) break;
                        switch (rawEntry.getEntryKind()) {
                            case 1: 
                            case 4: {
                                if ((includeMask & 2) == 0) break;
                                path = entry.getPath();
                                if (pathToAdd != null && !pathToAdd.equals((Object)path)) break block0;
                                String pathToString = path.getDevice() == null ? path.toString() : path.toOSString();
                                this.add(projectPath.toString(), "", pathToString, false);
                                this.addEnclosingProjectOrJar(path);
                                break;
                            }
                            case 5: {
                                ILoadpathContainer container = RubyCore.getLoadpathContainer(rawEntry.getPath(), rubyProject);
                                if (container == null || (container.getKind() != 1 || (includeMask & 2) == 0) && (includeMask & 4) == 0) break block0;
                                IPath path2 = entry.getPath();
                                if (pathToAdd != null && !pathToAdd.equals((Object)path2)) break block0;
                                String pathToString = path2.getDevice() == null ? path2.toString() : path2.toOSString();
                                this.add(projectPath.toString(), "", pathToString, false);
                                this.addEnclosingProjectOrJar(path2);
                            }
                        }
                        break;
                    }
                    case 2: {
                        if ((includeMask & 8) == 0) break;
                        IPath path = entry.getPath();
                        if (pathToAdd != null && !pathToAdd.equals((Object)path)) break;
                        this.add((RubyProject)model.getRubyProject(entry.getPath().lastSegment()), null, includeMask, visitedProjects, cpEntry);
                        break;
                    }
                    case 3: {
                        if ((includeMask & 1) == 0) break;
                        IPath path = entry.getPath();
                        if (pathToAdd != null && !pathToAdd.equals((Object)path)) break;
                        this.add(projectPath.toString(), Util.relativePath(path, 1), projectPathString, false);
                    }
                }
            }
            ++i;
        }
    }

    private void addEnclosingProjectOrJar(IPath path) {
        int length = this.enclosingProjectsAndJars.length;
        int i = 0;
        while (i < length) {
            if (this.enclosingProjectsAndJars[i].equals((Object)path)) {
                return;
            }
            ++i;
        }
        this.enclosingProjectsAndJars = new IPath[length + 1];
        System.arraycopy(this.enclosingProjectsAndJars, 0, this.enclosingProjectsAndJars, 0, length);
        this.enclosingProjectsAndJars[length] = path;
    }

    private String normalize(String path) {
        int pathLength = path.length();
        int index = pathLength - 1;
        while (index >= 0 && path.charAt(index) == '/') {
            --index;
        }
        if (index != pathLength - 1) {
            return path.substring(0, index + 1);
        }
        return path;
    }

    private void rehash() {
        RubySearchScope newScope = new RubySearchScope(this.pathsCount * 2);
        newScope.projectPaths.ensureCapacity(this.projectPaths.size());
        int i = this.relativePaths.length;
        while (--i >= 0) {
            String currentPath = this.relativePaths[i];
            if (currentPath == null) continue;
            int idx = this.projectIndexes[i];
            String projectPath = idx == -1 ? null : this.projectPaths.get(idx);
            newScope.add(projectPath, currentPath, this.containerPaths[i], this.isPkgPath[i]);
        }
        this.relativePaths = newScope.relativePaths;
        this.containerPaths = newScope.containerPaths;
        this.projectPaths = newScope.projectPaths;
        this.projectIndexes = newScope.projectIndexes;
        this.isPkgPath = newScope.isPkgPath;
        this.threshold = newScope.threshold;
    }

    public IPath[] enclosingProjectsAndJars() {
        return this.enclosingProjectsAndJars;
    }

    public void add(RubyProject project, int includeMask, HashSet visitedProject) throws RubyModelException {
        this.add(project, null, includeMask, visitedProject, null);
    }

    public void add(IRubyElement element) throws RubyModelException {
        IPath containerPath = null;
        String containerPathToString = null;
        int includeMask = 7;
        switch (element.getElementType()) {
            case 0: {
                break;
            }
            case 1: {
                this.add((RubyProject)element, null, includeMask, new HashSet(2), null);
                break;
            }
            case 2: {
                ISourceFolderRoot root = (ISourceFolderRoot)element;
                containerPath = root.getPath();
                containerPathToString = containerPath.getDevice() == null ? containerPath.toString() : containerPath.toOSString();
                IResource rootResource = root.getResource();
                if (rootResource != null && rootResource.isAccessible()) {
                    String relativePath = Util.relativePath(rootResource.getFullPath(), containerPath.segmentCount());
                    this.add(relativePath, containerPathToString, false);
                    break;
                }
                this.add("", containerPathToString, false);
                break;
            }
            case 3: {
                ISourceFolderRoot root = (ISourceFolderRoot)element.getParent();
                if (root.isExternal()) {
                    String relativePath = Util.concatWith(((SourceFolder)element).names, '/');
                    containerPath = root.getPath();
                    containerPathToString = containerPath.getDevice() == null ? containerPath.toString() : containerPath.toOSString();
                    this.add(relativePath, containerPathToString, true);
                    break;
                }
                IResource resource = element.getResource();
                if (resource == null) break;
                containerPath = resource.isAccessible() ? root.getParent().getPath() : resource.getParent().getFullPath();
                containerPathToString = containerPath.getDevice() == null ? containerPath.toString() : containerPath.toOSString();
                String relativePath = Util.relativePath(resource.getFullPath(), containerPath.segmentCount());
                this.add(relativePath, containerPathToString, true);
                break;
            }
            default: {
                if (element instanceof IMember) {
                    if (this.elements == null) {
                        this.elements = new ArrayList<IRubyElement>();
                    }
                    this.elements.add(element);
                }
                ISourceFolderRoot root = (ISourceFolderRoot)element.getAncestor(2);
                containerPath = root.getPath();
                String relativePath = Util.relativePath(this.getPath(element, true), 0);
                containerPathToString = containerPath.getDevice() == null ? containerPath.toString() : containerPath.toOSString();
                this.add(relativePath, containerPathToString, false);
            }
        }
        if (containerPath != null) {
            this.addEnclosingProjectOrJar(containerPath);
        }
    }

    private void add(String relativePath, String containerPath, boolean isPackage) {
        String currentContainerPath;
        String currentRelativePath;
        containerPath = this.normalize(containerPath);
        relativePath = this.normalize(relativePath);
        int length = this.containerPaths.length;
        int index = (containerPath.hashCode() & Integer.MAX_VALUE) % length;
        while ((currentRelativePath = this.relativePaths[index]) != null && (currentContainerPath = this.containerPaths[index]) != null) {
            if (currentRelativePath.equals(relativePath) && currentContainerPath.equals(containerPath)) {
                return;
            }
            if (++index != length) continue;
            index = 0;
        }
        this.relativePaths[index] = relativePath;
        this.containerPaths[index] = containerPath;
        this.isPkgPath[index] = isPackage;
        if (++this.pathsCount > this.threshold) {
            this.rehash();
        }
    }

    private IPath getPath(IRubyElement element, boolean relativeToRoot) {
        switch (element.getElementType()) {
            case 0: {
                return Path.EMPTY;
            }
            case 1: {
                return element.getPath();
            }
            case 2: {
                if (relativeToRoot) {
                    return Path.EMPTY;
                }
                return element.getPath();
            }
            case 3: {
                String relativePath = Util.concatWith(((SourceFolder)element).names, '/');
                return this.getPath(element.getParent(), relativeToRoot).append((IPath)new Path(relativePath));
            }
            case 4: {
                return this.getPath(element.getParent(), relativeToRoot).append((IPath)new Path(element.getElementName()));
            }
        }
        return this.getPath(element.getParent(), relativeToRoot);
    }

    public boolean encloses(IRubyElement element) {
        if (this.elements != null) {
            int i = 0;
            int length = this.elements.size();
            while (i < length) {
                IRubyElement scopeElement = this.elements.get(i);
                if (element instanceof IField) {
                    scopeElement = element.isType(7) ? scopeElement.getAncestor(4) : scopeElement.getAncestor(5);
                }
                IRubyElement searchedElement = element;
                while (searchedElement != null) {
                    if (searchedElement.equals(scopeElement)) {
                        return true;
                    }
                    searchedElement = searchedElement.getParent();
                }
                ++i;
            }
            return false;
        }
        ISourceFolderRoot root = (ISourceFolderRoot)element.getAncestor(2);
        if (root != null && root.isExternal()) {
            IPath relativePath;
            IPath rootPath = root.getPath();
            String rootPathToString = rootPath.getDevice() == null ? rootPath.toString() : rootPath.toOSString();
            return this.indexOf(rootPathToString, (relativePath = this.getPath(element, true)).toString()) >= 0;
        }
        String fullResourcePathString = this.getPath(element, false).toString();
        return this.indexOf(fullResourcePathString) >= 0;
    }

    private int indexOf(String containerPath, String relativePath) {
        String currentContainerPath;
        int length = this.containerPaths.length;
        int index = (containerPath.hashCode() & Integer.MAX_VALUE) % length;
        while ((currentContainerPath = this.containerPaths[index]) != null) {
            String currentRelativePath;
            if (currentContainerPath.equals(containerPath) && this.encloses(currentRelativePath = this.relativePaths[index], relativePath, index)) {
                return index;
            }
            if (++index != length) continue;
            index = 0;
        }
        return -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void processDelta(IRubyElementDelta delta, int eventType) {
        switch (delta.getKind()) {
            case 4: {
                IRubyElementDelta[] children = delta.getAffectedChildren();
                int i = 0;
                int length = children.length;
                while (i < length) {
                    IRubyElementDelta child = children[i];
                    this.processDelta(child, eventType);
                    ++i;
                }
                return;
            }
            case 2: {
                IRubyElement element = delta.getElement();
                if (!this.encloses(element)) return;
                if (this.elements != null) {
                    this.elements.remove(element);
                }
                IPath path = null;
                switch (element.getElementType()) {
                    case 1: {
                        path = ((IRubyProject)element).getProject().getFullPath();
                    }
                    case 2: {
                        if (path == null) {
                            path = ((ISourceFolderRoot)element).getPath();
                        }
                        int toRemove = -1;
                        int i = 0;
                        while (i < this.pathsCount) {
                            if (this.relativePaths[i].equals(path)) {
                                toRemove = i;
                                break;
                            }
                            ++i;
                        }
                        if (toRemove == -1) return;
                        this.relativePaths[toRemove] = null;
                        this.rehash();
                    }
                }
            }
        }
    }
}

