/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.core.search;

import org.eclipse.core.runtime.IPath;
import org.rubypeople.rdt.core.ILoadpathEntry;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyModel;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.core.search.IRubySearchScope;
import org.rubypeople.rdt.core.search.SearchPattern;
import org.rubypeople.rdt.internal.compiler.util.SimpleSet;
import org.rubypeople.rdt.internal.core.ExternalSourceFolderRoot;
import org.rubypeople.rdt.internal.core.RubyModel;
import org.rubypeople.rdt.internal.core.RubyModelManager;
import org.rubypeople.rdt.internal.core.RubyProject;
import org.rubypeople.rdt.internal.core.search.indexing.IndexManager;
import org.rubypeople.rdt.internal.core.search.matching.MatchLocator;
import org.rubypeople.rdt.internal.core.search.matching.MethodPattern;

public class IndexSelector {
    IRubySearchScope searchScope;
    SearchPattern pattern;
    IPath[] indexLocations;

    public IndexSelector(IRubySearchScope searchScope, SearchPattern pattern) {
        this.searchScope = searchScope;
        this.pattern = pattern;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean canSeeFocus(IRubyElement focus, boolean isPolymorphicSearch, IPath projectOrJarPath) {
        try {
            IRubyModel model;
            IRubyProject project;
            ILoadpathEntry[] focusEntries = null;
            if (isPolymorphicSearch) {
                RubyProject focusProject = (RubyProject)focus;
                focusEntries = focusProject.getExpandedLoadpath(true);
            }
            if ((project = IndexSelector.getRubyProject(projectOrJarPath, model = focus.getRubyModel())) != null) {
                return IndexSelector.canSeeFocus(focus, (RubyProject)project, focusEntries);
            }
            IRubyProject[] allProjects = model.getRubyProjects();
            int i = 0;
            int length = allProjects.length;
            block2: while (true) {
                if (i >= length) {
                    return false;
                }
                RubyProject otherProject = (RubyProject)allProjects[i];
                ILoadpathEntry[] entries = otherProject.getResolvedLoadpath(true);
                int j = 0;
                int length2 = entries.length;
                while (true) {
                    if (j >= length2) {
                        ++i;
                        continue block2;
                    }
                    ILoadpathEntry entry = entries[j];
                    if (entry.getEntryKind() == 1 && entry.getPath().equals((Object)projectOrJarPath) && IndexSelector.canSeeFocus(focus, otherProject, focusEntries)) {
                        return true;
                    }
                    ++j;
                }
                break;
            }
        }
        catch (RubyModelException rubyModelException) {
            return false;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static boolean canSeeFocus(IRubyElement focus, RubyProject javaProject, ILoadpathEntry[] focusEntriesForPolymorphicSearch) {
        try {
            int i;
            IPath focusPath;
            if (focus.equals(javaProject)) {
                return true;
            }
            if (focusEntriesForPolymorphicSearch != null) {
                IPath projectPath = javaProject.getProject().getFullPath();
                int i2 = 0;
                int length = focusEntriesForPolymorphicSearch.length;
                while (i2 < length) {
                    ILoadpathEntry entry = focusEntriesForPolymorphicSearch[i2];
                    if (entry.getEntryKind() == 2 && entry.getPath().equals((Object)projectPath)) {
                        return true;
                    }
                    ++i2;
                }
            }
            if (focus instanceof ExternalSourceFolderRoot) {
                focusPath = focus.getPath();
                ILoadpathEntry[] entries = javaProject.getExpandedLoadpath(true);
                i = 0;
                int length = entries.length;
                while (i < length) {
                    ILoadpathEntry entry = entries[i];
                    if (entry.getEntryKind() == 1 && entry.getPath().equals((Object)focusPath)) {
                        return true;
                    }
                    ++i;
                }
                return false;
            }
            focusPath = ((RubyProject)focus).getProject().getFullPath();
            ILoadpathEntry[] entries = javaProject.getExpandedLoadpath(true);
            i = 0;
            int length = entries.length;
            while (i < length) {
                ILoadpathEntry entry = entries[i];
                if (entry.getEntryKind() == 2 && entry.getPath().equals((Object)focusPath)) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        catch (RubyModelException rubyModelException) {
            return false;
        }
    }

    private void initializeIndexLocations() {
        IPath[] projectsAndJars = this.searchScope.enclosingProjectsAndJars();
        IndexManager manager = RubyModelManager.getRubyModelManager().getIndexManager();
        SimpleSet locations = new SimpleSet();
        IRubyElement focus = MatchLocator.projectOrJarFocus(this.pattern);
        if (focus == null) {
            int i = 0;
            while (i < projectsAndJars.length) {
                locations.add(manager.computeIndexLocation(projectsAndJars[i]));
                ++i;
            }
        } else {
            try {
                int length = projectsAndJars.length;
                RubyProject[] projectsCanSeeFocus = new RubyProject[length];
                SimpleSet visitedProjects = new SimpleSet(length);
                int projectIndex = 0;
                SimpleSet jarsToCheck = new SimpleSet(length);
                ILoadpathEntry[] focusEntries = null;
                if (this.pattern instanceof MethodPattern) {
                    RubyProject focusProject = (RubyProject)focus;
                    focusEntries = focusProject.getExpandedLoadpath(true);
                }
                RubyModel model = RubyModelManager.getRubyModelManager().getRubyModel();
                int i = 0;
                while (i < length) {
                    IPath path = projectsAndJars[i];
                    RubyProject project = (RubyProject)IndexSelector.getRubyProject(path, model);
                    if (project != null) {
                        visitedProjects.add(project);
                        if (IndexSelector.canSeeFocus(focus, project, focusEntries)) {
                            locations.add(manager.computeIndexLocation(path));
                            projectsCanSeeFocus[projectIndex++] = project;
                        }
                    } else {
                        jarsToCheck.add(path);
                    }
                    ++i;
                }
                i = 0;
                while (i < projectIndex && jarsToCheck.elementSize > 0) {
                    ILoadpathEntry[] entries = projectsCanSeeFocus[i].getResolvedLoadpath(true);
                    int j = entries.length;
                    while (--j >= 0) {
                        IPath path;
                        ILoadpathEntry entry = entries[j];
                        if (entry.getEntryKind() != 1 || !jarsToCheck.includes(path = entry.getPath())) continue;
                        locations.add(manager.computeIndexLocation(entry.getPath()));
                        jarsToCheck.remove(path);
                    }
                    ++i;
                }
                if (jarsToCheck.elementSize > 0) {
                    IRubyProject[] allProjects = model.getRubyProjects();
                    int i2 = 0;
                    int l = allProjects.length;
                    while (i2 < l && jarsToCheck.elementSize > 0) {
                        RubyProject project = (RubyProject)allProjects[i2];
                        if (!visitedProjects.includes(project)) {
                            ILoadpathEntry[] entries = project.getResolvedLoadpath(true);
                            int j = entries.length;
                            while (--j >= 0) {
                                IPath path;
                                ILoadpathEntry entry = entries[j];
                                if (entry.getEntryKind() != 1 || !jarsToCheck.includes(path = entry.getPath())) continue;
                                locations.add(manager.computeIndexLocation(entry.getPath()));
                                jarsToCheck.remove(path);
                            }
                        }
                        ++i2;
                    }
                }
            }
            catch (RubyModelException rubyModelException) {}
        }
        this.indexLocations = new IPath[locations.elementSize];
        Object[] values = locations.values;
        int count = 0;
        int i = values.length;
        while (--i >= 0) {
            if (values[i] == null) continue;
            this.indexLocations[count++] = (IPath)values[i];
        }
    }

    public IPath[] getIndexLocations() {
        if (this.indexLocations == null) {
            this.initializeIndexLocations();
        }
        return this.indexLocations;
    }

    private static IRubyProject getRubyProject(IPath path, IRubyModel model) {
        IRubyProject project = model.getRubyProject(path.lastSegment());
        if (project.exists()) {
            return project;
        }
        return null;
    }
}

