/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.core.search;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.core.IType;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.core.WorkingCopyOwner;
import org.rubypeople.rdt.core.search.IRubySearchScope;
import org.rubypeople.rdt.core.search.SearchDocument;
import org.rubypeople.rdt.core.search.SearchMatch;
import org.rubypeople.rdt.core.search.SearchParticipant;
import org.rubypeople.rdt.core.search.SearchPattern;
import org.rubypeople.rdt.core.search.SearchRequestor;
import org.rubypeople.rdt.core.search.TypeNameRequestor;
import org.rubypeople.rdt.internal.core.DefaultWorkingCopyOwner;
import org.rubypeople.rdt.internal.core.RubyModelManager;
import org.rubypeople.rdt.internal.core.RubyProject;
import org.rubypeople.rdt.internal.core.RubyScript;
import org.rubypeople.rdt.internal.core.search.HierarchyScope;
import org.rubypeople.rdt.internal.core.search.IndexQueryRequestor;
import org.rubypeople.rdt.internal.core.search.PathCollector;
import org.rubypeople.rdt.internal.core.search.PatternSearchJob;
import org.rubypeople.rdt.internal.core.search.RubySearchParticipant;
import org.rubypeople.rdt.internal.core.search.RubySearchScope;
import org.rubypeople.rdt.internal.core.search.indexing.IIndexConstants;
import org.rubypeople.rdt.internal.core.search.indexing.IndexManager;
import org.rubypeople.rdt.internal.core.search.matching.MatchLocator;
import org.rubypeople.rdt.internal.core.search.matching.TypeDeclarationPattern;
import org.rubypeople.rdt.internal.core.util.CharOperation;
import org.rubypeople.rdt.internal.core.util.Messages;
import org.rubypeople.rdt.internal.core.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicSearchEngine {
    public static final int CLASS_DECL = 1;
    public static final int MODULE_DECL = 2;
    public static final boolean VERBOSE = false;
    private IRubyScript[] workingCopies;
    private WorkingCopyOwner workingCopyOwner;

    public BasicSearchEngine() {
    }

    public BasicSearchEngine(WorkingCopyOwner workingCopyOwner) {
        this.workingCopyOwner = workingCopyOwner;
    }

    public void search(SearchPattern pattern, SearchParticipant[] participants, IRubySearchScope scope, SearchRequestor requestor, IProgressMonitor monitor) throws CoreException {
        this.findMatches(pattern, participants, scope, requestor, monitor);
    }

    public static IRubySearchScope createRubySearchScope(IRubyElement[] elements) {
        return BasicSearchEngine.createRubySearchScope(elements, true);
    }

    public static IRubySearchScope createRubySearchScope(IRubyElement[] elements, boolean includeReferencedProjects) {
        int includeMask = 7;
        if (includeReferencedProjects) {
            includeMask |= 8;
        }
        return BasicSearchEngine.createRubySearchScope(elements, includeMask);
    }

    public static IRubySearchScope createRubySearchScope(IRubyElement[] elements, int includeMask) {
        RubySearchScope scope = new RubySearchScope();
        HashSet visitedProjects = new HashSet(2);
        int i = 0;
        int length = elements.length;
        while (i < length) {
            IRubyElement element = elements[i];
            if (element != null) {
                try {
                    if (element instanceof RubyProject) {
                        scope.add((RubyProject)element, includeMask, visitedProjects);
                    } else {
                        scope.add(element);
                    }
                }
                catch (RubyModelException rubyModelException) {}
            }
            ++i;
        }
        return scope;
    }

    void findMatches(SearchPattern pattern, SearchParticipant[] participants, IRubySearchScope scope, SearchRequestor requestor, IProgressMonitor monitor) throws CoreException {
        if (monitor != null && monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        try {
            if (monitor != null) {
                monitor.beginTask(Messages.engine_searching, 100);
            }
            if (participants == null) {
                return;
            }
            IndexManager indexManager = RubyModelManager.getRubyModelManager().getIndexManager();
            requestor.beginReporting();
            int i = 0;
            int l = participants.length;
            while (i < l) {
                SubProgressMonitor subMonitor;
                if (monitor != null && monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                SearchParticipant participant = participants[i];
                SubProgressMonitor subProgressMonitor = subMonitor = monitor == null ? null : new SubProgressMonitor(monitor, 1000);
                if (subMonitor != null) {
                    subMonitor.beginTask("", 1000);
                }
                try {
                    String[] indexMatchPaths;
                    if (subMonitor != null) {
                        subMonitor.subTask(Messages.bind(Messages.engine_searching_indexing, new String[]{participant.getDescription()}));
                    }
                    participant.beginSearching();
                    requestor.enterParticipant(participant);
                    PathCollector pathCollector = new PathCollector();
                    indexManager.performConcurrentJob(new PatternSearchJob(pattern, participant, scope, pathCollector), 3, (IProgressMonitor)subMonitor);
                    if (monitor != null && monitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    if (subMonitor != null) {
                        subMonitor.subTask(Messages.bind(Messages.engine_searching_matching, new String[]{participant.getDescription()}));
                    }
                    if ((indexMatchPaths = pathCollector.getPaths()) != null) {
                        pathCollector = null;
                        int indexMatchLength = indexMatchPaths.length;
                        SearchDocument[] indexMatches = new SearchDocument[indexMatchLength];
                        int j = 0;
                        while (j < indexMatchLength) {
                            indexMatches[j] = participant.getDocument(indexMatchPaths[j]);
                            ++j;
                        }
                        SearchDocument[] matches = MatchLocator.addWorkingCopies(pattern, indexMatches, this.getWorkingCopies(), participant);
                        participant.locateMatches(matches, pattern, scope, requestor, (IProgressMonitor)subMonitor);
                    }
                }
                finally {
                    requestor.exitParticipant(participant);
                    participant.doneSearching();
                }
                ++i;
            }
        }
        finally {
            requestor.endReporting();
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    private IRubyScript[] getWorkingCopies() {
        int length;
        IRubyScript[] copies;
        if (this.workingCopies != null) {
            if (this.workingCopyOwner == null) {
                copies = RubyModelManager.getRubyModelManager().getWorkingCopies(DefaultWorkingCopyOwner.PRIMARY, false);
                if (copies == null) {
                    copies = this.workingCopies;
                } else {
                    IRubyScript unit;
                    HashMap<IPath, IRubyScript> pathToCUs = new HashMap<IPath, IRubyScript>();
                    int i = 0;
                    int length2 = copies.length;
                    while (i < length2) {
                        unit = copies[i];
                        pathToCUs.put(unit.getPath(), unit);
                        ++i;
                    }
                    i = 0;
                    length2 = this.workingCopies.length;
                    while (i < length2) {
                        unit = this.workingCopies[i];
                        pathToCUs.put(unit.getPath(), unit);
                        ++i;
                    }
                    length = pathToCUs.size();
                    copies = new IRubyScript[length];
                    pathToCUs.values().toArray(copies);
                }
            } else {
                copies = this.workingCopies;
            }
        } else {
            copies = this.workingCopyOwner != null ? RubyModelManager.getRubyModelManager().getWorkingCopies(this.workingCopyOwner, true) : RubyModelManager.getRubyModelManager().getWorkingCopies(DefaultWorkingCopyOwner.PRIMARY, false);
        }
        if (copies == null) {
            return null;
        }
        IRubyScript[] result = null;
        length = copies.length;
        int index = 0;
        int i = 0;
        while (i < length) {
            RubyScript copy = (RubyScript)copies[i];
            try {
                if (!copy.isPrimary() || copy.hasUnsavedChanges() || copy.hasResourceChanged()) {
                    if (result == null) {
                        result = new IRubyScript[length];
                    }
                    result[index++] = copy;
                }
            }
            catch (RubyModelException rubyModelException) {}
            ++i;
        }
        if (index != length && result != null) {
            IRubyScript[] iRubyScriptArray = result;
            result = new IRubyScript[index];
            System.arraycopy(iRubyScriptArray, 0, result, 0, index);
        }
        return result;
    }

    public static SearchParticipant getDefaultSearchParticipant() {
        return new RubySearchParticipant();
    }

    public static IRubySearchScope createWorkspaceScope() {
        return RubyModelManager.getRubyModelManager().getWorkspaceScope();
    }

    public static Collection<IType> findType(String simpleTypeName) {
        SearchPattern pattern = SearchPattern.createPattern(5, "*" + simpleTypeName + "*", 0, 2);
        SearchParticipant[] participants = new SearchParticipant[]{BasicSearchEngine.getDefaultSearchParticipant()};
        IRubySearchScope scope = BasicSearchEngine.createWorkspaceScope();
        TypeRequestor requestor = new TypeRequestor();
        try {
            new BasicSearchEngine().search(pattern, participants, scope, requestor, null);
        }
        catch (CoreException e) {
            RubyCore.log((Exception)((Object)e));
        }
        ArrayList<IType> types = new ArrayList<IType>();
        List<IType> matches = requestor.getTypes();
        for (IType type : matches) {
            if (!Util.getSimpleName(type.getElementName()).equals(simpleTypeName)) continue;
            types.add(type);
        }
        return types;
    }

    public void searchAllTypeNames(char[] namespace, char[] typeName, int matchRule, int searchFor, IRubySearchScope scope, final TypeNameRequestor nameRequestor, int waitingPolicy, IProgressMonitor progressMonitor) throws RubyModelException {
        int copiesLength;
        char typeSuffix;
        if ((namespace == null || namespace.length == 0) && typeName != null && typeName.length == 0) {
            return;
        }
        IndexManager indexManager = RubyModelManager.getRubyModelManager().getIndexManager();
        switch (searchFor) {
            case 4: {
                typeSuffix = 'C';
                break;
            }
            case 5: {
                typeSuffix = 'M';
                break;
            }
            default: {
                typeSuffix = '\u0000';
            }
        }
        TypeDeclarationPattern pattern = new TypeDeclarationPattern(null, this.getEnclosingTypeNames(namespace), typeName, typeSuffix, matchRule);
        final HashSet<String> workingCopyPaths = new HashSet<String>();
        String workingCopyPath = null;
        IRubyScript[] copies = this.getWorkingCopies();
        int n = copiesLength = copies == null ? 0 : copies.length;
        if (copies != null) {
            if (copiesLength == 1) {
                workingCopyPath = copies[0].getPath().toString();
            } else {
                int i = 0;
                while (i < copiesLength) {
                    IRubyScript workingCopy = copies[i];
                    workingCopyPaths.add(workingCopy.getPath().toString());
                    ++i;
                }
            }
        }
        final String singleWkcpPath = workingCopyPath;
        IndexQueryRequestor searchRequestor = new IndexQueryRequestor(){

            public boolean acceptIndexMatch(String documentPath, SearchPattern indexRecord, SearchParticipant participant) {
                TypeDeclarationPattern record = (TypeDeclarationPattern)indexRecord;
                if (record.enclosingTypeNames == IIndexConstants.ONE_ZERO_CHAR) {
                    return true;
                }
                switch (copiesLength) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        if (!singleWkcpPath.equals(documentPath)) break;
                        return true;
                    }
                    default: {
                        if (!workingCopyPaths.contains(documentPath)) break;
                        return true;
                    }
                }
                if (BasicSearchEngine.this.match(record.typeSuffix, record.modifiers)) {
                    nameRequestor.acceptType(record.typeSuffix == 'M', record.pkg, record.simpleName, record.enclosingTypeNames, documentPath);
                }
                return true;
            }
        };
        try {
            if (progressMonitor != null) {
                progressMonitor.beginTask(Messages.engine_searching, 100);
            }
            indexManager.performConcurrentJob(new PatternSearchJob(pattern, BasicSearchEngine.getDefaultSearchParticipant(), scope, searchRequestor), waitingPolicy, (IProgressMonitor)(progressMonitor == null ? null : new SubProgressMonitor(progressMonitor, 100)));
            if (copies != null) {
                int i = 0;
                while (i < copiesLength) {
                    IRubyScript workingCopy = copies[i];
                    if (scope.encloses(workingCopy)) {
                        String path = workingCopy.getPath().toString();
                        if (workingCopy.isConsistent()) {
                            char[] packageDeclaration = CharOperation.NO_CHAR;
                            IType[] allTypes = workingCopy.getAllTypes();
                            int j = 0;
                            int allTypesLength = allTypes.length;
                            while (j < allTypesLength) {
                                char[][] enclosingTypeNames;
                                IType type = allTypes[j];
                                IRubyElement parent = type.getParent();
                                if (parent instanceof IType) {
                                    char[] parentQualifiedName = ((IType)parent).getTypeQualifiedName("::").toCharArray();
                                    enclosingTypeNames = CharOperation.splitOn("::", parentQualifiedName);
                                } else {
                                    enclosingTypeNames = CharOperation.NO_CHAR_CHAR;
                                }
                                char[] simpleName = type.getElementName().toCharArray();
                                int kind = type.isClass() ? 1 : 2;
                                if (this.match(typeSuffix, namespace, typeName, matchRule, kind, this.squish(enclosingTypeNames), simpleName)) {
                                    nameRequestor.acceptType(type.isModule(), packageDeclaration, simpleName, enclosingTypeNames, path);
                                }
                                ++j;
                            }
                        }
                    }
                    ++i;
                }
            }
        }
        finally {
            if (progressMonitor != null) {
                progressMonitor.done();
            }
        }
    }

    private char[] squish(char[][] enclosingTypeNames) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < enclosingTypeNames.length) {
            if (i != 0) {
                buffer.append("::");
            }
            buffer.append(enclosingTypeNames[i]);
            ++i;
        }
        return buffer.toString().toCharArray();
    }

    private char[][] getEnclosingTypeNames(char[] packageName) {
        if (packageName == null || packageName.length == 0) {
            return null;
        }
        String raw = new String(packageName);
        String[] parts = Util.getTypeNameParts(raw);
        char[][] enclosing = new char[parts.length][];
        int i = 0;
        while (i < parts.length) {
            enclosing[i] = parts[i].toCharArray();
            ++i;
        }
        return enclosing;
    }

    boolean match(char patternTypeSuffix, int modifiers) {
        switch (patternTypeSuffix) {
            case 'C': {
                return (modifiers & 1) == 0;
            }
            case '\u0000': {
                return true;
            }
            case 'M': {
                return (modifiers & 1) != 0;
            }
        }
        return true;
    }

    boolean match(char patternTypeSuffix, char[] patternPkg, char[] patternTypeName, int matchRule, int typeKind, char[] pkg, char[] typeName) {
        switch (patternTypeSuffix) {
            case 'C': {
                if (typeKind == 1) break;
                return false;
            }
            case '\u0000': {
                if (typeKind == 1 || typeKind == 2) break;
                return false;
            }
            case 'M': {
                if (typeKind == 2) break;
                return false;
            }
        }
        if (patternPkg != null && !this.doMatch(patternPkg, pkg, matchRule)) {
            return false;
        }
        return patternTypeName == null || this.doMatch(patternTypeName, typeName, matchRule);
    }

    private boolean isCaseSensitive(int matchRule) {
        return (matchRule & 8) != 0;
    }

    private boolean doMatch(char[] patternTypeName, char[] typeName, int matchRule) {
        boolean matchFirstChar;
        boolean isCaseSensitive = this.isCaseSensitive(matchRule);
        boolean isCamelCase = (matchRule & 0x80) != 0;
        int matchMode = matchRule & 7;
        if (!isCaseSensitive && !isCamelCase) {
            patternTypeName = CharOperation.toLowerCase(patternTypeName);
        }
        boolean bl = matchFirstChar = !isCaseSensitive || patternTypeName[0] == typeName[0];
        if (isCamelCase && matchFirstChar && CharOperation.camelCaseMatch(patternTypeName, typeName)) {
            return true;
        }
        switch (matchMode) {
            case 0: {
                if (!isCamelCase) {
                    return matchFirstChar && CharOperation.equals(patternTypeName, typeName, isCaseSensitive);
                }
            }
            case 1: {
                return matchFirstChar && CharOperation.prefixEquals(patternTypeName, typeName, isCaseSensitive);
            }
            case 2: {
                return CharOperation.match(patternTypeName, typeName, isCaseSensitive);
            }
            case 4: {
                return true;
            }
        }
        return true;
    }

    public static String getMatchRuleString(int matchRule) {
        if (matchRule == 0) {
            return "R_EXACT_MATCH";
        }
        StringBuffer buffer = new StringBuffer();
        int i = 1;
        while (i <= 8) {
            int bit = matchRule & 1 << i - 1;
            if (bit != 0 && buffer.length() > 0) {
                buffer.append(" | ");
            }
            switch (bit) {
                case 1: {
                    buffer.append("R_PREFIX_MATCH");
                    break;
                }
                case 8: {
                    buffer.append("R_CASE_SENSITIVE");
                    break;
                }
                case 32: {
                    buffer.append("R_EQUIVALENT_MATCH");
                    break;
                }
                case 16: {
                    buffer.append("R_ERASURE_MATCH");
                    break;
                }
                case 64: {
                    buffer.append("R_FULL_MATCH");
                    break;
                }
                case 2: {
                    buffer.append("R_PATTERN_MATCH");
                    break;
                }
                case 4: {
                    buffer.append("R_REGEXP_MATCH");
                    break;
                }
                case 128: {
                    buffer.append("R_CAMELCASE_MATCH");
                }
            }
            ++i;
        }
        return buffer.toString();
    }

    public static IRubySearchScope createHierarchyScope(IType type) throws RubyModelException {
        return BasicSearchEngine.createHierarchyScope(type, DefaultWorkingCopyOwner.PRIMARY);
    }

    public static IRubySearchScope createHierarchyScope(IType type, WorkingCopyOwner owner) throws RubyModelException {
        return new HierarchyScope(type, owner);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TypeRequestor
    extends SearchRequestor {
        private List<IType> types = new ArrayList<IType>();

        private TypeRequestor() {
        }

        @Override
        public void acceptSearchMatch(SearchMatch match) throws CoreException {
            Object element = match.getElement();
            this.types.add((IType)element);
        }

        public List<IType> getTypes() {
            return this.types;
        }
    }
}

