/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.core.pmd;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.rubypeople.rdt.internal.core.pmd.Match;
import org.rubypeople.rdt.internal.core.pmd.MatchAlgorithm;
import org.rubypeople.rdt.internal.core.pmd.TokenEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MatchCollector {
    private MatchAlgorithm ma;
    private Map<Match.MatchCode, Match> startMap = new HashMap<Match.MatchCode, Match>();
    private Map fileMap = new HashMap();

    public MatchCollector(MatchAlgorithm ma) {
        this.ma = ma;
    }

    public void collect(List marks) {
        int i = 0;
        while (i < marks.size() - 1) {
            TokenEntry mark1 = (TokenEntry)marks.get(i);
            int j = i + 1;
            while (j < marks.size()) {
                int dupes;
                TokenEntry mark2 = (TokenEntry)marks.get(j);
                int diff = mark1.getIndex() - mark2.getIndex();
                if (-diff >= this.ma.getMinimumTileSize() && !this.hasPreviousDupe(mark1, mark2) && (dupes = this.countDuplicateTokens(mark1, mark2)) >= this.ma.getMinimumTileSize() && diff + dupes < 1) {
                    this.determineMatch(mark1, mark2, dupes);
                }
                ++j;
            }
            ++i;
        }
    }

    public List<Match> getMatches() {
        ArrayList<Match> matchList = new ArrayList<Match>(this.startMap.values());
        Collections.sort(matchList);
        HashSet<Match.MatchCode> matchSet = new HashSet<Match.MatchCode>();
        Match.MatchCode matchCode = new Match.MatchCode();
        int i = matchList.size();
        while (i > 1) {
            Match match1 = (Match)matchList.get(i - 1);
            TokenEntry mark1 = match1.getMarkSet().iterator().next();
            matchSet.clear();
            matchSet.add(match1.getMatchCode());
            int j = i - 1;
            while (j > 0) {
                int dupes;
                Match match2 = (Match)matchList.get(j - 1);
                if (match1.getTokenCount() != match2.getTokenCount()) break;
                TokenEntry mark22 = null;
                for (TokenEntry mark22 : match2.getMarkSet()) {
                    if (mark22 != mark1) break;
                }
                if ((dupes = this.countDuplicateTokens(mark1, mark22)) < match1.getTokenCount()) break;
                matchSet.add(match2.getMatchCode());
                match1.getMarkSet().addAll(match2.getMarkSet());
                matchList.remove(i - 2);
                --i;
                --j;
            }
            if (matchSet.size() != 1) {
                Set<TokenEntry> pruned = match1.getMarkSet();
                boolean done = false;
                ArrayList<TokenEntry> a1 = new ArrayList<TokenEntry>(match1.getMarkSet());
                Collections.sort(a1);
                int outer = 0;
                while (outer < a1.size() - 1 && !done) {
                    TokenEntry cmark1 = a1.get(outer);
                    int inner = outer + 1;
                    while (inner < a1.size() && !done) {
                        TokenEntry cmark2 = a1.get(inner);
                        matchCode.setFirst(cmark1.getIndex());
                        matchCode.setSecond(cmark2.getIndex());
                        if (!matchSet.contains(matchCode)) {
                            if (pruned.size() > 2) {
                                pruned.remove(cmark2);
                            }
                            if (pruned.size() == 2) {
                                done = true;
                            }
                        }
                        ++inner;
                    }
                    ++outer;
                }
            }
            --i;
        }
        return matchList;
    }

    private void determineMatch(TokenEntry mark1, TokenEntry mark2, int dupes) {
        Match match = new Match(dupes, mark1, mark2);
        String fileKey = String.valueOf(mark1.getTokenSrcID()) + mark2.getTokenSrcID();
        ArrayList<Match> pairMatches = (ArrayList<Match>)this.fileMap.get(fileKey);
        if (pairMatches == null) {
            pairMatches = new ArrayList<Match>();
            this.fileMap.put(fileKey, pairMatches);
        }
        boolean add = true;
        int i = 0;
        while (i < pairMatches.size()) {
            Match other = (Match)pairMatches.get(i);
            if (other.getFirstMark().getIndex() + other.getTokenCount() - mark1.getIndex() > 0) {
                boolean ordered;
                boolean bl = ordered = other.getSecondMark().getIndex() - mark2.getIndex() < 0;
                if (ordered && other.getEndIndex() - mark2.getIndex() > 0 || !ordered && match.getEndIndex() - other.getSecondMark().getIndex() > 0) {
                    if (other.getTokenCount() >= match.getTokenCount()) {
                        add = false;
                        break;
                    }
                    pairMatches.remove(i);
                    this.startMap.remove(other.getMatchCode());
                }
            }
            ++i;
        }
        if (add) {
            pairMatches.add(match);
            this.startMap.put(match.getMatchCode(), match);
        }
    }

    private boolean hasPreviousDupe(TokenEntry mark1, TokenEntry mark2) {
        if (mark1.getIndex() == 0) {
            return false;
        }
        return !this.matchEnded(this.ma.tokenAt(-1, mark1), this.ma.tokenAt(-1, mark2));
    }

    private int countDuplicateTokens(TokenEntry mark1, TokenEntry mark2) {
        int index = 0;
        while (!this.matchEnded(this.ma.tokenAt(index, mark1), this.ma.tokenAt(index, mark2))) {
            ++index;
        }
        return index;
    }

    private boolean matchEnded(TokenEntry token1, TokenEntry token2) {
        return token1.getIdentifier() != token2.getIdentifier() || token1 == TokenEntry.EOF || token2 == TokenEntry.EOF;
    }
}

